/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.test.chapterIV.builders;

import be.ehealth.technicalconnector.utils.DateUtils;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDCONTENT;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDCONTENTschemes;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDHCPARTY;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDHCPARTYschemes;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDITEM;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDITEMschemes;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDSEX;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDSEXvalues;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDTRANSACTION;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDTRANSACTIONschemes;
import be.fgov.ehealth.standards.kmehr.dt.v1.TextType;
import be.fgov.ehealth.standards.kmehr.id.v1.IDHCPARTY;
import be.fgov.ehealth.standards.kmehr.id.v1.IDHCPARTYschemes;
import be.fgov.ehealth.standards.kmehr.id.v1.IDINSURANCE;
import be.fgov.ehealth.standards.kmehr.id.v1.IDINSURANCEschemes;
import be.fgov.ehealth.standards.kmehr.id.v1.IDKMEHR;
import be.fgov.ehealth.standards.kmehr.id.v1.IDKMEHRschemes;
import be.fgov.ehealth.standards.kmehr.id.v1.IDPATIENT;
import be.fgov.ehealth.standards.kmehr.id.v1.IDPATIENTschemes;
import be.fgov.ehealth.standards.kmehr.schema.v1.AuthorType;
import be.fgov.ehealth.standards.kmehr.schema.v1.ContentType;
import be.fgov.ehealth.standards.kmehr.schema.v1.FolderType;
import be.fgov.ehealth.standards.kmehr.schema.v1.HcpartyType;
import be.fgov.ehealth.standards.kmehr.schema.v1.ItemType;
import be.fgov.ehealth.standards.kmehr.schema.v1.MemberinsuranceType;
import be.fgov.ehealth.standards.kmehr.schema.v1.PersonType;
import be.fgov.ehealth.standards.kmehr.schema.v1.SexType;
import be.fgov.ehealth.standards.kmehr.schema.v1.TransactionType;


/**
 * Mock used for {@link FolderBuilderTest}
 * 
 * @author EHP
 * 
 */
public class FolderTypeMock {

    /**
     * Creates a FolderType object as it should be created from the example file
     * "/examples/FolderBuilderTest.testBuilderStringFromFolderType.xml" with {@link FolderBuilder}
     * 
     * @return a correct FolderType object with information from the file
     */
    public FolderType getFolderType() {
        FolderType folderType = new FolderType();
        PersonType personType = new PersonType();
        SexType sexType = new SexType();
        CDSEX cdSex = new CDSEX();
        IDPATIENT idPatient = new IDPATIENT();
        MemberinsuranceType memberInsuranceType = new MemberinsuranceType();
        IDINSURANCE idInsurance = new IDINSURANCE();
        TransactionType transactionType = new TransactionType();
        IDKMEHR idTransaction = new IDKMEHR();
        AuthorType authorType = new AuthorType();
        HcpartyType hcPartyType = new HcpartyType();
        IDHCPARTY idHcParty = new IDHCPARTY();
        IDHCPARTY idHcParty2 = new IDHCPARTY();
        CDHCPARTY cdHcParty = new CDHCPARTY();
        IDKMEHR idTransactionItem = new IDKMEHR();
        ItemType[] transactionItem = new ItemType[5];
        CDITEM cdTransactionItem = new CDITEM();
        ContentType contentTransItem = new ContentType();
        CDCONTENT cdContent = new CDCONTENT();

        // HcParty Author
        idHcParty.setS(IDHCPARTYschemes.ID_HCPARTY);
        idHcParty.setSV("1.0");
        idHcParty.setValue("011530231003");
        idHcParty2.setS(IDHCPARTYschemes.INSS);
        idHcParty2.setSV("1.0");
        idHcParty2.setValue("49112002395");
        hcPartyType.getIds().add(idHcParty);
        hcPartyType.getIds().add(idHcParty2);
        cdHcParty.setS(CDHCPARTYschemes.CD_HCPARTY);
        cdHcParty.setSV("1.0");
        cdHcParty.setValue("persphysician");
        hcPartyType.getCds().add(cdHcParty);
        hcPartyType.setFirstname("Pierre");
        hcPartyType.setFamilyname("Durand");
        authorType.getHcparties().add(hcPartyType);
        // Patient
        idPatient.setSV("1.0");
        idPatient.setS(IDPATIENTschemes.ID_PATIENT);
        cdSex.setSV("1.0");
        cdSex.setS("CD-SEX");
        cdSex.setValue(CDSEXvalues.MALE);
        sexType.setCd(cdSex);
        idInsurance.setSV("1.0");
        idInsurance.setS(IDINSURANCEschemes.ID_INSURANCE);
        idInsurance.setValue("301");
        memberInsuranceType.setId(idInsurance);
        memberInsuranceType.setMembership("1234567890123".toString());
        idPatient.setValue("82051234978");
        personType.setInsurancymembership(memberInsuranceType);
        personType.getIds().add(idPatient);
        personType.getFirstnames().add("Justin");
        personType.setFamilyname("Bridou");
        personType.setSex(sexType);
        folderType.setPatient(personType);
        // Transaction Id
        IDKMEHR transId = new IDKMEHR();
        transId.setSV("1.0");
        transId.setS(IDKMEHRschemes.ID_KMEHR);
        transId.setValue("1");
        folderType.getIds().add(transId);
        // transaction id and type
        idTransaction.setS(IDKMEHRschemes.ID_KMEHR);
        idTransaction.setSV("1.0");
        idTransaction.setValue("1");
        CDTRANSACTION cdTransaction = new CDTRANSACTION();
        CDTRANSACTION cdTransaction2 = new CDTRANSACTION();
        cdTransaction.setS(CDTRANSACTIONschemes.CD_TRANSACTION);
        cdTransaction.setSV("1.3");
        cdTransaction.setValue("medicaladvisoragreement");
        cdTransaction2.setS(CDTRANSACTIONschemes.CD_TRANSACTION_MAA);
        cdTransaction2.setSV("1.0");
        cdTransaction2.setValue("consultationrequest");
        transactionType.getIds().add(idTransaction);
        transactionType.getCds().add(cdTransaction);
        transactionType.getCds().add(cdTransaction2);
        transactionType.setDate(DateUtils.parseDate("2010-11-12"));
        transactionType.setTime(DateUtils.parseTime("10:05:00"));
        transactionType.setAuthor(authorType);
        transactionType.setIscomplete(true);
        transactionType.setIsvalidated(true);

        idTransactionItem.setSV("1.0");
        idTransactionItem.setS(IDKMEHRschemes.ID_KMEHR);
        idTransactionItem.setValue("1");
        cdTransactionItem.setSV("1.0");
        cdTransactionItem.setValue("agreementtype");
        cdTransactionItem.setS(CDITEMschemes.CD_ITEM_MAA);
        cdContent.setS(CDCONTENTschemes.CD_MAA_TYPE);
        cdContent.setSV("1.0");
        cdContent.setValue("chapter4");
        contentTransItem.getCds().add(cdContent);
        transactionItem[0] = new ItemType();
        transactionItem[0].getIds().add(idTransactionItem);
        transactionItem[0].getCds().add(cdTransactionItem);
        transactionItem[0].getContents().add(contentTransItem);
        transactionType.getItem().add(transactionItem[0]);

        idTransactionItem = new IDKMEHR();
        idTransactionItem.setSV("1.0");
        idTransactionItem.setS(IDKMEHRschemes.ID_KMEHR);
        idTransactionItem.setValue("2");
        cdTransactionItem = new CDITEM();
        cdTransactionItem.setSV("1.0");
        cdTransactionItem.setValue("consultationstartdate");
        cdTransactionItem.setS(CDITEMschemes.CD_ITEM_MAA);
        contentTransItem = new ContentType();
        contentTransItem.setDate(DateUtils.parseDate("2010-08-06"));
        transactionItem[1] = new ItemType();
        transactionItem[1].getIds().add(idTransactionItem);
        transactionItem[1].getCds().add(cdTransactionItem);
        transactionItem[1].getContents().add(contentTransItem);
        transactionType.getItem().add(transactionItem[1]);

        idTransactionItem = new IDKMEHR();
        idTransactionItem.setSV("1.0");
        idTransactionItem.setS(IDKMEHRschemes.ID_KMEHR);
        idTransactionItem.setValue("3");
        cdTransactionItem = new CDITEM();
        cdTransactionItem.setSV("1.0");
        cdTransactionItem.setValue("consultationenddate");
        cdTransactionItem.setS(CDITEMschemes.CD_ITEM_MAA);
        contentTransItem = new ContentType();
        contentTransItem.setDate(DateUtils.parseDate("2011-08-06"));
        transactionItem[2] = new ItemType();
        transactionItem[2].getIds().add(idTransactionItem);
        transactionItem[2].getCds().add(cdTransactionItem);
        transactionItem[2].getContents().add(contentTransItem);
        transactionType.getItem().add(transactionItem[2]);

        idTransactionItem = new IDKMEHR();
        idTransactionItem.setSV("1.0");
        idTransactionItem.setS(IDKMEHRschemes.ID_KMEHR);
        idTransactionItem.setValue("4");
        cdTransactionItem = new CDITEM();
        cdTransactionItem.setSV("1.0");
        cdTransactionItem.setValue("careproviderreference");
        cdTransactionItem.setS(CDITEMschemes.CD_ITEM_MAA);
        contentTransItem = new ContentType();
        TextType textType = new TextType();
        textType.setL("FR");
        textType.setValue("my request 123");
        contentTransItem.getTexts().add(textType);
        transactionItem[3] = new ItemType();
        transactionItem[3].getIds().add(idTransactionItem);
        transactionItem[3].getCds().add(cdTransactionItem);
        transactionItem[3].getContents().add(contentTransItem);
        transactionType.getItem().add(transactionItem[3]);

        idTransactionItem = new IDKMEHR();
        idTransactionItem.setSV("1.0");
        idTransactionItem.setS(IDKMEHRschemes.ID_KMEHR);
        idTransactionItem.setValue("5");
        cdTransactionItem = new CDITEM();
        cdTransactionItem.setSV("1.0");
        cdTransactionItem.setValue("chapter4reference");
        cdTransactionItem.setS(CDITEMschemes.CD_ITEM_MAA);
        contentTransItem = new ContentType();
        cdContent = new CDCONTENT();
        cdContent.setSV("2010-08-10");
        cdContent.setS(CDCONTENTschemes.CD_CHAPTER_4_PARAGRAPH);
        cdContent.setValue("160101");
        contentTransItem.getCds().add(cdContent);
        transactionItem[4] = new ItemType();
        transactionItem[4].getIds().add(idTransactionItem);
        transactionItem[4].getCds().add(cdTransactionItem);
        transactionItem[4].getContents().add(contentTransItem);
        transactionType.getItem().add(transactionItem[4]);


        folderType.getTransactions().add(transactionType);

        return folderType;
    }
}
