/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.civicsv2.session.impl;

import be.ehealth.businessconnector.civicsv2.session.CivicsSessionService;
import be.ehealth.technicalconnector.config.impl.ConfigurationModuleBootstrap;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.session.Session;
import be.ehealth.technicalconnector.utils.impl.JaxbContextFactory;
import be.ehealth.technicalconnector.validator.SessionValidator;
import be.ehealth.technicalconnector.ws.ServiceFactory;
import be.ehealth.technicalconnector.ws.domain.GenericRequest;
import be.fgov.ehealth.samcivics.schemas.v2.FindCNKRequest;
import be.fgov.ehealth.samcivics.schemas.v2.FindCNKResponse;
import be.fgov.ehealth.samcivics.schemas.v2.FindParagraphRequest;
import be.fgov.ehealth.samcivics.schemas.v2.FindParagraphResponse;
import be.fgov.ehealth.samcivics.schemas.v2.FindParagraphTextRequest;
import be.fgov.ehealth.samcivics.schemas.v2.FindParagraphTextResponse;
import be.fgov.ehealth.samcivics.schemas.v2.FindPublicCNKRequest;
import be.fgov.ehealth.samcivics.schemas.v2.FindPublicCNKResponse;
import be.fgov.ehealth.samcivics.schemas.v2.FindReimbursementConditionsRequest;
import be.fgov.ehealth.samcivics.schemas.v2.FindReimbursementConditionsResponse;
import be.fgov.ehealth.samcivics.schemas.v2.GetAddedDocumentsRequest;
import be.fgov.ehealth.samcivics.schemas.v2.GetAddedDocumentsResponse;
import be.fgov.ehealth.samcivics.schemas.v2.GetParagraphExclusionsRequest;
import be.fgov.ehealth.samcivics.schemas.v2.GetParagraphExclusionsResponse;
import be.fgov.ehealth.samcivics.schemas.v2.GetParagraphIncludedSpecialtiesRequest;
import be.fgov.ehealth.samcivics.schemas.v2.GetParagraphIncludedSpecialtiesResponse;
import be.fgov.ehealth.samcivics.schemas.v2.GetProfessionalAuthorizationsRequest;
import be.fgov.ehealth.samcivics.schemas.v2.GetProfessionalAuthorizationsResponse;
import javax.xml.soap.SOAPException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CivicsSessionServiceImpl
implements CivicsSessionService,
ConfigurationModuleBootstrap.ModuleBootstrapHook {
    private SessionValidator sessionValidator;
    private static final Logger LOG = LoggerFactory.getLogger(CivicsSessionServiceImpl.class);

    public CivicsSessionServiceImpl(SessionValidator sessionValidator) throws TechnicalConnectorException {
        this.sessionValidator = sessionValidator;
        if (!Session.getInstance().hasValidSession()) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.NO_VALID_SESSION, new Object[0]);
        }
    }

    public CivicsSessionServiceImpl() {
        LOG.debug("creating CivicsSessionServiceImpl for bootstrapping purposes");
    }

    @Override
    public FindParagraphTextResponse findParagraphText(FindParagraphTextRequest request) throws TechnicalConnectorException {
        return this.executeOperation(request, "urn:be:fgov:ehealth:civics:service:v2:findParagraphText", FindParagraphTextResponse.class);
    }

    @Override
    public GetParagraphExclusionsResponse getParagraphExclusions(GetParagraphExclusionsRequest request) throws TechnicalConnectorException {
        return this.executeOperation(request, "urn:be:fgov:ehealth:civics:service:v2:getParagraphExclusions", GetParagraphExclusionsResponse.class);
    }

    @Override
    public GetParagraphIncludedSpecialtiesResponse getParagraphIncludedSpecialities(GetParagraphIncludedSpecialtiesRequest request) throws TechnicalConnectorException {
        return this.executeOperation(request, "urn:be:fgov:ehealth:civics:service:v2:getParagraphIncludedSpecialities", GetParagraphIncludedSpecialtiesResponse.class);
    }

    @Override
    public GetProfessionalAuthorizationsResponse getProfessionalAuthorizations(GetProfessionalAuthorizationsRequest request) throws TechnicalConnectorException {
        return this.executeOperation(request, "urn:be:fgov:ehealth:civics:service:v2:getProfessionalAuthorizations", GetProfessionalAuthorizationsResponse.class);
    }

    @Override
    public GetAddedDocumentsResponse getAddedDocuments(GetAddedDocumentsRequest request) throws TechnicalConnectorException {
        return this.executeOperation(request, "urn:be:fgov:ehealth:civics:service:v2:getAddedDocuments", GetAddedDocumentsResponse.class);
    }

    @Override
    public FindReimbursementConditionsResponse findReimbursementConditions(FindReimbursementConditionsRequest request) throws TechnicalConnectorException {
        return this.executeOperation(request, "urn:be:fgov:ehealth:civics:service:v2:findReimbursementConditions", FindReimbursementConditionsResponse.class);
    }

    @Override
    public FindParagraphResponse findParagraph(FindParagraphRequest request) throws TechnicalConnectorException {
        return this.executeOperation(request, "urn:be:fgov:ehealth:civics:service:v2:findParagraph", FindParagraphResponse.class);
    }

    @Override
    public FindCNKResponse findCNK(FindCNKRequest request) throws TechnicalConnectorException {
        return this.executeOperation(request, "urn:be:fgov:ehealth:civics:service:v2:findCNK", FindCNKResponse.class);
    }

    @Override
    public FindPublicCNKResponse findPublicCNK(FindPublicCNKRequest request) throws TechnicalConnectorException {
        return this.executeOperation(request, "urn:be:fgov:ehealth:civics:service:v2:findPublicCNK", FindPublicCNKResponse.class);
    }

    private <T> T executeOperation(Object request, String operation, Class<T> clazz) throws TechnicalConnectorException {
        try {
            this.sessionValidator.validateSession();
            GenericRequest service = be.ehealth.businessconnector.civicsv2.service.ServiceFactory.getCivicsService(Session.getInstance().getSession().getSAMLToken(), operation);
            service.setPayload(request);
            return (T)ServiceFactory.getGenericWsSender().send(service).asObject(clazz);
        }
        catch (SOAPException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, new Object[]{e.getMessage()});
        }
    }

    public void bootstrap() {
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindCNKRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindCNKResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindParagraphRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindParagraphResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindParagraphTextRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindParagraphTextResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindReimbursementConditionsRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindReimbursementConditionsResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetAddedDocumentsRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetAddedDocumentsResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetParagraphExclusionsRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetParagraphExclusionsResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetParagraphIncludedSpecialtiesRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetParagraphIncludedSpecialtiesResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetProfessionalAuthorizationsRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetProfessionalAuthorizationsResponse.class});
    }
}

