/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.test.civicsv2.validator;

import static org.junit.Assert.assertTrue;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;

import be.ehealth.businessconnector.civicsv2.validator.XmlValidator;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.ehealth.technicalconnector.utils.MarshallerHelper;
import be.fgov.ehealth.samcivics.schemas.v2.FindCNKResponse;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.RestoreSystemProperties;


/**
 * tests the class XmlValidator.
 * 
 * @author EH076
 * 
 * @since
 * 
 */
public class XmlValidatorTest {


    @ClassRule
    public static RestoreSystemProperties restoreSystemPropertiesRule = new RestoreSystemProperties();


    /**
     * Test method for {@link be.ehealth.businessconnector.civicsv2.validator.XmlValidator#validateXml(java.lang.Object)}.
     */
    @Test
    public void testValidateFindCNKResponse() throws TechnicalConnectorException, FileNotFoundException {
        InputStream resourceAsStream = ConnectorIOUtils.getResourceAsStream("/examples/findCNKResponse.xml");
        MarshallerHelper<FindCNKResponse, FindCNKResponse> helper = new MarshallerHelper<FindCNKResponse, FindCNKResponse>(FindCNKResponse.class, FindCNKResponse.class);
        FindCNKResponse xmlObject = helper.toObject(resourceAsStream);
        // fix $ {ignore} content
        xmlObject.setId("dummyId");
        xmlObject.setIssueInstant(new DateTime());
        XmlValidator.validateXml(xmlObject);
    }


    @Test
    public void testConstructorIsPrivate() throws Exception {
        Constructor<XmlValidator> constructor = XmlValidator.class.getDeclaredConstructor();
        assertTrue("Constructor is not private", Modifier.isPrivate(constructor.getModifiers()));

        constructor.setAccessible(true);
        try {
            constructor.newInstance();
            Assert.fail("should have thrown UnsupportedOperationException");
        } catch (InvocationTargetException e) {
            Assert.assertTrue(e.getTargetException() instanceof UnsupportedOperationException);
            UnsupportedOperationException usoe = (UnsupportedOperationException) e.getTargetException();
            Assert.assertEquals("class may not be initialized, only static methods should be used", usoe.getMessage());
        }
    }
}
