/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.io.Serializable;
import java.util.List;
import org.easymock.IAnswer;
import org.easymock.IArgumentMatcher;
import org.easymock.internal.ExpectedInvocation;
import org.easymock.internal.IMocksBehavior;
import org.easymock.internal.IMocksControlState;
import org.easymock.internal.Invocation;
import org.easymock.internal.LastControl;
import org.easymock.internal.MocksControl;
import org.easymock.internal.PrimitiveUtils;
import org.easymock.internal.Range;
import org.easymock.internal.Result;
import org.easymock.internal.RuntimeExceptionWrapper;

public class RecordState
implements IMocksControlState,
Serializable {
    private static final long serialVersionUID = -5418279681566430252L;
    private ExpectedInvocation lastInvocation = null;
    private boolean lastInvocationUsed = true;
    private Result lastResult;
    private final IMocksBehavior behavior;

    public RecordState(IMocksBehavior behavior) {
        this.behavior = behavior;
    }

    @Override
    public void assertRecordState() {
    }

    @Override
    public Object invoke(Invocation invocation) {
        this.closeMethod();
        List<IArgumentMatcher> lastMatchers = LastControl.pullMatchers();
        this.lastInvocation = new ExpectedInvocation(invocation, lastMatchers);
        this.lastInvocationUsed = false;
        return RecordState.emptyReturnValueFor(invocation.getMethod().getReturnType());
    }

    @Override
    public void replay() {
        this.closeMethod();
        if (LastControl.pullMatchers() != null) {
            throw new IllegalStateException("matcher calls were used outside expectations");
        }
    }

    @Override
    public void verifyRecording() {
        throw new RuntimeExceptionWrapper(new IllegalStateException("calling verify is not allowed in record state"));
    }

    @Override
    public void verifyUnexpectedCalls() {
        throw new RuntimeExceptionWrapper(new IllegalStateException("calling verify is not allowed in record state"));
    }

    @Override
    public void verify() {
        throw new RuntimeExceptionWrapper(new IllegalStateException("calling verify is not allowed in record state"));
    }

    @Override
    public void andReturn(Object value) {
        this.requireMethodCall("return value");
        value = this.convertNumberClassIfNeccessary(value);
        this.requireAssignable(value);
        if (this.lastResult != null) {
            this.times(MocksControl.ONCE);
        }
        this.lastResult = Result.createReturnResult(value);
    }

    @Override
    public void andThrow(Throwable throwable) {
        this.requireMethodCall("Throwable");
        this.requireValidThrowable(throwable);
        if (this.lastResult != null) {
            this.times(MocksControl.ONCE);
        }
        this.lastResult = Result.createThrowResult(throwable);
    }

    @Override
    public void andAnswer(IAnswer<?> answer) {
        this.requireMethodCall("answer");
        this.requireValidAnswer(answer);
        if (this.lastResult != null) {
            this.times(MocksControl.ONCE);
        }
        this.lastResult = Result.createAnswerResult(answer);
    }

    @Override
    public void andDelegateTo(Object delegateTo) {
        this.requireMethodCall("delegate");
        this.requireValidDelegation(delegateTo);
        if (this.lastResult != null) {
            this.times(MocksControl.ONCE);
        }
        this.lastResult = Result.createDelegatingResult(delegateTo);
    }

    @Override
    public void andVoid() {
        this.requireMethodCall("void");
        this.requireVoidMethod();
        if (this.lastResult != null) {
            this.times(MocksControl.ONCE);
        }
        this.lastResult = Result.createReturnResult(null);
    }

    @Override
    public void andStubReturn(Object value) {
        this.requireMethodCall("stub return value");
        value = this.convertNumberClassIfNeccessary(value);
        this.requireAssignable(value);
        if (this.lastResult != null) {
            this.times(MocksControl.ONCE);
        }
        this.behavior.addStub(this.lastInvocation, Result.createReturnResult(value));
        this.lastInvocationUsed = true;
    }

    @Override
    public void asStub() {
        this.requireMethodCall("stub behavior");
        this.requireVoidMethod();
        this.behavior.addStub(this.lastInvocation, Result.createReturnResult(null));
        this.lastInvocationUsed = true;
    }

    @Override
    public void andStubThrow(Throwable throwable) {
        this.requireMethodCall("stub Throwable");
        this.requireValidThrowable(throwable);
        if (this.lastResult != null) {
            this.times(MocksControl.ONCE);
        }
        this.behavior.addStub(this.lastInvocation, Result.createThrowResult(throwable));
        this.lastInvocationUsed = true;
    }

    @Override
    public void andStubAnswer(IAnswer<?> answer) {
        this.requireMethodCall("stub answer");
        this.requireValidAnswer(answer);
        if (this.lastResult != null) {
            this.times(MocksControl.ONCE);
        }
        this.behavior.addStub(this.lastInvocation, Result.createAnswerResult(answer));
        this.lastInvocationUsed = true;
    }

    @Override
    public void andStubDelegateTo(Object delegateTo) {
        this.requireMethodCall("stub delegate");
        this.requireValidDelegation(delegateTo);
        if (this.lastResult != null) {
            this.times(MocksControl.ONCE);
        }
        this.behavior.addStub(this.lastInvocation, Result.createDelegatingResult(delegateTo));
        this.lastInvocationUsed = true;
    }

    @Override
    public void times(Range range) {
        this.requireMethodCall("times");
        this.requireLastResultOrVoidMethod();
        this.behavior.addExpected(this.lastInvocation, this.lastResult != null ? this.lastResult : Result.createReturnResult(null), range);
        this.lastInvocationUsed = true;
        this.lastResult = null;
    }

    private Object createNumberObject(Object value, Class<?> returnType) {
        if (!(value instanceof Number)) {
            return value;
        }
        Number number = (Number)value;
        if (returnType.equals(Byte.TYPE)) {
            return number.byteValue();
        }
        if (returnType.equals(Short.TYPE)) {
            return number.shortValue();
        }
        if (returnType.equals(Integer.TYPE)) {
            return number.intValue();
        }
        if (returnType.equals(Long.TYPE)) {
            return number.longValue();
        }
        if (returnType.equals(Float.TYPE)) {
            return Float.valueOf(number.floatValue());
        }
        if (returnType.equals(Double.TYPE)) {
            return number.doubleValue();
        }
        return number;
    }

    private Object convertNumberClassIfNeccessary(Object o) {
        Class<?> returnType = this.lastInvocation.getMethod().getReturnType();
        return this.createNumberObject(o, returnType);
    }

    private void closeMethod() {
        if (this.lastInvocationUsed && this.lastResult == null) {
            return;
        }
        if (!this.isLastResultOrVoidMethod()) {
            throw new RuntimeExceptionWrapper(new IllegalStateException("missing behavior definition for the preceding method call:\n" + this.lastInvocation.toString() + "\nUsage is: expect(a.foo()).andXXX()"));
        }
        this.times(MocksControl.ONCE);
    }

    public static Object emptyReturnValueFor(Class<?> type) {
        return type.isPrimitive() ? PrimitiveUtils.getEmptyValue(type) : null;
    }

    private void requireMethodCall(String failMessage) {
        if (this.lastInvocation == null) {
            throw new RuntimeExceptionWrapper(new IllegalStateException("method call on the mock needed before setting " + failMessage));
        }
    }

    private void requireAssignable(Object returnValue) {
        if (this.lastMethodIsVoidMethod()) {
            throw new RuntimeExceptionWrapper(new IllegalStateException("void method cannot return a value"));
        }
        if (returnValue == null) {
            Class<?> returnedType = this.lastInvocation.getMethod().getReturnType();
            if (returnedType.isPrimitive()) {
                throw new RuntimeExceptionWrapper(new IllegalStateException("can't return null for a method returning a primitive type"));
            }
            return;
        }
        Class<?> returnedType = this.lastInvocation.getMethod().getReturnType();
        if (returnedType.isPrimitive()) {
            returnedType = PrimitiveUtils.getWrapperType(returnedType);
        }
        if (!returnedType.isAssignableFrom(returnValue.getClass())) {
            throw new RuntimeExceptionWrapper(new IllegalStateException("incompatible return value type"));
        }
    }

    private void requireValidThrowable(Throwable throwable) {
        if (throwable == null) {
            throw new RuntimeExceptionWrapper(new NullPointerException("null cannot be thrown"));
        }
        if (this.isValidThrowable(throwable)) {
            return;
        }
        throw new RuntimeExceptionWrapper(new IllegalArgumentException("last method called on mock cannot throw " + throwable.getClass().getName()));
    }

    private void requireValidAnswer(IAnswer<?> answer) {
        if (answer == null) {
            throw new RuntimeExceptionWrapper(new NullPointerException("answer object must not be null"));
        }
    }

    private void requireValidDelegation(Object delegateTo) {
        if (delegateTo == null) {
            throw new RuntimeExceptionWrapper(new NullPointerException("delegated to object must not be null"));
        }
    }

    private void requireLastResultOrVoidMethod() {
        if (this.isLastResultOrVoidMethod()) {
            return;
        }
        throw new RuntimeExceptionWrapper(new IllegalStateException("last method called on mock is not a void method"));
    }

    private void requireVoidMethod() {
        if (this.lastMethodIsVoidMethod()) {
            return;
        }
        throw new RuntimeExceptionWrapper(new IllegalStateException("last method called on mock is not a void method"));
    }

    private boolean isLastResultOrVoidMethod() {
        return this.lastResult != null || this.lastMethodIsVoidMethod();
    }

    private boolean lastMethodIsVoidMethod() {
        Class<?> returnType = this.lastInvocation.getMethod().getReturnType();
        return returnType.equals(Void.TYPE);
    }

    private boolean isValidThrowable(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            return true;
        }
        if (throwable instanceof Error) {
            return true;
        }
        Class<?>[] exceptions = this.lastInvocation.getMethod().getExceptionTypes();
        Class<?> throwableClass = throwable.getClass();
        for (Class<?> exception : exceptions) {
            if (!exception.isAssignableFrom(throwableClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void checkOrder(boolean value) {
        this.closeMethod();
        this.behavior.checkOrder(value);
    }

    @Override
    public void makeThreadSafe(boolean threadSafe) {
        this.behavior.makeThreadSafe(threadSafe);
    }

    @Override
    public void checkIsUsedInOneThread(boolean shouldBeUsedInOneThread) {
        this.behavior.shouldBeUsedInOneThread(shouldBeUsedInOneThread);
    }
}

