/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.dicsv5.session.impl;

import be.ehealth.businessconnector.dicsv5.exception.DicsException;
import be.ehealth.businessconnector.dicsv5.service.ServiceFactory;
import be.ehealth.businessconnector.dicsv5.session.DicsSessionService;
import be.ehealth.technicalconnector.config.impl.ConfigurationModuleBootstrap;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.service.sts.security.SAMLToken;
import be.ehealth.technicalconnector.session.Session;
import be.ehealth.technicalconnector.utils.impl.JaxbContextFactory;
import be.ehealth.technicalconnector.validator.SessionValidator;
import be.ehealth.technicalconnector.ws.domain.GenericRequest;
import be.ehealth.technicalconnector.ws.domain.GenericResponse;
import be.fgov.ehealth.commons.protocol.v2.ResponseType;
import be.fgov.ehealth.dics.protocol.v5.FindAmpRequest;
import be.fgov.ehealth.dics.protocol.v5.FindAmpResponse;
import be.fgov.ehealth.dics.protocol.v5.FindAmppRequest;
import be.fgov.ehealth.dics.protocol.v5.FindAmppResponse;
import be.fgov.ehealth.dics.protocol.v5.FindCommentedClassificationRequest;
import be.fgov.ehealth.dics.protocol.v5.FindCommentedClassificationResponse;
import be.fgov.ehealth.dics.protocol.v5.FindCompanyRequest;
import be.fgov.ehealth.dics.protocol.v5.FindCompanyResponse;
import be.fgov.ehealth.dics.protocol.v5.FindCompoundingFormulaRequest;
import be.fgov.ehealth.dics.protocol.v5.FindCompoundingFormulaResponse;
import be.fgov.ehealth.dics.protocol.v5.FindCompoundingIngredientRequest;
import be.fgov.ehealth.dics.protocol.v5.FindCompoundingIngredientResponse;
import be.fgov.ehealth.dics.protocol.v5.FindLegislationTextRequest;
import be.fgov.ehealth.dics.protocol.v5.FindLegislationTextResponse;
import be.fgov.ehealth.dics.protocol.v5.FindListOfAmpRequest;
import be.fgov.ehealth.dics.protocol.v5.FindListOfAmpResponse;
import be.fgov.ehealth.dics.protocol.v5.FindNonMedicinalProductRequest;
import be.fgov.ehealth.dics.protocol.v5.FindNonMedicinalProductResponse;
import be.fgov.ehealth.dics.protocol.v5.FindReferencesRequest;
import be.fgov.ehealth.dics.protocol.v5.FindReferencesResponse;
import be.fgov.ehealth.dics.protocol.v5.FindReimbursementRequest;
import be.fgov.ehealth.dics.protocol.v5.FindReimbursementResponse;
import be.fgov.ehealth.dics.protocol.v5.FindVmpGroupRequest;
import be.fgov.ehealth.dics.protocol.v5.FindVmpGroupResponse;
import be.fgov.ehealth.dics.protocol.v5.FindVmpRequest;
import be.fgov.ehealth.dics.protocol.v5.FindVmpResponse;
import be.fgov.ehealth.dics.protocol.v5.FindVtmRequest;
import be.fgov.ehealth.dics.protocol.v5.FindVtmResponse;
import be.fgov.ehealth.dics.protocol.v5.ValidateProductIdRequest;
import be.fgov.ehealth.dics.protocol.v5.ValidateProductIdResponse;
import be.fgov.ehealth.dics.protocol.v5.ValidateSamIdRequest;
import be.fgov.ehealth.dics.protocol.v5.ValidateSamIdResponse;
import javax.xml.soap.SOAPException;
import javax.xml.ws.soap.SOAPFaultException;

public class DicsSessionServiceImpl
implements DicsSessionService,
ConfigurationModuleBootstrap.ModuleBootstrapHook {
    private SessionValidator sessionValidator;

    public DicsSessionServiceImpl(SessionValidator sessionValidator) {
        this.sessionValidator = sessionValidator;
    }

    public void bootstrap() {
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindAmpRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindAmpResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindCompanyRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindCompanyResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindVmpRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindVmpResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindLegislationTextRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindLegislationTextResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindReimbursementRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindReimbursementResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindReferencesRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindReferencesResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindVmpGroupRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindVmpGroupResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindVtmRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindVtmResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindCommentedClassificationRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindCommentedClassificationResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindCompoundingIngredientRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindCompoundingIngredientResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindCompoundingFormulaRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindCompoundingFormulaResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindAmppRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindAmppResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindNonMedicinalProductRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindNonMedicinalProductResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindListOfAmpRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindListOfAmpResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{ValidateSamIdRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{ValidateSamIdResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{ValidateProductIdRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{ValidateProductIdResponse.class});
    }

    @Override
    public FindAmpResponse findAmp(FindAmpRequest request) throws TechnicalConnectorException, DicsException {
        return this.executeOperation(request, "urn:be:fgov:ehealth:dics:protocol:v5:findAmp", FindAmpResponse.class);
    }

    @Override
    public FindCompanyResponse findCompany(FindCompanyRequest request) throws TechnicalConnectorException, DicsException {
        return this.executeOperation(request, "urn:be:fgov:ehealth:dics:protocol:v5:findCompany", FindCompanyResponse.class);
    }

    @Override
    public FindVmpResponse findVmp(FindVmpRequest request) throws TechnicalConnectorException, DicsException {
        return this.executeOperation(request, "urn:be:fgov:ehealth:dics:protocol:v5:findVmp", FindVmpResponse.class);
    }

    @Override
    public FindLegislationTextResponse findLegislationText(FindLegislationTextRequest request) throws TechnicalConnectorException, DicsException {
        return this.executeOperation(request, "urn:be:fgov:ehealth:dics:protocol:v5:findLegislationText", FindLegislationTextResponse.class);
    }

    @Override
    public FindReimbursementResponse findReimbursement(FindReimbursementRequest request) throws TechnicalConnectorException, DicsException {
        return this.executeOperation(request, "urn:be:fgov:ehealth:dics:protocol:v5:findReimbursement", FindReimbursementResponse.class);
    }

    @Override
    public FindReferencesResponse findReferences(FindReferencesRequest request) throws TechnicalConnectorException, DicsException {
        return this.executeOperation(request, "urn:be:fgov:ehealth:dics:protocol:v5:findReferences", FindReferencesResponse.class);
    }

    @Override
    public FindVmpGroupResponse findVmpGroup(FindVmpGroupRequest request) throws TechnicalConnectorException, DicsException {
        return this.executeOperation(request, "urn:be:fgov:ehealth:dics:protocol:v5:findVmpGroup", FindVmpGroupResponse.class);
    }

    @Override
    public FindVtmResponse findVtm(FindVtmRequest request) throws TechnicalConnectorException, DicsException {
        return this.executeOperation(request, "urn:be:fgov:ehealth:dics:protocol:v5:findVtm", FindVtmResponse.class);
    }

    @Override
    public FindCommentedClassificationResponse findCommentedClassification(FindCommentedClassificationRequest request) throws TechnicalConnectorException, DicsException {
        return this.executeOperation(request, "urn:be:fgov:ehealth:dics:protocol:v5:findCommentedClassification", FindCommentedClassificationResponse.class);
    }

    @Override
    public FindCompoundingIngredientResponse findIngredient(FindCompoundingIngredientRequest request) throws TechnicalConnectorException, DicsException {
        return this.executeOperation(request, "urn:be:fgov:ehealth:dics:protocol:v5:findIngredient", FindCompoundingIngredientResponse.class);
    }

    @Override
    public FindCompoundingFormulaResponse findFormula(FindCompoundingFormulaRequest request) throws TechnicalConnectorException, DicsException {
        return this.executeOperation(request, "urn:be:fgov:ehealth:dics:protocol:v5:findFormula", FindCompoundingFormulaResponse.class);
    }

    @Override
    public FindAmppResponse findAmpp(FindAmppRequest request) throws TechnicalConnectorException, DicsException {
        return this.executeOperation(request, "urn:be:fgov:ehealth:dics:protocol:v5:findAmpp", FindAmppResponse.class);
    }

    @Override
    public FindNonMedicinalProductResponse findNonMedicinalProduct(FindNonMedicinalProductRequest request) throws TechnicalConnectorException, DicsException {
        return this.executeOperation(request, "urn:be:fgov:ehealth:dics:protocol:v5:findNonMedicinalProduct", FindNonMedicinalProductResponse.class);
    }

    @Override
    public FindListOfAmpResponse findListOfAmp(FindListOfAmpRequest request) throws TechnicalConnectorException, DicsException {
        return this.executeOperation(request, "urn:be:fgov:ehealth:dics:protocol:v5:findListOfAmp", FindListOfAmpResponse.class);
    }

    @Override
    public ValidateSamIdResponse validateSamId(ValidateSamIdRequest request) throws TechnicalConnectorException, DicsException {
        return this.executeOperation(request, "urn:be:fgov:ehealth:dics:protocol:v5:validateSamId", ValidateSamIdResponse.class);
    }

    @Override
    public ValidateProductIdResponse validateProductId(ValidateProductIdRequest request) throws TechnicalConnectorException, DicsException {
        return this.executeOperation(request, "urn:be:fgov:ehealth:dics:protocol:v5:validateProductId", ValidateProductIdResponse.class);
    }

    private <T extends ResponseType> T executeOperation(Object request, String soapAction, Class<T> clazz) throws DicsException, TechnicalConnectorException {
        try {
            SAMLToken samlToken = Session.getInstance().getSession().getSAMLToken();
            this.sessionValidator.validateToken(samlToken);
            GenericRequest service = ServiceFactory.getDicsService(samlToken, soapAction);
            service.setPayload(request);
            GenericResponse wsResponse = be.ehealth.technicalconnector.ws.ServiceFactory.getGenericWsSender().send(service);
            return (T)((ResponseType)wsResponse.asObject(clazz));
        }
        catch (SOAPFaultException sfe) {
            throw new DicsException(sfe.getFault());
        }
        catch (SOAPException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, new Object[]{e.getMessage()});
        }
    }
}

