package be.ehealth.businessconnector.test.mycarenet.memberdata.session;

import be.ehealth.business.mycarenetdomaincommons.domain.InputReference;
import be.ehealth.businessconnector.test.mycarenet.memberdata.builders.BuilderStrategy;
import be.ehealth.businessconnector.mycarenet.memberdata.builders.ResponseObjectBuilder;
import be.ehealth.businessconnector.mycarenet.memberdata.builders.ResponseObjectBuilderFactory;
import be.ehealth.businessconnector.mycarenet.memberdata.domain.MemberDataBuilderResponse;
import be.ehealth.businessconnector.mycarenet.memberdata.session.MemberDataService;
import be.ehealth.businessconnector.mycarenet.memberdata.session.MemberDataSessionServiceFactory;
import be.ehealth.businessconnector.test.testcommons.utils.FileTestUtils;
import be.ehealth.technicalconnector.idgenerator.IdGeneratorFactory;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.ehealth.technicalconnector.utils.ConnectorXmlUtils;
import be.fgov.ehealth.mycarenet.memberdata.protocol.v1.MemberDataConsultationRequest;
import be.fgov.ehealth.mycarenet.memberdata.protocol.v1.MemberDataConsultationResponse;
import be.fgov.ehealth.technicalconnector.signature.domain.SignatureVerificationResult;
import be.fgov.ehealth.technicalconnector.tests.utils.XmlAsserter;
import oasis.names.tc.saml._2_0.protocol.AttributeQuery;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractBaseIntegrationTest {

    private String patientNiss;

    private String professionalNihii;

    protected AbstractBaseIntegrationTest(String professionalNihii, String patientNiss) {
        this.professionalNihii = professionalNihii;
        this.patientNiss = patientNiss;
    }

    protected void consultationTest(String attrQueryLocation, String responseLocation, BuilderStrategy testBuilder) throws Exception {
        Map<String, Object> testFileParams = new HashMap<String, Object>();
        String id = IdGeneratorFactory.getIdGenerator("uuid").generateId();
        testFileParams.put("id", id);
        testFileParams.put("nihii", professionalNihii);
        testFileParams.put("niss", patientNiss);

        AttributeQuery attributeQuery = FileTestUtils.toObject(testFileParams, attrQueryLocation, AttributeQuery.class);

        ConnectorXmlUtils.dump(attributeQuery);

        // input reference and AttributeQuery ID must match
        InputReference inputReference = new InputReference(id);

        MemberDataConsultationRequest memberDataRequest = testBuilder.build(true, inputReference, attributeQuery);

        MemberDataService service = MemberDataSessionServiceFactory.getMemberDataSyncService();
        MemberDataConsultationResponse memberDataResponse = service.consultMemberData(memberDataRequest);
        ResponseObjectBuilder responseBuilder = ResponseObjectBuilderFactory.getResponseObjectBuilder();
        MemberDataBuilderResponse response = responseBuilder.handleConsultationResponse(memberDataResponse);

        ConnectorXmlUtils.dump(response.getResponse());

        Assert.assertEquals("Status is not success", "urn:oasis:names:tc:SAML:2.0:status:Success", response.getResponse().getStatus().getStatusCode().getValue());
        Map<String, SignatureVerificationResult> signVerifResult = response.getSignatureVerificationResult();
        for (Map.Entry<String, SignatureVerificationResult> entry : signVerifResult.entrySet()) {
            Assert.assertTrue("Errors found in the signature verification",
                    entry.getValue().isValid());
        }

        InputStream is = ConnectorIOUtils.getResourceAsStream(responseLocation);
        String expectedresponse = ConnectorIOUtils.convertStreamToString(is);
        IOUtils.closeQuietly(is);

        XmlAsserter.assertSimilar(expectedresponse, ConnectorXmlUtils.toString(response.getResponse()));
    }
}
