/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.test.registration.helper;

import java.io.InputStream;

import be.ehealth.businessconnector.registration.helper.ResponseHelper;
import org.junit.Assert;
import org.junit.Test;

import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;


/**
 * tests the {@link ResponseHelper}.
 * 
 * @author eh058
 * 
 * @since
 * 
 */
public class ResponseHelperTest {

    /**
     * Test the response for a well formated successfull registration.
     * 
     * @throws Exception
     */
    @Test
    public void testValidationValidXmlSuccess() throws Exception {
        testValidation("/ResponseHelperTest/validXmlSuccess.xml");
    }

    /**
     * Test the response for a well formated but existing registration.
     * 
     * @throws Exception
     */
    @Test
    public void testValidationAlreadyRegisterResponse() throws Exception {
        testValidation("/ResponseHelperTest/validXmlWithError.xml");
    }

    /**
     * Test the response for a registration with a missing argument(status in ns2:registrationAnswer tag).
     * 
     * @throws Exception
     */
    @Test
    public void testValidationInvalidXmlMissingStatus() throws Exception {
        try {
            testValidation("/ResponseHelperTest/invalidXmlMissingStatus.xml");
        } catch (TechnicalConnectorException e) {
            Assert.assertEquals("Good exception type but not for right reason", TechnicalConnectorExceptionValues.ERROR_XML_INVALID, e.getCategory());
        }
    }

    private void testValidation(String inputXmlFile) throws Exception {
        InputStream resourceAsStream = ConnectorIOUtils.getResourceAsStream(inputXmlFile);
        byte[] inputBytes = ConnectorIOUtils.getBytes(resourceAsStream);
        ResponseHelper.validateResponse(ResponseHelper.toObject(inputBytes));

    }
}
