/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.technicalconnector.distributedkeys.jca;

import be.fedict.commons.eid.jca.BeIDProvider;
import be.fgov.ehealth.technicalconnector.distributedkeys.jca.DistributedKeySignature;
import be.fgov.ehealth.technicalconnector.distributedkeys.jca.DistributedKeyStore;
import be.fgov.ehealth.technicalconnector.distributedkeys.jca.DistributedPrivateKey;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedKeyProvider
extends Provider {
    private static final String SIGNATURE = "Signature";
    private static final long serialVersionUID = 1L;
    public static final String NAME = "DistributedKeyProvider";
    private static final Logger LOG = LoggerFactory.getLogger(BeIDProvider.class);

    public DistributedKeyProvider() {
        super(NAME, 1.0, "DistributedKey Provider");
        this.putService(new DistributedKeyService(this, "KeyStore", NAME, DistributedKeyStore.class.getName()));
        HashMap<String, String> signatureServiceAttributes = new HashMap<String, String>();
        signatureServiceAttributes.put("SupportedKeyClasses", DistributedPrivateKey.class.getName());
        this.putService(new DistributedKeyService(this, SIGNATURE, "SHA1withRSA", DistributedKeySignature.class.getName(), signatureServiceAttributes));
        this.putService(new DistributedKeyService(this, SIGNATURE, "SHA224withRSA", DistributedKeySignature.class.getName(), signatureServiceAttributes));
        this.putService(new DistributedKeyService(this, SIGNATURE, "SHA256withRSA", DistributedKeySignature.class.getName(), signatureServiceAttributes));
        this.putService(new DistributedKeyService(this, SIGNATURE, "SHA384withRSA", DistributedKeySignature.class.getName(), signatureServiceAttributes));
        this.putService(new DistributedKeyService(this, SIGNATURE, "SHA512withRSA", DistributedKeySignature.class.getName(), signatureServiceAttributes));
        this.putService(new DistributedKeyService(this, SIGNATURE, "NONEwithRSA", DistributedKeySignature.class.getName(), signatureServiceAttributes));
        this.putService(new DistributedKeyService(this, SIGNATURE, "RIPEMD128withRSA", DistributedKeySignature.class.getName(), signatureServiceAttributes));
        this.putService(new DistributedKeyService(this, SIGNATURE, "RIPEMD160withRSA", DistributedKeySignature.class.getName(), signatureServiceAttributes));
        this.putService(new DistributedKeyService(this, SIGNATURE, "RIPEMD256withRSA", DistributedKeySignature.class.getName(), signatureServiceAttributes));
        this.putService(new DistributedKeyService(this, SIGNATURE, "SHA1withRSAandMGF1", DistributedKeySignature.class.getName(), signatureServiceAttributes));
        this.putService(new DistributedKeyService(this, SIGNATURE, "SHA256withRSAandMGF1", DistributedKeySignature.class.getName(), signatureServiceAttributes));
        this.putService(new DistributedKeyService(this, SIGNATURE, "SHA256withECDSA", DistributedKeySignature.class.getName(), signatureServiceAttributes));
        this.putService(new DistributedKeyService(this, SIGNATURE, "SHA384withECDSA", DistributedKeySignature.class.getName(), signatureServiceAttributes));
        this.putService(new DistributedKeyService(this, SIGNATURE, "SHA512withECDSA", DistributedKeySignature.class.getName(), signatureServiceAttributes));
        this.putService(new DistributedKeyService(this, SIGNATURE, "NONEwithECDSA", DistributedKeySignature.class.getName(), signatureServiceAttributes));
    }

    private static final class DistributedKeyService
    extends Provider.Service {
        public DistributedKeyService(Provider provider, String type, String algorithm, String className) {
            super(provider, type, algorithm, className, null, null);
        }

        public DistributedKeyService(Provider provider, String type, String algorithm, String className, Map<String, String> attributes) {
            super(provider, type, algorithm, className, null, attributes);
        }

        @Override
        public Object newInstance(Object constructorParameter) throws NoSuchAlgorithmException {
            LOG.debug("newInstance: " + super.getType());
            if (super.getType().equals(DistributedKeyProvider.SIGNATURE)) {
                return new DistributedKeySignature(this.getAlgorithm());
            }
            return super.newInstance(constructorParameter);
        }

        @Override
        public boolean supportsParameter(Object parameter) {
            LOG.debug("supportedParameter: " + parameter);
            return super.supportsParameter(parameter);
        }
    }
}

