/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.decrypt;

import be.fgov.ehealth.etee.crypto.decrypt.EnvelopedDataDecrypterResult;
import be.fgov.ehealth.etee.crypto.decrypt.KeyLengthVerifier;
import be.fgov.ehealth.etee.crypto.decrypt.UnsealUtils;
import be.fgov.ehealth.etee.crypto.policies.EncryptionCredential;
import be.fgov.ehealth.etee.crypto.policies.EncryptionCredentials;
import be.fgov.ehealth.etee.crypto.policies.EncryptionPolicy;
import be.fgov.ehealth.etee.crypto.status.NotificationError;
import be.fgov.ehealth.etee.crypto.status.NotificationFatal;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import org.bouncycastle.cms.CMSEnvelopedDataParser;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.cms.KEKRecipientInformation;
import org.bouncycastle.cms.KeyTransRecipientId;
import org.bouncycastle.cms.KeyTransRecipientInformation;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.cms.jcajce.JceKEKEnvelopedRecipient;
import org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EnvelopedDataDecrypter {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnvelopedDataDecrypter.class);
    private final EncryptionPolicy privateKeyEncryptionPolicy;
    private final EncryptionPolicy secretKeyEncryptionPolicy;
    private final Map<String, PrivateKey> encryptionCredentials;

    public EnvelopedDataDecrypter(EncryptionPolicy privateKeyEncryptionPolicy, EncryptionCredential[] encryptionCredentials, EncryptionPolicy secretKeyEncryptionPolicy) {
        this.privateKeyEncryptionPolicy = privateKeyEncryptionPolicy;
        this.secretKeyEncryptionPolicy = secretKeyEncryptionPolicy;
        this.encryptionCredentials = EncryptionCredentials.toMap(encryptionCredentials);
    }

    public EnvelopedDataDecrypterResult decryptData(byte[] encryptedData) {
        return this.decryptData(encryptedData, null);
    }

    public EnvelopedDataDecrypterResult decryptData(InputStream encryptedData) {
        return this.decryptData(encryptedData, null);
    }

    public EnvelopedDataDecrypterResult decryptData(byte[] encryptedData, SecretKey kek) {
        return this.processData(encryptedData, null, kek);
    }

    public EnvelopedDataDecrypterResult decryptData(InputStream encryptedData, SecretKey kek) {
        return this.processData(null, encryptedData, kek);
    }

    private EnvelopedDataDecrypterResult processData(byte[] encryptedData, InputStream encryptedDataStream, SecretKey kek) {
        CMSEnvelopedDataParser envelopedDataParser;
        LOGGER.debug("Decrypting");
        try {
            envelopedDataParser = encryptedData != null ? new CMSEnvelopedDataParser(encryptedData) : new CMSEnvelopedDataParser(encryptedDataStream);
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            return new EnvelopedDataDecrypterResult(NotificationFatal.ENVELOPED_DATA_STRUCTURE_INCORRECT);
        }
        EnvelopedDataDecrypterResult rslt = new EnvelopedDataDecrypterResult();
        this.decryptEnvelopedData(envelopedDataParser, kek, rslt);
        return rslt;
    }

    private void decryptEnvelopedData(CMSEnvelopedDataParser envelopedDataParser, SecretKey kek, EnvelopedDataDecrypterResult rslt) {
        boolean mustUseKekToDecrypt = kek != null;
        try {
            List<RecipientInformation> recipientInfos = this.getRecipientInfo(envelopedDataParser);
            LOGGER.debug("Enveloped-Data contains " + recipientInfos.size() + " recipientInfos");
            LOGGER.debug("decrypting Enveloped-Data with " + (mustUseKekToDecrypt ? " given KEK" : " private keys"));
            boolean decrypted = false;
            boolean containsKeyTransRinfo = false;
            boolean containsKekRinfo = false;
            ArrayList<String> knownRecipients = new ArrayList<String>();
            ArrayList<String> unknownRecipients = new ArrayList<String>();
            for (RecipientInformation recipientInfo : recipientInfos) {
                String keyId;
                if (!mustUseKekToDecrypt && recipientInfo instanceof KeyTransRecipientInformation) {
                    containsKeyTransRinfo = true;
                    keyId = this.getKeyId((KeyTransRecipientId)recipientInfo.getRID());
                    knownRecipients.add(keyId);
                    if (decrypted) continue;
                    this.checkEncryptionAlgorithms(this.privateKeyEncryptionPolicy, recipientInfo, envelopedDataParser, rslt);
                    decrypted = this.decryptKeyTransRecipientInfo(keyId, (KeyTransRecipientInformation)recipientInfo, rslt);
                    continue;
                }
                if (!mustUseKekToDecrypt || !(recipientInfo instanceof KEKRecipientInformation)) continue;
                containsKekRinfo = true;
                keyId = UnsealUtils.getBase64EncodedKekId(recipientInfo);
                unknownRecipients.add(keyId);
                if (decrypted) continue;
                this.checkEncryptionAlgorithms(this.secretKeyEncryptionPolicy, recipientInfo, envelopedDataParser, rslt);
                KeyLengthVerifier.verifySecretKeyLength(this.secretKeyEncryptionPolicy, rslt, kek);
                decrypted = this.decryptKekRecipientInfo(keyId, (KEKRecipientInformation)recipientInfo, kek, rslt);
            }
            LOGGER.info("Message recipients: Known=" + knownRecipients + ", Unknown=" + unknownRecipients);
            this.verifyDecryptionStatus(rslt, mustUseKekToDecrypt, decrypted, containsKeyTransRinfo, containsKekRinfo);
        }
        catch (CMSException e) {
            LOGGER.warn("Failed to decrypt enveloped data", (Throwable)e);
            this.handleCMSError(rslt, e);
        }
    }

    private void handleCMSError(EnvelopedDataDecrypterResult rslt, CMSException e) {
        if (e.getCause() instanceof NoSuchPaddingException) {
            rslt.getErrors().add(NotificationError.DECRYPTION_SYMMETRIC_KEY_ALGORITHM_PADDING_UNAUTHORIZED);
        } else if (e.getCause() instanceof BadPaddingException) {
            rslt.getErrors().add(NotificationError.DECRYPTION_SYMMETRIC_KEY_ALGORITHM_PADDING_UNAUTHORIZED);
        } else if (e.getCause() instanceof InvalidKeyException) {
            rslt.getErrors().add(NotificationError.DECRYPTION_SYMMETRIC_KEY_LENGTH_UNAUTHORIZED);
        } else {
            rslt.copyNotifications(new EnvelopedDataDecrypterResult(NotificationFatal.ENVELOPED_DATA_STRUCTURE_INCORRECT));
        }
    }

    private boolean decryptKekRecipientInfo(String keyId, KEKRecipientInformation recipientInfo, SecretKey kek, EnvelopedDataDecrypterResult rslt) {
        boolean decryptionSucceeded = false;
        try {
            CMSTypedStream recData = recipientInfo.getContentStream((Recipient)new JceKEKEnvelopedRecipient(kek));
            InputStream is = recData.getContentStream();
            rslt.setData(is);
            decryptionSucceeded = true;
            LOGGER.info("Message Decryption Key [KeyId=" + keyId + "]");
        }
        catch (Exception e) {
            LOGGER.error("EnvelopedData could not be decrypted with given kek. RecipientInfo's KEK ID is " + keyId, (Throwable)e);
        }
        return decryptionSucceeded;
    }

    private boolean decryptKeyTransRecipientInfo(String keyId, KeyTransRecipientInformation recipientInfo, EnvelopedDataDecrypterResult rslt) throws CMSException {
        boolean decryptionSucceeded = false;
        PrivateKey decryptionKey = this.encryptionCredentials.get(keyId);
        if (decryptionKey != null) {
            LOGGER.debug("Found Decryption Key with id " + keyId);
            KeyLengthVerifier.verifyPrivateKeyLength(rslt, decryptionKey, this.privateKeyEncryptionPolicy.getKeksize());
            try {
                CMSTypedStream recData = recipientInfo.getContentStream((Recipient)new JceKeyTransEnvelopedRecipient(decryptionKey));
                InputStream is = recData.getContentStream();
                rslt.setData(is);
                decryptionSucceeded = true;
                LOGGER.info("Message Decryption Key [KeyId=" + keyId + "]");
            }
            catch (IOException e) {
                LOGGER.error("EnvelopedData could not be decrypted with given kek. RecipientInfo's KEK ID is " + keyId, (Throwable)e);
            }
        } else {
            LOGGER.warn("no decryption key found for RecipientInfo with id : " + keyId);
        }
        return decryptionSucceeded;
    }

    private String getKeyId(KeyTransRecipientId recipientId) {
        return recipientId.getSerialNumber() != null ? recipientId.getSerialNumber().toString() : new String(Base64.encode((byte[])recipientId.getSubjectKeyIdentifier()), StandardCharsets.UTF_8);
    }

    private void checkEncryptionAlgorithms(EncryptionPolicy encryptionPolicy, RecipientInformation recipientInformation, CMSEnvelopedDataParser envelopedDataParser, EnvelopedDataDecrypterResult result) {
        this.checkContentEncryptionAlgorithm(encryptionPolicy, envelopedDataParser, result);
        this.checkKeyEncryptionAlgorithm(encryptionPolicy, recipientInformation, result);
    }

    private void checkKeyEncryptionAlgorithm(EncryptionPolicy encryptionPolicy, RecipientInformation recipientInfo, EnvelopedDataDecrypterResult rslt) {
        String usedKeyEncryptionAlgoOID = recipientInfo.getKeyEncryptionAlgOID();
        boolean isAuthorizedKeyEncryptionAlgorithm = usedKeyEncryptionAlgoOID.equals(encryptionPolicy.getKeyEncryptionAlgorithmOID());
        if (!isAuthorizedKeyEncryptionAlgorithm) {
            LOGGER.warn("Unauthorized key encryption algorithm used in encrypted message.Applied algorithm : " + usedKeyEncryptionAlgoOID);
            rslt.getErrors().add(NotificationError.DECRYPTION_ASYMMETRIC_KEY_ALGORITHM_UNAUTHORIZED);
        } else {
            LOGGER.debug("Key(s) encryption algorithm is OK.");
        }
    }

    private void checkContentEncryptionAlgorithm(EncryptionPolicy encryptionPolicy, CMSEnvelopedDataParser envelopedDataParser, EnvelopedDataDecrypterResult rslt) {
        String usedContentEncryptionAlgOID = envelopedDataParser.getEncryptionAlgOID();
        boolean isAuthorizedContentEncryptionAlgorithm = usedContentEncryptionAlgOID.equals(encryptionPolicy.getContentEncryptionAlgorithmOID());
        if (!isAuthorizedContentEncryptionAlgorithm) {
            LOGGER.warn("Unauthorized content encryption algorithm used in encrypted message. Applied algorithm : " + usedContentEncryptionAlgOID);
            rslt.getErrors().add(NotificationError.DECRYPTION_SYMMETRIC_KEY_ALGORITHM_UNAUTHORIZED);
        } else {
            LOGGER.debug("Content encryption algorithm is OK.");
        }
    }

    private List<RecipientInformation> getRecipientInfo(CMSEnvelopedDataParser envelopedDataParser) {
        RecipientInformationStore recipients = envelopedDataParser.getRecipientInfos();
        return (List)recipients.getRecipients();
    }

    private void verifyDecryptionStatus(EnvelopedDataDecrypterResult rslt, boolean mustUseKekToDecrypt, boolean keyFound, boolean containsKeyTransRinfo, boolean containsKekRinfo) {
        if (!keyFound) {
            if (mustUseKekToDecrypt) {
                if (!containsKekRinfo) {
                    LOGGER.error("The EnvelopedData does not contain a KEKRecipientInformation");
                    rslt.copyNotifications(new EnvelopedDataDecrypterResult(NotificationFatal.ENVELOPED_DATA_CONTAINS_NO_KEKRECIPIENTINFOS));
                } else {
                    LOGGER.warn("The given SecretKey can not decrypt the KEKRecipientInformations in the EnvelopedData.");
                    rslt.copyNotifications(new EnvelopedDataDecrypterResult(NotificationFatal.SECRET_KEY_CAN_NOT_DECRYPT_KEKRECIPIENTINFOS));
                }
            } else if (!containsKeyTransRinfo) {
                LOGGER.error("The EnvelopedData does not contain a KeyTransRecipientInformation.");
                rslt.copyNotifications(new EnvelopedDataDecrypterResult(NotificationFatal.ENVELOPED_DATA_CONTAINS_NO_KEYTRANSRECIPIENTINFOS));
            } else {
                LOGGER.warn("No private key found for the KeyTransRecipientInformations in the EnvelopedData.");
                rslt.copyNotifications(new EnvelopedDataDecrypterResult(NotificationFatal.DECRYPTION_PRIVATE_KEY_NOT_FOUND));
            }
        }
    }
}

