package be.ehealth.businessconnector.test.vsbnet.async.session;

import org.junit.FixMethodOrder;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.MethodSorters;

import be.fgov.ehealth.technicalconnector.tests.junit.rule.SessionRule;


/**
 * @author EHP
 */
@FixMethodOrder(MethodSorters.NAME_ASCENDING)
public class VsbNet_eMOHDF103_V4_IntegrationTest {

    private static final String FILES_FOLDER = "/examples/vsbnet/async/eHMOHDF103_V4/";

    @Rule
    public SessionRule rule = SessionRule.withActiveSession().baseOn("/be.ehealth.businessconnector.vsbnet.test.properties").build();

    // Prerequisites :
    // 1 - Execute EMOHDF101(CreateApplication) 5_5a and 5_5b test
    // 2 - Get the VSBReference returned in 5_5b and adapt the xml file
    // 3 - Ask a validation of the vsb reference
    
    @Test
    public void test_5_1a_POST_ConsultApplicationV4() throws Exception {
        VsbNetGenericAsyncMethod.do_POST_ConsultApplicationV4(FILES_FOLDER + "vsb-mohm_DF103_5-1_TC_CAPP1_testlink_eWZC-3061_request.xml");
    }

    @Test
    public void test_5_1b_GET_ConsultApplicationV4() throws Exception {
        VsbNetGenericAsyncMethod.do_GET_ConsultApplicationV4(FILES_FOLDER + "vsb-mohm_DF103_5-1_TC_CAPP1_testlink_eWZC-3061_response.xml", false);
    }

    @Test
    public void test_5_2a_POST_ConsultApplicationV4() throws Exception {
        VsbNetGenericAsyncMethod.do_POST_ConsultApplicationV4(FILES_FOLDER + "vsb-mohm_DF103_5-2_TC_CAPP2_testlink_eWZC-3062_request.xml");
    }

    @Test
    public void test_5_2b_GET_ConsultApplicationV4() throws Exception {
        VsbNetGenericAsyncMethod.do_GET_ConsultApplicationV4(FILES_FOLDER + "vsb-mohm_DF103_5-2_TC_CAPP2_testlink_eWZC-3062_response.xml", false);
    }
}
