/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.encrypt;

import be.fgov.ehealth.etee.crypto.encrypt.CmsSigner;
import be.fgov.ehealth.etee.crypto.encrypt.SignerInfoAttributesSender;
import be.fgov.ehealth.etee.crypto.ocsp.OCSPChecker;
import be.fgov.ehealth.etee.crypto.ocsp.OCSPCheckerBuilder;
import be.fgov.ehealth.etee.crypto.policies.OCSPPolicy;
import be.fgov.ehealth.etee.crypto.policies.SigningCredential;
import be.fgov.ehealth.etee.crypto.policies.SigningPolicy;
import be.fgov.ehealth.etee.crypto.utils.Iterables;
import java.security.cert.X509Certificate;
import java.util.List;

class CmsSignerFactory {
    private static CmsSignerFactory instance;

    CmsSignerFactory() {
    }

    public static synchronized CmsSignerFactory getInstance() {
        if (instance == null) {
            instance = new CmsSignerFactory();
        }
        return instance;
    }

    public CmsSigner create(SigningPolicy signingPolicy, SigningCredential signatureCredential, OCSPChecker ocspChecker, SignerInfoAttributesSender signerInfoAttributesSender) {
        if (signatureCredential.getSubjectKeyIdentifier() != null) {
            return new CmsSigner(signatureCredential.getPrivateKey(), signatureCredential.getSubjectKeyIdentifier(), signingPolicy.getSignatureAlgorithmName(), OCSPCheckerBuilder.newBuilder().addOCSPPolicy(OCSPPolicy.NONE).build(), signerInfoAttributesSender);
        }
        OCSPChecker safeOcspChecker = ocspChecker != null ? ocspChecker : OCSPCheckerBuilder.newBuilder().addOCSPPolicy(OCSPPolicy.NONE).build();
        List<X509Certificate> credentialCertificates = signatureCredential.getCertificateChain();
        X509Certificate signingCertificate = Iterables.first(credentialCertificates);
        List<X509Certificate> caCertificates = credentialCertificates.subList(1, credentialCertificates.size());
        return new CmsSigner(signatureCredential.getPrivateKey(), signingCertificate, caCertificates, signingPolicy.getSignatureAlgorithmName(), safeOcspChecker, signerInfoAttributesSender);
    }
}

