/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.mycarenet.attestv2.helper;

import be.cin.encrypted.BusinessContent;
import be.cin.encrypted.EncryptedKnownContent;
import be.ehealth.business.kmehrcommons.mycarenet.McnHcPartyUtil;
import be.ehealth.business.mycarenetcommons.v3.mapper.BlobMapper;
import be.ehealth.business.mycarenetcommons.v3.mapper.CommonInputMapper;
import be.ehealth.business.mycarenetdomaincommons.builders.BlobBuilderFactory;
import be.ehealth.business.mycarenetdomaincommons.builders.CommonBuilder;
import be.ehealth.business.mycarenetdomaincommons.builders.RequestBuilderFactory;
import be.ehealth.business.mycarenetdomaincommons.domain.Blob;
import be.ehealth.business.mycarenetdomaincommons.domain.Ssin;
import be.ehealth.business.mycarenetdomaincommons.mapper.DomainBlobMapper;
import be.ehealth.business.mycarenetdomaincommons.util.McnConfigUtil;
import be.ehealth.businessconnector.mycarenet.attestv2.domain.InputReference;
import be.ehealth.businessconnector.mycarenet.attestv2.exception.AttestBusinessConnectorException;
import be.ehealth.businessconnector.mycarenet.attestv2.exception.AttestBusinessConnectorExceptionValues;
import be.ehealth.businessconnector.mycarenet.attestv2.security.AttestEncryptionUtil;
import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.idgenerator.IdGeneratorFactory;
import be.ehealth.technicalconnector.service.keydepot.KeyDepotManager;
import be.ehealth.technicalconnector.service.keydepot.KeyDepotManagerFactory;
import be.ehealth.technicalconnector.session.Session;
import be.ehealth.technicalconnector.utils.ConnectorXmlUtils;
import be.ehealth.technicalconnector.utils.MarshallerHelper;
import be.ehealth.technicalconnector.utils.SessionUtil;
import be.fgov.ehealth.messageservices.mycarenet.core.v1.RequestType;
import be.fgov.ehealth.messageservices.mycarenet.core.v1.SendTransactionRequest;
import be.fgov.ehealth.mycarenet.attest.protocol.v2.CancelAttestationRequest;
import be.fgov.ehealth.mycarenet.commons.core.v3.CommonInputType;
import be.fgov.ehealth.mycarenet.commons.protocol.v3.SendRequestType;
import be.fgov.ehealth.standards.kmehr.mycarenet.schema.v1.Kmehrmessage;
import be.fgov.ehealth.technicalconnector.signature.AdvancedElectronicSignatureEnumeration;
import be.fgov.ehealth.technicalconnector.signature.SignatureBuilderFactory;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import org.joda.time.DateTime;
import org.mapstruct.factory.Mappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3._2005._05.xmlmime.Base64Binary;

public final class RequestObjectBuilderHelper {
    private static final Logger LOG = LoggerFactory.getLogger(RequestObjectBuilderHelper.class);
    private static MarshallerHelper<SendTransactionRequest, SendTransactionRequest> kmehrMarshallHelper = new MarshallerHelper(SendTransactionRequest.class, SendTransactionRequest.class);
    private static final Configuration config = ConfigFactory.getConfigValidator();

    private RequestObjectBuilderHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static CancelAttestationRequest buildSendRequestTypeWithXades(boolean isTest, InputReference references, Blob blob) throws TechnicalConnectorException {
        CancelAttestationRequest cancelAttestRequest = (CancelAttestationRequest)RequestObjectBuilderHelper.buildSendRequestType(isTest, references, blob, "attestv2", CancelAttestationRequest.class);
        Base64Binary base64Binary = RequestObjectBuilderHelper.buildXades(blob, (SendRequestType)cancelAttestRequest);
        cancelAttestRequest.setXades(base64Binary);
        return cancelAttestRequest;
    }

    public static <T> SendRequestType buildSendRequestType(boolean isTest, InputReference references, Blob blob, String projectIdentifier, Class<T> clazz) throws TechnicalConnectorException {
        SendRequestType sendRequestType;
        try {
            sendRequestType = (SendRequestType)clazz.newInstance();
        }
        catch (Exception e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.UNEXPECTED_ERROR, (Throwable)e, new Object[0]);
        }
        CommonBuilder commonBuilder = RequestBuilderFactory.getCommonBuilder((String)projectIdentifier);
        CommonInputType mapCommonInputType = ((CommonInputMapper)Mappers.getMapper(CommonInputMapper.class)).map(commonBuilder.createCommonInput(McnConfigUtil.retrievePackageInfo((String)projectIdentifier), isTest, references.getInputReference()));
        sendRequestType.setCommonInput(mapCommonInputType);
        sendRequestType.setId(IdGeneratorFactory.getIdGenerator((String)"xsid").generateId());
        sendRequestType.setIssueInstant(new DateTime());
        sendRequestType.setDetail(BlobMapper.mapBlobTypefromBlob((Blob)blob));
        return sendRequestType;
    }

    public static BusinessContent buildBusinessContent(SendTransactionRequest request, String detailId) {
        BusinessContent businessContent = new BusinessContent();
        businessContent.setId(detailId);
        businessContent.setValue(kmehrMarshallHelper.toXMLByteArray((Object)request));
        return businessContent;
    }

    public static SendTransactionRequest buildSendTransactionRequest(InputReference references, Kmehrmessage msg) throws TechnicalConnectorException {
        SendTransactionRequest request = new SendTransactionRequest();
        request.setRequest(RequestObjectBuilderHelper.buildRequest(references));
        request.setKmehrmessage(msg);
        return request;
    }

    public static void setMessageProtocoleSchemaVersion(SendTransactionRequest request, String schema) throws TechnicalConnectorException {
        String messageProtocoleSchemaVersion = config.getProperty(schema);
        if (messageProtocoleSchemaVersion != null) {
            try {
                request.setMessageProtocoleSchemaVersion(new BigDecimal(messageProtocoleSchemaVersion));
            }
            catch (NumberFormatException e) {
                throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.INVALID_PROPERTY_VALUE, new Object[]{messageProtocoleSchemaVersion + " is not a valid message protocole schema decimal value"});
            }
        }
    }

    public static Base64Binary buildXades(Blob blob, SendRequestType sendRequestType) throws TechnicalConnectorException {
        HashMap<String, Object> options = new HashMap<String, Object>();
        ArrayList<String> tranforms = new ArrayList<String>();
        tranforms.add("http://www.w3.org/2000/09/xmldsig#base64");
        options.put("transformerList", tranforms);
        options.put("baseURI", blob.getId());
        byte[] sign = SignatureBuilderFactory.getSignatureBuilder((AdvancedElectronicSignatureEnumeration)AdvancedElectronicSignatureEnumeration.XAdES).sign(Session.getInstance().getSession().getEncryptionCredential(), ConnectorXmlUtils.toByteArray((Object)sendRequestType), options);
        return DomainBlobMapper.mapB64fromByte((byte[])sign);
    }

    public static RequestType buildRequest(InputReference references) throws TechnicalConnectorException {
        RequestType req = new RequestType();
        req.setId(McnHcPartyUtil.createKmehrId((String)"attestv2", (String)references.getInputReference()));
        req.setAuthor(McnHcPartyUtil.createAuthor((String)"attestv2"));
        req.setDate(new DateTime());
        req.setTime(new DateTime());
        return req;
    }

    public static void checkInputParameters(InputReference inputReference, Ssin patientSsin, DateTime referenceDate) throws AttestBusinessConnectorException {
        RequestObjectBuilderHelper.checkParameterNotNull(inputReference, "InputReference");
        RequestObjectBuilderHelper.checkParameterNotNull(inputReference.getInputReference(), "Input reference");
        RequestObjectBuilderHelper.checkParameterNotNull(referenceDate, "Reference date");
        RequestObjectBuilderHelper.checkParameterNotNull(patientSsin, "patientSsin");
        RequestObjectBuilderHelper.checkParameterNotNull(patientSsin, "value of patientSsin");
    }

    public static void checkParameterNotNull(Object references, String parameterName) throws AttestBusinessConnectorException {
        if (references == null) {
            throw new AttestBusinessConnectorException(AttestBusinessConnectorExceptionValues.PARAMETER_NULL, parameterName);
        }
    }

    public static Blob buildBlobWithEncryptedKnownContent(String id, EncryptedKnownContent encryptedKnownContent, String encodingType, String contentType, String messageName, String contentEncryption, String projectIdentifier) throws TechnicalConnectorException {
        byte[] xmlByteArray = new AttestEncryptionUtil<EncryptedKnownContent>().handleEncryptionSendAttestation(encryptedKnownContent, SessionUtil.getHolderOfKeyCrypto(), id);
        if (xmlByteArray != null && ConfigFactory.getConfigValidator().getBooleanProperty("be.ehealth.businessconnector.attestv2.builders.impl.dumpMessages", Boolean.valueOf(false)).booleanValue()) {
            LOG.debug("RequestObjectBuilder : created blob content: {}", (Object)new String(xmlByteArray));
        }
        Blob blob = BlobBuilderFactory.getBlobBuilder((String)projectIdentifier).build(xmlByteArray, encodingType, id, contentType, messageName, contentEncryption);
        blob.setMessageName(messageName);
        return blob;
    }

    public static Blob buildBlobWithRequestEncrypted(String id, SendTransactionRequest request, String encodingType, String contentType, String messageName, String projectIdentifier) throws TechnicalConnectorException {
        Blob blob = BlobBuilderFactory.getBlobBuilder((String)projectIdentifier).build(kmehrMarshallHelper.toXMLByteArray((Object)request), encodingType, id, messageName, messageName);
        blob.setMessageName(contentType);
        return blob;
    }

    public static EncryptedKnownContent buildEncryptedKnownContent(BusinessContent businessContent) throws TechnicalConnectorException {
        EncryptedKnownContent encryptedKnownContent = new EncryptedKnownContent();
        encryptedKnownContent.setReplyToEtk(KeyDepotManagerFactory.getKeyDepotManager().getETK(KeyDepotManager.EncryptionTokenType.HOLDER_OF_KEY).getEncoded());
        encryptedKnownContent.setBusinessContent(businessContent);
        return encryptedKnownContent;
    }
}

