﻿/*
 * Copyright (c) eHealth
 */
using System;
using be.ehealth.business.mycarenetdomaincommons.builders;
using be.ehealth.business.mycarenetdomaincommons.util;
using be.ehealth.businessconnector.genericasync.builders;
using be.ehealth.businessconnector.genericasync.mappers;
using be.ehealth.technicalconnector.config.util;
using be.ehealth.technicalconnector.config.util.domain;
using be.ehealth.technicalconnector.handler.domain;
using be.ehealth.technicalconnector.idgenerator;
using be.ehealth.technicalconnector.session;
using be.ehealth.technicalconnector.utils;
using be.fgov.ehealth.technicalconnector.tests.session;
using be.fgov.ehealth.technicalconnector.tests.utils;
using java.io;
using java.lang;
using java.util;
using java.net;
using NUnit.Framework;
using be.cin.mycarenet.esb.common.v2;
using be.cin.nip.async.generic;
using be.ehealth.businessconnector.genericasync.session;
using be.ehealth.businessconnector.genericasync.domain;
using be.ehealth.business.mycarenetdomaincommons.domain;
using be.ehealth.business.mycarenetdomaincommons.mapper;
using org.apache.commons.lang;
using org.slf4j;
using be.ehealth.businessconnector.test.testcommons.utils;
using org.mapstruct.factory;

namespace be.ehealth.businessconnector.mediprima.session
{
	
	/**
     * <p>Tests to check and document the asynchronous call flow of the operations get and confirm of the MediPrima invoicing service.<p>
     * 
     * <p>Not that the MediPrima service works with message id references (not with hashes).</p>
     * 
     * <p>The business content of the returned invoicing files is not checked.</p>
     *
     * @author EHP
     */
	[TestFixture]
	public class MediprimaGetAndConfirmInvoicingGenericAsyncIntegrationTest
	{
		private static Logger LOG = LoggerFactory.getLogger(typeof(MediprimaGetAndConfirmInvoicingGenericAsyncIntegrationTest));

		private static string PROJECT_NAME = "mediprima.invoicing";
    	private static string OUTPUT_FILE_EXTENSION = ".txt";
    	private static string OUTPUT_DIR = "invoicingSendFiles";
        private static int MAX_MESSAGES = 100;

        private static java.util.List messageNames = java.util.Arrays.asList("ECM-HCPFAC", "ECM-HCPVWR");


		[SetUp]
	    public static void init() {
	    	SessionInitializer.init(".\\be.ehealth.businessconnector.mediprima.test.properties",SupportedLanguages.NET.getAbbreviation());
		}

	    [TearDown]
	    public static void tearDown() {
	        Session.getInstance().unloadSession();
	    }

	    [Test]
        public void getTest() {
            performGetAndConfirmTest(PROJECT_NAME, messageNames, false);
        }

        [Test]
        public void getAndConfirmTest() {
            performGetAndConfirmTest(PROJECT_NAME, messageNames, true);
        }

        /**
         * To run this test, supply a list of TAckResponse references you want ensure they are no longer returned
         * by the service (typically, after confirming TAck responses).
         */
        [Test]
        public void checkIfTAckResponsesAreStillReturned() {

            /**** Add the references to be checked to this list ***/
            java.util.List tAckResponseReferences = Arrays.asList();
            /******************************************************/
            Validate.notEmpty(tAckResponseReferences, "Add msgResponse references you wish to check to the msgResponseReferences list");

            OrigineType origin = givenOrigin();
            GenAsyncService service = givenService(PROJECT_NAME);

            GetResponse messages = getMessages(origin, service, PROJECT_NAME, messageNames);
            Responses messageReturn = messages.getReturn();
            if (messageReturn.getTAckCount() != 0) {
                java.util.List tackValues = messageReturn.getTAckResponses();
                for (int i = 0; i < tackValues.size(); i++){
                    TAckResponse tackResp = (TAckResponse) tackValues.get(i);
                    string reference = tackResp.getTAck().getReference();
                    if (tAckResponseReferences.contains(reference)) {
                        Assert.Fail("\tTackResponse found after it was already confirmed : reference: >" + reference + "< , appliesTo >" + tackResp.getTAck().getAppliesTo() + "< " + tackResp.getTAck().getResultMessage());
                    }
                }
            }
        }

        /**
         * To run this test, supply a list of MsgResponse references you want ensure they are no longer returned
         * by the service (typically, after confirming TAck responses).
         */
        [Test]
        public void checkIfMessagesWithSameReferencesAreStillReturned() {

            /**** Add the references to be checked to this list ***/
            java.util.List msgResponseReferences = Arrays.asList();
            /******************************************************/
            Validate.notEmpty(msgResponseReferences, "Add msgResponse references you wish to check to the tAckResponseReferences list");

            OrigineType origin = givenOrigin();
            GenAsyncService service = givenService(PROJECT_NAME);

            GetResponse messages = getMessages(origin, service, PROJECT_NAME, messageNames);
            Responses messageReturn = messages.getReturn();
            if (messageReturn.getMsgCount() != 0) {
               java.util.List msgValues = messageReturn.getMsgResponses();
                for (int i = 0; i < msgValues.size(); i++) {
               		MsgResponse msgResponse = (MsgResponse) msgValues.get(i);
               		string reference = msgResponse.getDetail().getReference();
                    if (msgResponseReferences.contains(reference)) {
                        Assert.Fail("\tmessageResponse found even after its reception was already confirmed : reference: >" + msgResponse.getDetail().getReference() + "< , inputRef : " + msgResponse.getCommonOutput().getInputReference() + " outputRef: " + msgResponse.getCommonOutput().getOutputReference());
                    }
                }
            }
        }

        private static GenAsyncService givenService(string projectName) {
            return GenAsyncSessionServiceFactory.getGenAsyncService(projectName);
        }

        private static OrigineType givenOrigin() {
            McnPackageInfo packageInfo = McnConfigUtil.retrievePackageInfo("genericasync." + PROJECT_NAME);
            CommonBuilder commonBuilder = RequestBuilderFactory.getCommonBuilder(PROJECT_NAME);
            CommonInputMapper mapper = (CommonInputMapper) Mappers.getMapper(typeof(CommonInputMapper));
            return mapper.map(commonBuilder.createOrigin(packageInfo));
        }


        private static void performGetAndConfirmTest(string projectName, java.util.List messageNames, bool confirmMessages) {
            OrigineType origin = givenOrigin();
            GenAsyncService service = givenService(projectName);

            GetResponse getResponse = getMessages(origin, service, projectName, messageNames);

            if (getResponse.getReturn().getMsgCount() == 0 && getResponse.getReturn().getTAckCount() == 0) {
                LOG.warn("NO MESSAGES TO CONFIRM ");
            } else if (confirmMessages) {
                ConfirmResponse confirmResponse = confirmTheseMessages(origin, service, getResponse);
                LOG.debug(ConnectorXmlUtils.toString(confirmResponse));
                Assert.NotNull(confirmResponse);
            }
        }


        private static GetResponse getMessages(OrigineType origin, GenAsyncService service, string projectName, java.util.List messageNames) {
            MsgQuery msgQuery = new MsgQuery();
            msgQuery.setInclude(new java.lang.Boolean(true));
            msgQuery.setMax(new java.lang.Integer(MAX_MESSAGES));
            msgQuery.getMessageNames().addAll(messageNames);

            Query tackQuery = new Query();
            tackQuery.setInclude(new java.lang.Boolean(true));
            tackQuery.setMax(new java.lang.Integer(MAX_MESSAGES));

            WsAddressingHeader getResponseHeader = WsAddressingUtil.createHeader(null, GenericAsyncConstants.GET_SOAP_ACTION);
            GetResponse getResponse = service.getRequest(BuilderFactory.getRequestObjectBuilder(projectName).buildGetRequest(origin, msgQuery, tackQuery), getResponseHeader);

            // validate the get responses ( including check on xades if present)
            BuilderFactory.getResponseObjectBuilder().handleGetResponse(getResponse);

            writeResultsToFile(getResponse);

            return getResponse;
        }

        private static ConfirmResponse confirmTheseMessages(OrigineType origin, GenAsyncService service, GetResponse getResponse) {
            WsAddressingHeader responseConfirmHeader = WsAddressingUtil.createHeader(null, GenericAsyncConstants.CONFIRM_SOAP_ACTION);
            Confirm request = new Confirm();
            request.setOrigin(origin);
            addTAckResponseReferencesToConfirm(getResponse, request);
            addMsgReferencesToConfirm(getResponse, request);
            ConfirmResponse confirmResponse = service.confirmRequest(request, responseConfirmHeader);
            return confirmResponse;
        }

        private static void addTAckResponseReferencesToConfirm(GetResponse getResponse, Confirm request) {
            java.util.List tackValues = getResponse.getReturn().getTAckResponses();
            for (int i = 0; i < tackValues.size(); i++) {
                TAckResponse tAckResponse = (TAckResponse) tackValues.get(i);
                request.getTAckReferences().add(tAckResponse.getTAck().getReference());
            }
        }

        private static void addMsgReferencesToConfirm(GetResponse getResponse, Confirm request) {
            java.util.List msgResponses = getResponse.getReturn().getMsgResponses();
            for (int i = 0; i < msgResponses.size(); i++){
                MsgResponse msgResponse = (MsgResponse) msgResponses.get(i);
                request.getMsgRefValues().add(msgResponse.getDetail().getReference());
            }
        }

        private static void writeResultsToFile(GetResponse getResponse) {
        	java.util.List msgResponses = getResponse.getReturn().getMsgResponses();
            for (int i = 0; i < msgResponses.size(); i++){
                MsgResponse msgResponse = (MsgResponse) msgResponses.get(i);
                Blob mappedBlob = DomainBlobMapper.mapToBlob(msgResponse.getDetail());

                // No hash in message response
                mappedBlob.setHashTagRequired(false);

                byte[] unwrappedMessageByteArray = BlobBuilderFactory.getBlobBuilder(PROJECT_NAME).checkAndRetrieveContent(mappedBlob);
                if (unwrappedMessageByteArray != null & unwrappedMessageByteArray.Length > 0) {

                    // handle the business message with your own logic
                    FileTestUtils.writeToFile(System.Text.Encoding.UTF8.GetString(unwrappedMessageByteArray), "getResponseBusinessMessage", OUTPUT_FILE_EXTENSION, OUTPUT_DIR);
                    LOG.debug("received Business Message : " + System.Text.Encoding.UTF8.GetString(unwrappedMessageByteArray));
                }
            }
            java.util.List tackValues = getResponse.getReturn().getTAckResponses();
            for (int i = 0; i < tackValues.size(); i++) {
                TAckResponse tAckResponse = (TAckResponse) tackValues.get(i);
                byte[] tackResponseBytes = tAckResponse.getTAck().getValue();
                if (tackResponseBytes != null & tackResponseBytes.Length > 0) {

                    // handle with your own logic
                    FileTestUtils.writeToFile(System.Text.Encoding.UTF8.GetString(tackResponseBytes), "tackResponseValue", OUTPUT_FILE_EXTENSION, OUTPUT_DIR);
                    LOG.debug("received Tack response : " + System.Text.Encoding.UTF8.GetString(tackResponseBytes));
                }

            }
            FileTestUtils.writeToFile(System.Text.Encoding.UTF8.GetString(ConnectorXmlUtils.toByteArray(getResponse)), "getResponse", OUTPUT_FILE_EXTENSION, OUTPUT_DIR);
            ConnectorXmlUtils.dump(getResponse);
        }
	}
}
