/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.test.mycarenet.agreement.session;

import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.SessionRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

import javax.xml.ws.soap.SOAPFaultException;

/**
 * *
 * @author EHP
 */
public class AgreementPhysiotherapistIntegrationTest extends AbstractBaseIntegrationTest {

    private static final String REQ_DIR = "/examples/mycarenet/eagreement/requests/";

    private static final String LAST_PART_REQ_LOCATION = "RequestContent.xml";

    @ClassRule
    public static SessionRule rule = SessionRule.withActiveSession().forEnvironment("acc").forProfession("persphysiotherapist").forUser("hannes").build();


    public AgreementPhysiotherapistIntegrationTest() throws TechnicalConnectorException {
        super();
    }

    @Test
    public void askAgreementWithEncryption() throws Exception {
        askAgreementTest(REQ_DIR + "AskAgreement" + LAST_PART_REQ_LOCATION);
    }

    @Test
    public void argueAgreementWithEncryption() throws Exception {
        askAgreementTest(REQ_DIR + "ArgueAgreement" + LAST_PART_REQ_LOCATION);
    }

    @Test
    public void cancelAgreementWithEncryption() throws Exception {
        askAgreementTest(REQ_DIR + "CancelAgreement" + LAST_PART_REQ_LOCATION);
    }
    @Test
    public void extendAgreementWithEncryption() throws Exception {
        askAgreementTest(REQ_DIR + "ExtendAgreement" + LAST_PART_REQ_LOCATION);
    }

    @Test
    public void consultAgreementWithEncryption() throws Exception {
        consultAgreementTest(REQ_DIR + "ConsultAgreement" + LAST_PART_REQ_LOCATION);
    }

    @Test
    public void unhappyAskAgreementWithEncryption() throws Exception {
        try {
            askAgreementTest(REQ_DIR + "UnhappyAskAgreement" + LAST_PART_REQ_LOCATION);
            Assert.fail("soap fault expected");
        } catch (SOAPFaultException sfe) {
            checkSOAPFault(sfe);
        }
    }
}
