package be.fgov.ehealth.technicalconnector.tests.server.callback;

import org.apache.commons.lang3.StringUtils;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.HttpStatusCode;

import java.util.concurrent.TimeUnit;

public class TimeOutExpectationCallback extends AbstractExpectationCallback {
    @Override
    public HttpResponse handle(HttpRequest httpRequest) {
           try{
                Integer timeperiod = Integer.valueOf(StringUtils.substringAfterLast(httpRequest.getPath().getValue(), "/"));
                TimeUnit.SECONDS.sleep(timeperiod);
            } catch (InterruptedException e) {
                return internalError("unkown error [" + e.getMessage() + "]");
            }
        return HttpResponse.response()
                .withStatusCode(HttpStatusCode.OK_200.code())
                .withHeader("Content-Type", "text/html")
                .withBody("Waiting page");


    }
}
