/**
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.test.mycarenet.agreementasync.session;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import be.ehealth.businessconnector.mycarenet.agreementasync.session.AgreementSessionServiceFactory;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

import be.cin.encrypted.EncryptedKnownContent;
import be.cin.nip.async.generic.MsgResponse;
import be.ehealth.businessconnector.genericasync.domain.GetRequest;
import be.ehealth.businessconnector.genericasync.domain.ProcessedGetResponse;
import be.ehealth.businessconnector.genericasync.domain.ProcessedMsgResponse;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.ehealth.technicalconnector.utils.ConnectorXmlUtils;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.SessionRule;
import be.fgov.ehealth.technicalconnector.tests.utils.XmlAsserter;

/**
 * @author EHP
 *
 */
public class AgreementGetAsyncIntegrationTest {

    @Rule
    public SessionRule rule = SessionRule.withActiveSession()
    .baseOn("/be.ehealth.businessconnector.mycarenet.agreementasync.test.properties")
    .build();

    @Test
    public void getEAgreementResponse() throws Exception {
        ProcessedGetResponse<byte[]> response = AgreementSessionServiceFactory.getAgrementService().getEAgreementResponse(GetRequest.newBuilder().withDefaults().build());

        Assert.assertTrue(response.getMsgResponses().size() > 0);
        ProcessedMsgResponse<byte[]> processedMsgResponse = response.getMsgResponses().get(0);
        assertEquals("SignatureVerificationResult should contain no error", 0, processedMsgResponse.getSignatureVerificationResult().getErrors().size());
        MsgResponse msgResponse = processedMsgResponse.getMsgResponse();
        assertNotNull("Missing xades", msgResponse.getXadesT());
        XmlAsserter.assertSimilar(ConnectorXmlUtils.toObject(processedMsgResponse.getSignedData(), EncryptedKnownContent.class), processedMsgResponse.getRawDecryptedBlob());
        byte[] businessContent = processedMsgResponse.getBusinessResponse();
        String stringContent = new String(businessContent, "UTF-8");
        XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString("/examples/mycarenet/eagreementasync/expected/eAgreementResponse.xml"), stringContent);

        AgreementSessionServiceFactory.getAgrementService().confirmAllMessages(response);
    }

}
