/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.test.insurabilityv2.integration;

import org.joda.time.DateTime;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.unitils.reflectionassert.ReflectionAssert;
import org.unitils.reflectionassert.ReflectionComparatorMode;

import be.ehealth.businessconnector.insurabilityv2.builders.RequestObjectBuilder;
import be.ehealth.businessconnector.insurabilityv2.builders.impl.RequestObjectBuilderImpl;
import be.ehealth.businessconnector.insurabilityv2.domain.InsurabilityReferences;
import be.ehealth.businessconnector.insurabilityv2.session.InsurabilityService;
import be.ehealth.businessconnector.insurabilityv2.session.InsurabilitySessionServiceFactory;
import be.ehealth.technicalconnector.exception.ConnectorException;
import be.ehealth.technicalconnector.exception.SoaErrorException;
import be.ehealth.technicalconnector.session.Session;
import be.fgov.ehealth.insurability.core.v2.CareReceiverIdType;
import be.fgov.ehealth.insurability.core.v2.InsurabilityForPharmacistRequest;
import be.fgov.ehealth.insurability.core.v2.ReturnCodeType;
import be.fgov.ehealth.insurability.protocol.v2.GetInsurabilityForPharmacistRequest;
import be.fgov.ehealth.insurability.protocol.v2.GetInsurabilityForPharmacistResponse;
import be.fgov.ehealth.technicalconnector.tests.session.SessionInitializer;


/**
 * Integration test for insurability
 * 
 * @author EH054
 * 
 */
public class InsurabilityIntegrationTest {

    private static final Logger LOG = LoggerFactory.getLogger(InsurabilityIntegrationTest.class);

    @BeforeClass
    public static void init() throws Exception {
        LOG.debug("InsurabilityIntegrationTest.loadSession:");
        SessionInitializer.init("/be.ehealth.businessconnector.insurabilityv2.test.properties", true);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        Session.getInstance().unloadSession();
    }

    @Test
    public void testOA500() throws ConnectorException {
        generateTest("96022530604", null, null, "F", new DateTime());
    }

    @Test
    public void testOA100() throws ConnectorException {
        generateTest("82051234978", null, null, "F", new DateTime());
    }

    private void generateTest(String ssin, String mutuality, String registNumber, String requestType, DateTime requestDate) throws ConnectorException {
        RequestObjectBuilder requestObjectBuilder = new RequestObjectBuilderImpl();
        GetInsurabilityForPharmacistRequest insurabilityRequest;

        InsurabilityReferences references = new InsurabilityReferences(true);
        InsurabilityForPharmacistRequest request = new InsurabilityForPharmacistRequest();
        CareReceiverIdType careReceiverId = new CareReceiverIdType();

        // Variables initialization
        boolean isTest = false;

        careReceiverId.setSsin(ssin);
        careReceiverId.setMutuality(mutuality);
        careReceiverId.setRegNrWithMut(registNumber);

        request.setCareReceiver(careReceiverId);
        request.setDate(requestDate);
        request.setRequestType(requestType);

        insurabilityRequest = requestObjectBuilder.buildInsurabilityForPharmacistRequest(isTest, references, request);

        // Construction asserts
        ReflectionAssert.assertReflectionEquals(request, insurabilityRequest.getInsurabilityRequest(), ReflectionComparatorMode.LENIENT_ORDER);
        Assert.assertEquals(references.getRecordCommonInputId(), insurabilityRequest.getRecordCommonInput().getUserReference());
        Assert.assertEquals(isTest, insurabilityRequest.getCommonInput().getRequest().isIsTest());

        // Session & service
        InsurabilityService insurabilityService = InsurabilitySessionServiceFactory.getInsurabilityService();
        try {
            GetInsurabilityForPharmacistResponse insurabilityForPharmacist = insurabilityService.getInsurabilityForPharmacist(insurabilityRequest);
            Assert.assertEquals("Status code not 200", "200", insurabilityForPharmacist.getStatus().getCode());

        } catch (SoaErrorException e) {
            GetInsurabilityForPharmacistResponse response = (GetInsurabilityForPharmacistResponse) e.getResponseType();
            ReturnCodeType returnCode = response.getReturnInfo().getReturnCode();
            LOG.error("Error Status received [" + e.getErrorCode() + "]: Major[" + returnCode.getMajor() + "] Minor [" + returnCode.getMinor() + "] Detail [" + returnCode.getDetail() + "]");
            throw e;
        }

    }
}
