/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.test.chapterIV.builders.impl;

import be.ehealth.businessconnector.chapterIV.builders.impl.ResponseBuilderImpl;
import be.ehealth.businessconnector.test.chapterIV.testutil.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

import be.ehealth.businessconnector.chapterIV.builders.BuilderFactory;
import be.ehealth.businessconnector.chapterIV.builders.ResponseBuilder;
import be.ehealth.businessconnector.chapterIV.builders.WrappedResponseBuilder;
import be.ehealth.businessconnector.chapterIV.common.ConversationType;
import be.ehealth.businessconnector.chapterIV.validators.impl.Chapter4XmlValidatorImpl;
import be.ehealth.businessconnector.chapterIV.wrapper.UnsealedResponseWrapper;
import be.fgov.ehealth.chap4.protocol.v1.ConsultChap4MedicalAdvisorAgreementResponse;
import be.fgov.ehealth.medicalagreement.core.v1.Kmehrresponse;


/**
 * Local tests for the Responsebuilder.
 * 
 * @author EHP
 * 
 */
public class ResponseBuilderTest {


    private ResponseBuilder responseBuilder;

    private BuilderFactory factory;

    @Before
    public void setup() throws Exception {
        factory = new BuilderFactory(null, new Chapter4XmlValidatorImpl());
        responseBuilder = factory.getResponseBuilder();
    }


    @Test
    public void testResponseBuilderCreation() {
        Assert.assertNotNull(responseBuilder);
    }


    @Test
    public void testGetSecuredContent() throws Exception {

        ConsultChap4MedicalAdvisorAgreementResponse agreementResponse = TestUtils.mapToConsultResponseObject("/examples/response/successfullResponse_expiredcert.xml");
        byte[] response = ((ResponseBuilderImpl) responseBuilder).getSecuredContent(WrappedResponseBuilder.wrap(agreementResponse));
        Assert.assertNotNull(response);
    }


    @Test
    public void testUnsealedKmehrRequest() throws Exception {
        @SuppressWarnings("rawtypes")
        UnsealedResponseWrapper unsealedResponse = ((ResponseBuilderImpl) responseBuilder).getUnsealedResponse(TestUtils.getFileContents("/examples/response/contentUnsealedSealedContentOfSuccesfullResponse.xml").getBytes(), ConversationType.CONSULT);
        Assert.assertNotNull(unsealedResponse);
        Assert.assertNotNull(unsealedResponse.getKmehrResponseBytes());
        Assert.assertTrue(unsealedResponse.getKmehrResponseBytes().length > 10);
    }

    @Test
    public void testUnsealedKmehrResponseContents() throws Exception {
        @SuppressWarnings("rawtypes")
        UnsealedResponseWrapper unsealedResponse = ((ResponseBuilderImpl) responseBuilder).getUnsealedResponse(TestUtils.getFileContents("/examples/response/contentUnsealedSealedContentOfSuccesfullResponse.xml").getBytes(), ConversationType.CONSULT);
        Kmehrresponse response = responseBuilder.convertToKmehrResKmehrresponse(unsealedResponse.getKmehrResponseBytes());
        Kmehrresponse unsealKmehrResponse = response;
        Assert.assertNotNull(unsealKmehrResponse);
        Assert.assertNotNull(unsealKmehrResponse.getRequest());
    }


}
