package be.ehealth.businessconnector.test.insurability.mapper;

import be.ehealth.business.mycarenetdomaincommons.domain.*;
import be.ehealth.businessconnector.insurability.mappers.CommonInputMapper;
import be.ehealth.technicalconnector.config.util.domain.PackageInfo;
import be.fgov.ehealth.insurability.core.v1.CommonInputType;
import org.junit.Assert;
import org.junit.Test;
import org.mapstruct.factory.Mappers;

public class CommonInputMapperTest {

    @Test
    public void mapCommontInput() {
        Identification identification = new Identification();

        String name = "dummy_name";
        identification.setName(name);

        String ssin = "dummy_ssin";
        identification.setSsin(ssin);

        String cbe = "dummy_cbe";
        identification.setCbe(cbe);

        String nihiiValue = "10013368001";
        String quality = "persphysician";
        Nihii nihii = new Nihii(quality, nihiiValue);
        identification.setNihii(nihii);

        String packageName = "dummy_name";
        String packageUsername = "dummy_username";
        String packagePassword = "dummy_password";
        PackageInfo packageInfo = new PackageInfo(packageUsername, packagePassword, packageName);

        CareProvider careProvider = new CareProvider(nihii);
        careProvider.setPhysicalPerson(identification);

        Origin origin = new Origin(packageInfo, careProvider);
        String siteId = "dummy_siteId";
        origin.setSiteId(siteId);

        String inputReference = "dummy_inputreference";
        CommonInput commonInput = new CommonInput(true, origin, inputReference);

        CommonInputMapper mapper = Mappers.getMapper(CommonInputMapper.class);
        CommonInputType result = mapper.map(commonInput);

        Assert.assertTrue(result.getRequest().isIsTest());
        Assert.assertEquals(result.getRequest().isIsTest(), commonInput.isTest());

        Assert.assertEquals(packageName, result.getOrigin().getPackage().getName().getValue());
        Assert.assertEquals(result.getOrigin().getPackage().getName().getValue(), packageInfo.getPackageName());

        Assert.assertEquals(packageUsername, result.getOrigin().getPackage().getLicense().getUsername());
        Assert.assertEquals(result.getOrigin().getPackage().getLicense().getUsername(), packageInfo.getUserName());

        Assert.assertEquals(packagePassword, result.getOrigin().getPackage().getLicense().getPassword());
        Assert.assertEquals(result.getOrigin().getPackage().getLicense().getPassword(), packageInfo.getPassword());

        Assert.assertEquals(name, result.getOrigin().getCareProvider().getPhysicalPerson().getName().getValue());
        Assert.assertEquals(result.getOrigin().getCareProvider().getPhysicalPerson().getName().getValue(), identification.getName());

        Assert.assertEquals(ssin, result.getOrigin().getCareProvider().getPhysicalPerson().getSsin().getValue());
        Assert.assertEquals(result.getOrigin().getCareProvider().getPhysicalPerson().getSsin().getValue(), identification.getSsin());

        Assert.assertEquals(nihiiValue, result.getOrigin().getCareProvider().getPhysicalPerson().getNihii().getValue().getValue());
        Assert.assertEquals(result.getOrigin().getCareProvider().getPhysicalPerson().getNihii().getValue().getValue(), identification.getNihii().getValue());

        Assert.assertEquals(quality, result.getOrigin().getCareProvider().getPhysicalPerson().getNihii().getQuality());
        Assert.assertEquals(result.getOrigin().getCareProvider().getPhysicalPerson().getNihii().getQuality(), identification.getNihii().getQuality());

        Assert.assertEquals(cbe, result.getOrigin().getCareProvider().getPhysicalPerson().getCbe().getValue());
        Assert.assertEquals(result.getOrigin().getCareProvider().getPhysicalPerson().getCbe().getValue(), identification.getCbe());

        Assert.assertEquals(quality, result.getOrigin().getCareProvider().getNihii().getQuality());
        Assert.assertEquals(result.getOrigin().getCareProvider().getNihii().getQuality(), origin.getCareProvider().getNihii().getQuality());

        Assert.assertEquals(nihiiValue, result.getOrigin().getCareProvider().getNihii().getValue().getValue());
        Assert.assertEquals(result.getOrigin().getCareProvider().getNihii().getValue().getValue(), origin.getCareProvider().getNihii().getValue());
    }

}
