﻿﻿﻿/*
 * Created by SharpDevelop.
 * User: EH062
 * Date: 07/09/2020
 * Time: 16:27
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */
using be.ehealth.business.common.domain;
using be.ehealth.business.mycarenetdomaincommons.domain;
using be.ehealth.businessconnector.mycarenet.agreement.builders;
using be.ehealth.businessconnector.mycarenet.agreement.domain;
using be.ehealth.businessconnector.test.testcommons.utils;
using be.ehealth.technicalconnector.config;
using be.ehealth.technicalconnector.exception;
using be.ehealth.technicalconnector.utils;
using be.fgov.ehealth.technicalconnector.tests.utils;
using be.fgov.ehealth.mycarenet.agreement.protocol.v1;
using be.fgov.ehealth.errors.core.v1;
using be.fgov.ehealth.errors.soa.v1;
using javax.xml.soap;
using javax.xml.ws.soap;
using ikvm.extensions;
using org.joda.time;
using java.io;
using java.util;
using NUnit.Framework;
using System;

namespace be.ehealth.businessconnector.mycarenet.agreement.session
{
	
	public abstract class AbstractBaseIntegrationTest {
	
	    private static readonly string CHARSET = "utf-8";
	    
		private readonly string patientNiss = "72070539942";
	
	    private string professionalNihii;
	    
	    protected void setProfessionalNihii(string nihii) {
	    	this.professionalNihii = nihii;
	    }
	
	    protected void askAgreementTest(string bundleLocation) {
	        AgreementService service = AgreementSessionServiceFactory.getAgreementService();
	        ResponseObjectBuilder responseBuilder = ResponseObjectBuilderFactory.getResponseObjectBuilder();
	
	        string id = "01-KIN-EMEHS";
	        byte[] bundle = ConnectorIOUtils.getResourceAsString(bundleLocation).getBytes(CHARSET);
	        ConnectorXmlUtils.dump(bundle);
	
	        Patient patientInfo = new Patient();
	        patientInfo.setInss(patientNiss);
	
	        // input reference and AttributeQuery ID must match
	        InputReference inputReference = new InputReference(id);
	        AskAgreementBuilderRequest requestBuilder = RequestObjectBuilderFactory.getEncryptedRequestObjectBuilder().buildAskAgreementRequest(true, inputReference, patientInfo, new org.joda.time.DateTime(), bundle);
	
	        AskAgreementResponse response = service.askAgreement((AskAgreementRequest) requestBuilder.getRequest());
	        assertResponse(responseBuilder.handleAskAgreementResponse(response, requestBuilder));
	    }
	
	    protected void consultAgreementTest(string bundleLocation) {
	        AgreementService service = AgreementSessionServiceFactory.getAgreementService();
	        ResponseObjectBuilder responseBuilder = ResponseObjectBuilderFactory.getResponseObjectBuilder();
	
	        string id = "01-KIN-EMEHS";
	        byte[] bundle = ConnectorIOUtils.getResourceAsString(bundleLocation).getBytes(CHARSET);
	        ConnectorXmlUtils.dump(bundle);
	
	        Patient patientInfo = new Patient();
	        patientInfo.setInss(patientNiss);
	
	        // input reference and AttributeQuery ID must match
	        InputReference inputReference = new InputReference(id);
	        ConsultAgreementBuilderRequest requestBuilder = RequestObjectBuilderFactory.getEncryptedRequestObjectBuilder().buildConsultAgreementRequest(true, inputReference, patientInfo, new org.joda.time.DateTime(), bundle);
	
	        ConsultAgreementResponse response = service.consultAgreement((ConsultAgreementRequest) requestBuilder.getRequest());
	        assertResponse(responseBuilder.handleConsultAgreementResponse(response, requestBuilder));
	    }
	    
	    protected void checkSOAPFault(SOAPFaultException sfe) {
            java.util.List entries = new ArrayList();
            Iterator it = sfe.getFault().getDetail().getDetailEntries();
            while (it.hasNext()) entries.add((DetailEntry) it.next());
    
            Assert.IsTrue(entries.size() == 1);
    
            MarshallerHelper helper = new MarshallerHelper(typeof(BusinessError), typeof(BusinessError));
            BusinessError error = (BusinessError) helper.toObject((org.w3c.dom.Node) entries.get(0));
    
            Assert.IsTrue("EMPTY_BLOB".Equals(error.getCode()));
            Assert.IsTrue("MYCARENET".Equals(error.getOrigin()));
    
            java.util.List messages = error.getMessages();
            Assert.IsTrue(messages.size() == 1);
    
            LocalisedStringType message = (LocalisedStringType)messages.get(0);
            Assert.IsTrue("Blob is empty.".Equals(message.getValue()));
        }
	
	    private void assertResponse(SignedEncryptedBuilderResponse response) {
	        Assert.IsTrue(response.getSignatureVerificationResult().isValid());
	        Assert.IsNotNull(response.getXades());
	        Assert.IsNotNull(response.getSignedData());
	        Assert.IsNotNull(response.getRawDecryptedBlob());
            String expectedResponse = ConnectorIOUtils.getResourceAsString(".\\examples\\mycarenet\\eagreement\\responses\\mh-response-detail.xml");
            XmlAsserter.assertSimilar(expectedResponse, System.Text.Encoding.UTF8.GetString(response.getBusinessResponse()));        
	   }
	}
}
