﻿/*
 * Copyright (c) eHealth
 */
using System;
using be.fgov.ehealth.technicalconnector.tests.session;
using be.fgov.ehealth.technicalconnector.tests.utils;
using NUnit.Framework;

namespace be.ehealth.businessconnector.vsbnet.async.session
{
	public class VsbNet_eMOHDF106_V4_IntegrationTest
	{
	    private static String FILES_FOLDER = ".\\examples\\vsbnet\\async\\eHMOHDF106_V4\\";

	    [SetUp]
		public static void setup() {
			SessionInitializer.init("be.ehealth.businessconnector.vsbnet.test.properties",true,SupportedLanguages.NET.getAbbreviation());
		}
		
	    // Prerequisites :
	    // 1 - Execute EMOHDF101(CreateApplication) 5_5a and 5_5b test and then 5_1a and 5_1b
	    // 2 - Get the VSBReference returned in the CreateApplication 5_5b and adapt the xml files of the PushDecision 5_1
	    // 2 - Get the VSBReference returned in CreateApplication 5_1b and adapt the xml files of the PushDecision 5_3
	    // 3 - Ask a validation of the vsb reference of CreateApplication 5_5b
	    
	    [Test]
	    public void test_5_1_GET_getPushDecision() {
	        VsbNetGenericAsyncMethod.do_GET_PushDecisionV4(FILES_FOLDER + "vsb-mohm_DF106_5-1_TC_PDES1_testlink_eWZC-3036_request.xml", false);
	    }
	
	    [Test]
	    public void test_5_3_GET_getPushDecision() {
	        VsbNetGenericAsyncMethod.do_GET_PushDecisionV4(FILES_FOLDER + "vsb-mohm_DF106_5-3_TC_PDES3_testlink_eWZC-3038_request.xml", false);
	    }

	}
}
