﻿/*
 * Copyright (c) eHealth
 */
using System;
using ikvm.extensions;
using NUnit.Framework;
using java.io;
using java.util;
using org.joda.time;
using org.joda.time.format;
using be.fgov.ehealth.technicalconnector.tests.utils;
using be.ehealth.technicalconnector.config;
using be.ehealth.technicalconnector.exception;
using be.ehealth.technicalconnector.session;
using be.ehealth.technicalconnector.utils;
using be.fgov.ehealth.standards.kmehr.mycarenet.schema.v1;
using be.fgov.ehealth.technicalconnector.tests.session;
using be.ehealth.business.common.domain;
using be.ehealth.technicalconnector.adapter;
using be.cin.encrypted;
using be.fgov.ehealth.messageservices.mycarenet.core.v1;
using be.ehealth.businessconnector.mycarenet.attestv2.domain;
using be.ehealth.businessconnector.mycarenet.attestv2.session;
using be.fgov.ehealth.mycarenet.attest.protocol.v2;
using be.ehealth.businessconnector.attestv2.helper;

namespace be.ehealth.businessconnector.attestv2.session
{


	/**
	 * eAttest Integration Test. The scenarios numbering matches one specified by mycarenet.
	 *
	 * @author EHP
	 */
	[TestFixture]
	public class SendAttestDentistIntegrationTest {

		private static HashMap nissProvider = new HashMap();

		private static HashMap nissMatchScenario = new HashMap();
		
		private  AttestIntegrationTestHelper helper = new AttestIntegrationTestHelper();
		

		static object[] testCase =
		{
			new Object[]{"DENT1", "73052005540", "100", "DENT"},
			new Object[]{"DENT2", "73052005540", "100", "DENT"},
			new Object[]{"DENT3a", "73052005540", "100", "DENT"},
			new Object[]{"DENT3b", "73052005540", "100", "DENT"},
			new Object[]{"DENT4", "73052005540", "100", "DENT"},
			new Object[]{"DENT5", "81010924034", "100", "DENT"},
			new Object[]{"DENT6", "85020205931", "100", "DENT"},
			new Object[]{"DENT7", "85020205931", "100", "DENT"},
			new Object[]{"DENTFull", "73052005540", "100", "DENT"},

			// OA 500
			new Object[]{"DENT1", "62110906574", "500", "DENT"},
			new Object[]{"DENT2", "62110906574", "500", "DENT"},
			new Object[]{"DENT3a", "62110906574", "500", "DENT"},
			new Object[]{"DENT3b", "62110906574", "500", "DENT"},
			new Object[]{"DENT4", "62110906574", "500", "DENT"},
			new Object[]{"DENT5", "44042700342", "500", "DENT"},
			new Object[]{"DENT6", "46111636603", "500", "DENT"},
			new Object[]{"DENT7", "46111636603", "500", "DENT"},
			new Object[]{"DENTFull", "62110906574", "500", "DENT"}
			
		};

		[SetUp]
		public static  void setupsession() {
			SessionInitializer.init(".\\be.ehealth.businessconnector.attestv2.dentist.test.properties", SupportedLanguages.NET.getAbbreviation());
		}

		[TearDown]
		public static void teardownSession()  {
			Session.getInstance().unloadSession();
		}


		[Test, TestCaseSource("testCase")]
		public void sendAttestationTest(String scenarioName, String ssin, String oa, String profession) {
			InputReference inputReference = new InputReference();
            SendAttestBuilderRequest attestBuilderRequest = helper.buildRequest(inputReference, scenarioName, ssin, profession);
            SendAttestationResponse response = AttestSessionServiceFactory.getAttestService().sendAttestation(attestBuilderRequest.getSendAttestationRequest());
            SignedEncryptedBuilderResponse builderResponse = helper.getBuildSendAttestResponse(response, attestBuilderRequest);
			
			assertResult(inputReference, builderResponse, profession, oa, scenarioName);
		}
		
		private void assertResult(InputReference inputReference, SignedEncryptedBuilderResponse builderResponse, String profession, String oa, String scenarioName)  {
			
			Assert.AreEqual(0, builderResponse.getSignatureVerificationResult().getErrors().size(), "SignatureVerificationResult should contain no error");
			
			XmlAsserter.assertSimilar(ConnectorXmlUtils.toObject(builderResponse.getSignedData(), typeof(EncryptedKnownContent)), builderResponse.getRawDecryptedBlob());
			XmlAsserter.assertSimilar(ConnectorXmlUtils.toObject(builderResponse.getRawDecryptedBlob().getBusinessContent().getValue(),typeof(SendTransactionResponse)), builderResponse.getSendTransactionResponse());
			Assert.NotNull(builderResponse.getXades(),"Missing xades");
			Assert.True(Arrays.equals(builderResponse.getRawDecryptedBlob().getXades(),builderResponse.getXades()),"Xades different in blob and exposed xades");
			String expectedResponse = helper.buildExpectedSendAttestResponse(builderResponse, inputReference.getInputReference(), profession, oa, scenarioName);
			XmlAsserter.assertSimilar(expectedResponse, ConnectorXmlUtils.toString(builderResponse.getSendTransactionResponse()));
		}
	}

}
