package be.ehealth.businessconnector.test.vsbnet.async.session;


import be.cin.nip.async.generic.ConfirmResponse;
import be.ehealth.business.mycarenetdomaincommons.domain.InputReference;
import be.ehealth.businessconnector.genericasync.domain.GetRequest;
import be.ehealth.businessconnector.genericasync.domain.ProcessedGetResponse;
import be.ehealth.businessconnector.genericasync.domain.ProcessedMsgResponse;
import be.ehealth.businessconnector.genericasync.domain.ProcessedPostResponse;
import be.ehealth.businessconnector.genericasync.domain.ProcessedTAckResponse;
import be.ehealth.businessconnector.vsbnet.async.session.VsbNetSessionServiceFactory;
import be.ehealth.technicalconnector.exception.ConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.ehealth.technicalconnector.utils.ConnectorXmlUtils;
import be.fgov.ehealth.technicalconnector.signature.domain.SignatureVerificationResult;
import be.fgov.ehealth.technicalconnector.tests.utils.XmlAsserter;
import be.vlaanderen.mercurius.insurability.schemas.v1.WZCMHDF001DetermineInsurabilityRequest;
import be.vlaanderen.mercurius.insurability.schemas.v1.WZCMHDF001DetermineInsurabilityResponse;
import be.vlaanderen.mercurius.mohm.df103.v4.EMOHMDF103ConsultApplicationRequest;
import be.vlaanderen.mercurius.mohm.schemas.v1.EMOHMDF101CreateApplicationRequest;
import be.vlaanderen.mercurius.mohm.schemas.v1.EMOHMDF101CreateApplicationResponse;
import be.vlaanderen.mercurius.mohm.schemas.v1.EMOHMDF102CreateFictionalApplicationRequest;
import be.vlaanderen.mercurius.mohm.schemas.v1.EMOHMDF102CreateFictionalApplicationResponse;
import be.vlaanderen.mercurius.mohm.schemas.v1.EMOHMDF103ConsultApplicationResponse;
import be.vlaanderen.mercurius.mohm.schemas.v1.EMOHMDF103ConsultapplicationRequest;
import be.vlaanderen.mercurius.mohm.schemas.v1.EMOHMDF104ConsultSupportAndRepairRequest;
import be.vlaanderen.mercurius.mohm.schemas.v1.EMOHMDF104ConsultSupportAndRepairResponse;
import be.vlaanderen.mercurius.mohm.schemas.v1.EMOHMDF105ReportDeliveryRequest;
import be.vlaanderen.mercurius.mohm.schemas.v1.EMOHMDF105ReportDeliveryResponse;
import be.vlaanderen.mercurius.mohm.schemas.v1.EMOHMDF106PushDecisionRequest;
import be.vlaanderen.mercurius.mohm.schemas.v1.EMOHMDF107PushApplicationViewRequest;
import be.vlaanderen.mercurius.mohm.schemas.v1.EMOHMDF111CancelApplicationRequest;
import be.vlaanderen.mercurius.mohm.schemas.v1.EMOHMDF111CancelApplicationResponse;
import be.vlaanderen.mercurius.mohm.schemas.v1.EMOHMDF112ConsultSupportAndRepairListRequest;
import be.vlaanderen.mercurius.mohm.schemas.v1.EMOHMDF112ConsultSupportAndRepairListResponse;

import be.vlaanderen.mercurius.mohm.schemas.v1.MessageMetadataType;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

public class VsbNetGenericAsyncMethod {

    private static final Logger LOG = LoggerFactory.getLogger(VsbNetGenericAsyncMethod.class);
    private static final int SECONDS_WAITING = 60;

    /******************
     *
     * POST Methods
     *
     *******************/

    public static void do_POST_CreateApplication(String requestLocation) throws ConnectorException, InterruptedException {
        ProcessedPostResponse processedPostResponse = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .createApplication(ConnectorXmlUtils
                        .toObject(ConnectorIOUtils.getResourceAsByteArray(requestLocation),
                                EMOHMDF101CreateApplicationRequest.class), generateInputReference());
        String reference = processedPostResponse.getPostResponse().getReturn().getReference();
        waitForTack();
        ProcessedGetResponse<EMOHMDF101CreateApplicationResponse> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getCreateApplication(GetRequest.newBuilder().withReference(reference).build());
        confirmTacks(response);
        response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getCreateApplication(GetRequest.newBuilder().withReference(reference).build());
        assertTackRemoved(response.getTAckResponses());
    }

    public static void do_POST_CreateApplicationV3(String requestLocation) throws ConnectorException, InterruptedException {
        ProcessedPostResponse processedPostResponse = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .createApplicationV3(ConnectorXmlUtils
                        .toObject(ConnectorIOUtils.getResourceAsByteArray(requestLocation),
                                be.vlaanderen.mercurius.mohm.df101.v3.EMOHMDF101CreateApplicationRequest.class), generateInputReference());
        String reference = processedPostResponse.getPostResponse().getReturn().getReference();
        waitForTack();
        ProcessedGetResponse<be.vlaanderen.mercurius.mohm.df101.v3.EMOHMDF101CreateApplicationResponse> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getCreateApplicationV3(GetRequest.newBuilder().withReference(reference).build());
        confirmTacks(response);
        response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getCreateApplicationV3(GetRequest.newBuilder().withReference(reference).build());
        assertTackRemoved(response.getTAckResponses());
    }

    public static void do_POST_CreateFictionalApplication(String requestLocation) throws ConnectorException, InterruptedException {
        ProcessedPostResponse processedPostResponse = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .createFictionalApplication(ConnectorXmlUtils
                        .toObject(ConnectorIOUtils.getResourceAsByteArray(requestLocation),
                                EMOHMDF102CreateFictionalApplicationRequest.class), generateInputReference());
        String reference = processedPostResponse.getPostResponse().getReturn().getReference();
        waitForTack();
        ProcessedGetResponse<EMOHMDF102CreateFictionalApplicationResponse> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getCreateFictionalApplication(GetRequest.newBuilder().withReference(reference).build());
        confirmTacks(response);
        response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getCreateFictionalApplication(GetRequest.newBuilder().withReference(reference).build());
        assertTackRemoved(response.getTAckResponses());
    }

    public static void do_POST_ConsultHistory(String requestLocation) throws ConnectorException, InterruptedException {
        ProcessedPostResponse processedPostResponse = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .consultHistory(ConnectorXmlUtils
                        .toObject(ConnectorIOUtils.getResourceAsByteArray(requestLocation),
                                be.vlaanderen.mercurius.mohm.df102.v3.EMOHMDF102ConsultHistoryRequest.class), generateInputReference());
        String reference = processedPostResponse.getPostResponse().getReturn().getReference();
        waitForTack();
        ProcessedGetResponse<be.vlaanderen.mercurius.mohm.df102.v3.EMOHMDF102ConsultHistoryResponse> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getConsultHistory(GetRequest.newBuilder().withReference(reference).build());
        confirmTacks(response);
        response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getConsultHistory(GetRequest.newBuilder().withReference(reference).build());
        assertTackRemoved(response.getTAckResponses());
    }

    public static void do_POST_ConsultApplication(String requestLocation) throws ConnectorException, InterruptedException {
        ProcessedPostResponse processedPostResponse = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .consultApplication(ConnectorXmlUtils
                        .toObject(ConnectorIOUtils.getResourceAsByteArray(requestLocation),
                                EMOHMDF103ConsultapplicationRequest.class), generateInputReference());
        String reference = processedPostResponse.getPostResponse().getReturn().getReference();
        waitForTack();
        ProcessedGetResponse<EMOHMDF103ConsultApplicationResponse> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getConsultApplication(GetRequest.newBuilder().withReference(reference).build());
        confirmTacks(response);
        response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getConsultApplication(GetRequest.newBuilder().withReference(reference).build());
        assertTackRemoved(response.getTAckResponses());
    }

    public static void do_POST_ConsultApplicationV4(String requestLocation) throws ConnectorException, InterruptedException {
        ProcessedPostResponse processedPostResponse = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .consultApplicationV4(ConnectorXmlUtils
                        .toObject(ConnectorIOUtils.getResourceAsByteArray(requestLocation),
                                EMOHMDF103ConsultApplicationRequest.class), generateInputReference());
        String reference = processedPostResponse.getPostResponse().getReturn().getReference();
        waitForTack();
        ProcessedGetResponse<be.vlaanderen.mercurius.mohm.df103.v4.EMOHMDF103ConsultApplicationResponse> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getConsultApplicationV4(GetRequest.newBuilder().withReference(reference).build());
        confirmTacks(response);
        response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getConsultApplicationV4(GetRequest.newBuilder().withReference(reference).build());
        assertTackRemoved(response.getTAckResponses());
    }

    public static void do_POST_ConsultSupportAndRepair(String requestLocation) throws ConnectorException, InterruptedException {
        ProcessedPostResponse processedPostResponse = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .consultSupportAndRepair(ConnectorXmlUtils
                        .toObject(ConnectorIOUtils.getResourceAsByteArray(requestLocation),
                                EMOHMDF104ConsultSupportAndRepairRequest.class), generateInputReference());
        String reference = processedPostResponse.getPostResponse().getReturn().getReference();
        waitForTack();
        ProcessedGetResponse<EMOHMDF104ConsultSupportAndRepairResponse> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getConsultSupportAndRepair(GetRequest.newBuilder().withReference(reference).build());
        VsbNetSessionServiceFactory.getVsbNetMohmService().confirmTAck(response.getTAckResponses().get(0));
        response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getConsultSupportAndRepair(GetRequest.newBuilder().withReference(reference).build());
        assertTackRemoved(response.getTAckResponses());
    }

    public static void do_POST_ConsultSupportAndRepairV4(String requestLocation) throws ConnectorException, InterruptedException {
        ProcessedPostResponse processedPostResponse = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .consultSupportAndRepairV4(ConnectorXmlUtils
                        .toObject(ConnectorIOUtils.getResourceAsByteArray(requestLocation),
                                be.vlaanderen.mercurius.mohm.df104.v4.EMOHMDF104ConsultSupportAndRepairRequest.class), generateInputReference());
        String reference = processedPostResponse.getPostResponse().getReturn().getReference();
        waitForTack();
        ProcessedGetResponse<be.vlaanderen.mercurius.mohm.df104.v4.EMOHMDF104ConsultSupportAndRepairResponse> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getConsultSupportAndRepairV4(GetRequest.newBuilder().withReference(reference).build());
        VsbNetSessionServiceFactory.getVsbNetMohmService().confirmTAck(response.getTAckResponses().get(0));
        response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getConsultSupportAndRepairV4(GetRequest.newBuilder().withReference(reference).build());
        assertTackRemoved(response.getTAckResponses());
    }

    public static void do_POST_ReportDelivery(String requestLocation) throws ConnectorException, InterruptedException {
        ProcessedPostResponse processedPostResponse = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .reportDelivery(ConnectorXmlUtils
                        .toObject(ConnectorIOUtils.getResourceAsByteArray(requestLocation),
                                EMOHMDF105ReportDeliveryRequest.class), generateInputReference());
        String reference = processedPostResponse.getPostResponse().getReturn().getReference();
        waitForTack();
        ProcessedGetResponse<EMOHMDF105ReportDeliveryResponse> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getReportDelivery(GetRequest.newBuilder().withReference(reference).build());
        confirmTacks(response);
        response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getReportDelivery(GetRequest.newBuilder().withReference(reference).build());
        assertTackRemoved(response.getTAckResponses());
    }

    public static void do_POST_CancelApplication(String requestLocation) throws ConnectorException, InterruptedException {
        ProcessedPostResponse processedPostResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().cancelApplication(ConnectorXmlUtils
                .toObject(ConnectorIOUtils.getResourceAsByteArray(requestLocation),
                        EMOHMDF111CancelApplicationRequest.class), generateInputReference());
        String reference = processedPostResponse.getPostResponse().getReturn().getReference();
        waitForTack();
        ProcessedGetResponse<EMOHMDF111CancelApplicationResponse> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getCancelApplication(GetRequest.newBuilder().withReference(reference).build());
        VsbNetSessionServiceFactory.getVsbNetMohmService().confirmTAck(response.getTAckResponses().get(0));
        response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getCancelApplication(GetRequest.newBuilder().withReference(reference).build());
        assertTackRemoved(response.getTAckResponses());
    }

    public static void do_POST_ConsultSupportAndRepairList(String requestLocation) throws ConnectorException, InterruptedException {
        ProcessedPostResponse processedPostResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().consultSupportAndRepairList(ConnectorXmlUtils
                .toObject(ConnectorIOUtils.getResourceAsByteArray(requestLocation),
                        EMOHMDF112ConsultSupportAndRepairListRequest.class), generateInputReference());
        String reference = processedPostResponse.getPostResponse().getReturn().getReference();
        waitForTack();
        ProcessedGetResponse<EMOHMDF112ConsultSupportAndRepairListResponse> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getConsultSupportAndRepairList(GetRequest.newBuilder().withReference(reference).build());
        VsbNetSessionServiceFactory.getVsbNetMohmService().confirmTAck(response.getTAckResponses().get(0));
        response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getConsultSupportAndRepairList(GetRequest.newBuilder().withReference(reference).build());
        assertTackRemoved(response.getTAckResponses());
    }

    public static void do_POST_ConsultSupportAndRepairListV2(String requestLocation) throws ConnectorException, InterruptedException {
        ProcessedPostResponse processedPostResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().consultSupportAndRepairListV2(ConnectorXmlUtils
                .toObject(ConnectorIOUtils.getResourceAsByteArray(requestLocation),
                        be.vlaanderen.mercurius.mohm.df112.v2.EMOHMDF112ConsultSupportAndRepairListRequest.class), generateInputReference());
        String reference = processedPostResponse.getPostResponse().getReturn().getReference();
        waitForTack();
        ProcessedGetResponse<be.vlaanderen.mercurius.mohm.df112.v2.EMOHMDF112ConsultSupportAndRepairListResponse> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getConsultSupportAndRepairListV2(GetRequest.newBuilder().withReference(reference).build());
        VsbNetSessionServiceFactory.getVsbNetMohmService().confirmTAck(response.getTAckResponses().get(0));
        response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getConsultSupportAndRepairListV2(GetRequest.newBuilder().withReference(reference).build());
        assertTackRemoved(response.getTAckResponses());
    }

    public static void do_POST_RefusedInvoice(String requestLocation) throws ConnectorException, InterruptedException {
        ProcessedPostResponse processedPostResponse = VsbNetSessionServiceFactory.getVsbNetInvoiceService()
                .postInvoiceList(ConnectorIOUtils.getResourceAsByteArray(requestLocation), generateInputReference());
        String reference = processedPostResponse.getPostResponse().getReturn().getReference();
        waitForTack();
        ProcessedGetResponse<byte[]> response = VsbNetSessionServiceFactory.getVsbNetInvoiceService()
                .getListInvoiceFileRefused(GetRequest.newBuilder().withReference(reference).build());
        validateXadesTOfTAckResponseWithManifest(processedPostResponse, response);
        confirmTacks(response);
        response = VsbNetSessionServiceFactory.getVsbNetInvoiceService()
                .getListInvoiceFileRefused(GetRequest.newBuilder().withReference(reference).build());
        assertTackRemoved(response.getTAckResponses());
    }

    public static void do_POST_AcceptedInvoice(String requestLocation) throws ConnectorException, InterruptedException {
        ProcessedPostResponse processedPostResponse = VsbNetSessionServiceFactory.getVsbNetInvoiceService()
                .postInvoiceList(ConnectorIOUtils.getResourceAsByteArray(requestLocation), generateInputReference());
        String reference = processedPostResponse.getPostResponse().getReturn().getReference();
        waitForTack();
        ProcessedGetResponse<byte[]> response = VsbNetSessionServiceFactory.getVsbNetInvoiceService()
                .getListInvoiceFileAccepted(GetRequest.newBuilder().withReference(reference).build());
        confirmTacks(response);
        response = VsbNetSessionServiceFactory.getVsbNetInvoiceService()
                .getListInvoiceAccepted1(GetRequest.newBuilder().withReference(reference).build());
        confirmTacks(response);
        response = VsbNetSessionServiceFactory.getVsbNetInvoiceService()
                .getListInvoiceAccepted2(GetRequest.newBuilder().withReference(reference).build());
        confirmTacks(response);
        response = VsbNetSessionServiceFactory.getVsbNetInvoiceService()
                .getListInvoiceAccepted1(GetRequest.newBuilder().withReference(reference).build());
        assertTackRemoved(response.getTAckResponses());
        response = VsbNetSessionServiceFactory.getVsbNetInvoiceService()
                .getListInvoiceAccepted2(GetRequest.newBuilder().withReference(reference).build());
        assertTackRemoved(response.getTAckResponses());
    }

    public static void do_POST_DetermineInsurability(String requestLocation) throws ConnectorException, InterruptedException {
        ProcessedPostResponse processedPostResponse = VsbNetSessionServiceFactory.getVsbNetInsurabilityService()
                .determineInsurability(ConnectorXmlUtils
                        .toObject(ConnectorIOUtils.getResourceAsByteArray(requestLocation),
                                WZCMHDF001DetermineInsurabilityRequest.class), generateInputReference());
        String reference = processedPostResponse.getPostResponse().getReturn().getReference();
        waitForTack();
        ProcessedGetResponse<WZCMHDF001DetermineInsurabilityResponse> response = VsbNetSessionServiceFactory.getVsbNetInsurabilityService()
                .getDetermineInsurability(GetRequest.newBuilder().withReference(reference).build());
        confirmTack(response.getTAckResponses().get(0));
        response = VsbNetSessionServiceFactory.getVsbNetInsurabilityService()
                .getDetermineInsurability(GetRequest.newBuilder().withReference(reference).build());
        assertTackRemoved(response.getTAckResponses());
    }

    /******************
     *
     * GET Methods
     *
     *******************/

    public static void do_GET_CreateApplication(String responseLocation, Boolean toConfirm) throws Exception {
        ProcessedGetResponse<EMOHMDF101CreateApplicationResponse> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getCreateApplication(GetRequest.newBuilder().withDefaults().build());

        assertCreateApplication(responseLocation, response);

        if (toConfirm) {
            ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
            assertNotNull(confirmResponse);
        }
    }

    public static void do_GET_CreateApplicationV3(String responseLocation, Boolean toConfirm) throws Exception {
        ProcessedGetResponse<be.vlaanderen.mercurius.mohm.df101.v3.EMOHMDF101CreateApplicationResponse> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getCreateApplicationV3(GetRequest.newBuilder().withDefaults().build());

        assertCreateApplicationV3(responseLocation, response);

        if (toConfirm) {
            ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
            assertNotNull(confirmResponse);
        }
    }

    public static void do_GET_CreateFictionalApplication(String responseLocation, Boolean toConfirm) throws Exception {
        ProcessedGetResponse<EMOHMDF102CreateFictionalApplicationResponse> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getCreateFictionalApplication(GetRequest.newBuilder().withDefaults().build());

        assertCreateFictionalApplication(responseLocation, response);

        if (toConfirm) {
            ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
            assertNotNull(confirmResponse);
        }
    }

    public static void do_GET_ConsultHistory(String responseLocation, Boolean toConfirm) throws Exception {

        ProcessedGetResponse<be.vlaanderen.mercurius.mohm.df102.v3.EMOHMDF102ConsultHistoryResponse> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getConsultHistory(GetRequest.newBuilder().withDefaults().build());

        assertConsultHistory(responseLocation, response);

        if (toConfirm) {
            ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
            assertNotNull(confirmResponse);
        }
    }

    public static void do_GET_ConsultApplication(String responseLocation, Boolean toConfirm) throws Exception {
        ProcessedGetResponse<EMOHMDF103ConsultApplicationResponse> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getConsultApplication(GetRequest.newBuilder().withDefaults().build());

        assertConsultApplication(responseLocation, response);

        if (toConfirm) {
            ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
            assertNotNull(confirmResponse);
        }
    }

    public static void do_GET_ConsultApplicationV4(String responseLocation, Boolean toConfirm) throws Exception {
        ProcessedGetResponse<be.vlaanderen.mercurius.mohm.df103.v4.EMOHMDF103ConsultApplicationResponse> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getConsultApplicationV4(GetRequest.newBuilder().withDefaults().build());

        assertConsultApplicationV4(responseLocation, response);

        if (toConfirm) {
            ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
            assertNotNull(confirmResponse);
        }
    }

    public static void do_GET_ConsultSupportAndRepair(String responseLocation, Boolean toConfirm) throws Exception {
        ProcessedGetResponse<EMOHMDF104ConsultSupportAndRepairResponse> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getConsultSupportAndRepair(GetRequest.newBuilder().withDefaults().build());

        assertConsultSupportAndRepair(responseLocation, response);

        if (toConfirm) {
            ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
            assertNotNull(confirmResponse);
        }
    }

    public static void do_GET_ConsultSupportAndRepairV4(String responseLocation, Boolean toConfirm) throws Exception {
        ProcessedGetResponse<be.vlaanderen.mercurius.mohm.df104.v4.EMOHMDF104ConsultSupportAndRepairResponse> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getConsultSupportAndRepairV4(GetRequest.newBuilder().withDefaults().build());

        assertConsultSupportAndRepairV4(responseLocation, response);

        if (toConfirm) {
            ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
            assertNotNull(confirmResponse);
        }
    }

    public static void do_GET_ReportDelivery(String responseLocation, Boolean toConfirm) throws Exception {
        ProcessedGetResponse<EMOHMDF105ReportDeliveryResponse> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getReportDelivery(GetRequest.newBuilder().withDefaults().build());

        assertReportDelivery(responseLocation, response);

        if (toConfirm) {
            ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
            assertNotNull(confirmResponse);
        }
    }

    public static void do_GET_PushDecision(String responseLocation, Boolean toConfirm) throws Exception {
        ProcessedGetResponse<EMOHMDF106PushDecisionRequest> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getPushDecision(GetRequest.newBuilder().withDefaults().build());

        assertPushDecision(responseLocation, response);

        if (toConfirm) {
            ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
            assertNotNull(confirmResponse);
        }
    }

    public static void do_GET_PushDecisionV4(String responseLocation, Boolean toConfirm) throws Exception {
        ProcessedGetResponse<be.vlaanderen.mercurius.mohm.df106.v4.EMOHMDF106PushDecisionRequest> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getPushDecisionV4(GetRequest.newBuilder().withDefaults().build());

        assertPushDecisionV4(responseLocation, response);

        if (toConfirm) {
            ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
            assertNotNull(confirmResponse);
        }
    }

    public static void do_GET_PushApplicationView(String responseLocation, Boolean toConfirm) throws Exception {
        ProcessedGetResponse<EMOHMDF107PushApplicationViewRequest> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getPushApplicationView(GetRequest.newBuilder().withDefaults().build());

        assertPushApplicationView(responseLocation, response);

        if (toConfirm) {
            ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
            assertNotNull(confirmResponse);
        }
    }

    public static void do_GET_PushApplicationViewV4(String responseLocation, Boolean toConfirm) throws Exception {
        ProcessedGetResponse<be.vlaanderen.mercurius.mohm.df107.v4.EMOHMDF107PushApplicationViewRequest> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getPushApplicationViewV4(GetRequest.newBuilder().withDefaults().build());

        assertPushApplicationViewV4(responseLocation, response);

        if (toConfirm) {
            ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
            assertNotNull(confirmResponse);
        }
    }

    public static void do_GET_CancelApplication(String responseLocation, Boolean toConfirm) throws Exception {
        ProcessedGetResponse<EMOHMDF111CancelApplicationResponse> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getCancelApplication(GetRequest.newBuilder().withDefaults().build());

        assertCancelApplication(responseLocation, response);

        if (toConfirm) {
            ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
            assertNotNull(confirmResponse);
        }
    }

    public static void do_GET_ConsultSupportAndRepairList(String responseLocation, Boolean toConfirm) throws Exception {
        ProcessedGetResponse<EMOHMDF112ConsultSupportAndRepairListResponse> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getConsultSupportAndRepairList(GetRequest.newBuilder().withDefaults().build());

        assertConsultSupportAndRepairList(responseLocation, response);

        if (toConfirm) {
            ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
            assertNotNull(confirmResponse);
        }
    }

    public static void do_GET_ConsultSupportAndRepairListV2(String responseLocation, Boolean toConfirm) throws Exception {
        ProcessedGetResponse<be.vlaanderen.mercurius.mohm.df112.v2.EMOHMDF112ConsultSupportAndRepairListResponse> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getConsultSupportAndRepairListV2(GetRequest.newBuilder().withDefaults().build());

        assertConsultSupportAndRepairListV2(responseLocation, response);

        if (toConfirm) {
            ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
            assertNotNull(confirmResponse);
        }
    }

    public static void do_GET_ListInvoiceFileAccepted(String responseLocation, Boolean toConfirm) throws Exception {
        ProcessedGetResponse<byte[]> response = VsbNetSessionServiceFactory.getVsbNetInvoiceService()
                .getListInvoiceFileAccepted(GetRequest.newBuilder().withDefaults().build());

        assertInvoiceList(responseLocation, response);

        if (toConfirm) {
            ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
            assertNotNull(confirmResponse);
        }
    }

    public static void do_GET_ListInvoiceAccepted1(String responseLocation, Boolean toConfirm) throws Exception {
        ProcessedGetResponse<byte[]> response = VsbNetSessionServiceFactory.getVsbNetInvoiceService()
                .getListInvoiceAccepted1(GetRequest.newBuilder().withDefaults().build());

        assertInvoiceList(responseLocation, response);

        if (toConfirm) {
            ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
            assertNotNull(confirmResponse);
        }
    }

    public static void do_GET_ListInvoiceAccepted2(String responseLocation, Boolean toConfirm) throws Exception {
        ProcessedGetResponse<byte[]> response = VsbNetSessionServiceFactory.getVsbNetInvoiceService()
                .getListInvoiceAccepted2(GetRequest.newBuilder().withDefaults().build());

        assertInvoiceList(responseLocation, response);

        if (toConfirm) {
            ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
            assertNotNull(confirmResponse);
        }
    }

    public static void do_GET_ListInvoiceRefused(String responseLocation, Boolean toConfirm) throws Exception {
        ProcessedGetResponse<byte[]> response = VsbNetSessionServiceFactory.getVsbNetInvoiceService()
                .getListInvoiceRefused(GetRequest.newBuilder().withDefaults().build());

        assertInvoiceList(responseLocation, response);

        if (toConfirm) {
            ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
            assertNotNull(confirmResponse);
        }
    }

    public static void do_GET_ListInvoiceFileRefused(String responseLocation, Boolean toConfirm) throws Exception {
        ProcessedGetResponse<byte[]> response = VsbNetSessionServiceFactory.getVsbNetInvoiceService()
                .getListInvoiceFileRefused(GetRequest.newBuilder().withDefaults().build());

        assertInvoiceList(responseLocation, response);

        if (toConfirm) {
            ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
            assertNotNull(confirmResponse);
        }
    }

    public static void do_GET_DetermineInsurability(String responseLocation, Boolean toConfirm) throws Exception {
        ProcessedGetResponse<WZCMHDF001DetermineInsurabilityResponse> response = VsbNetSessionServiceFactory.getVsbNetInsurabilityService()
                .getDetermineInsurability(GetRequest.newBuilder().withDefaults().build());

        assertDetermineInsurability(responseLocation, response);

        if (toConfirm) {
            ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
            assertNotNull(confirmResponse);
        }
    }

    /******************
     *
     * Test assertions
     *
     *******************/

    private static void assertCreateApplication(String expectedResponse, ProcessedGetResponse<EMOHMDF101CreateApplicationResponse> response) throws Exception {
        String expectedString = ConnectorIOUtils.getResourceAsString(expectedResponse);
        EMOHMDF101CreateApplicationResponse expected = ConnectorXmlUtils.toObject(expectedString, EMOHMDF101CreateApplicationResponse.class);
        for (int i = response.getMsgResponses().size() - 1; i >= 0; i--) {
            EMOHMDF101CreateApplicationResponse businessResponse = response.getMsgResponses().get(i).getBusinessResponse();
            if (matchesMetadata(expected.getMessageMetadata(), businessResponse.getMessageMetadata())) {
                XmlAsserter.assertSimilar(expectedString, ConnectorXmlUtils.toString(businessResponse));
                return;
            }
        }
        failNoMessageResponse();
    }

    private static void assertCreateApplicationV3(String expectedResponse, ProcessedGetResponse<be.vlaanderen.mercurius.mohm.df101.v3.EMOHMDF101CreateApplicationResponse> response) throws Exception {
        String expectedString = ConnectorIOUtils.getResourceAsString(expectedResponse);
        be.vlaanderen.mercurius.mohm.df101.v3.EMOHMDF101CreateApplicationResponse expected = ConnectorXmlUtils.toObject(expectedString, be.vlaanderen.mercurius.mohm.df101.v3.EMOHMDF101CreateApplicationResponse.class);
        for (int i = response.getMsgResponses().size() - 1; i >= 0; i--) {
            be.vlaanderen.mercurius.mohm.df101.v3.EMOHMDF101CreateApplicationResponse businessResponse = response.getMsgResponses().get(i).getBusinessResponse();
            if (matchesMetadata(expected.getMessageMetadata(), businessResponse.getMessageMetadata())) {
                XmlAsserter.assertSimilar(expectedString, ConnectorXmlUtils.toString(businessResponse));
                return;
            }
        }
        failNoMessageResponse();
    }

    private static void assertCreateFictionalApplication(String expectedResponse, ProcessedGetResponse<EMOHMDF102CreateFictionalApplicationResponse> response) throws Exception {
        String expectedString = ConnectorIOUtils.getResourceAsString(expectedResponse);
        EMOHMDF102CreateFictionalApplicationResponse expected = ConnectorXmlUtils.toObject(expectedString, EMOHMDF102CreateFictionalApplicationResponse.class);
        for (int i = response.getMsgResponses().size() - 1; i >= 0; i--) {
            EMOHMDF102CreateFictionalApplicationResponse businessResponse = response.getMsgResponses().get(i).getBusinessResponse();
            if (matchesMetadata(expected.getMessageMetadata(), businessResponse.getMessageMetadata())) {
                XmlAsserter.assertSimilar(expectedString, ConnectorXmlUtils.toString(businessResponse));
                return;
            }
        }
        failNoMessageResponse();
    }

    private static void assertConsultHistory(String expectedResponse, ProcessedGetResponse<be.vlaanderen.mercurius.mohm.df102.v3.EMOHMDF102ConsultHistoryResponse> response) throws Exception {
        String expectedString = ConnectorIOUtils.getResourceAsString(expectedResponse);
        be.vlaanderen.mercurius.mohm.df102.v3.EMOHMDF102ConsultHistoryResponse expected = ConnectorXmlUtils.toObject(expectedString, be.vlaanderen.mercurius.mohm.df102.v3.EMOHMDF102ConsultHistoryResponse.class);
        for (int i = response.getMsgResponses().size() - 1; i >= 0; i--) {
            be.vlaanderen.mercurius.mohm.df102.v3.EMOHMDF102ConsultHistoryResponse businessResponse = response.getMsgResponses().get(i).getBusinessResponse();
            if (matchesMetadata(expected.getMessageMetadata(), businessResponse.getMessageMetadata())) {
                XmlAsserter.assertSimilar(expectedString, ConnectorXmlUtils.toString(businessResponse));
                return;
            }
        }
        failNoMessageResponse();
    }

    private static void assertConsultApplication(String expectedResponse, ProcessedGetResponse<EMOHMDF103ConsultApplicationResponse> response) throws Exception {
        String expectedString = ConnectorIOUtils.getResourceAsString(expectedResponse);
        EMOHMDF103ConsultApplicationResponse expected = ConnectorXmlUtils.toObject(expectedString, EMOHMDF103ConsultApplicationResponse.class);
        for (int i = response.getMsgResponses().size() - 1; i >= 0; i--) {
            EMOHMDF103ConsultApplicationResponse businessResponse = response.getMsgResponses().get(i).getBusinessResponse();
            if (matchesMetadata(expected.getMessageMetadata(), businessResponse.getMessageMetadata())) {
                XmlAsserter.assertSimilar(expectedString, ConnectorXmlUtils.toString(businessResponse));
                return;
            }
        }
        failNoMessageResponse();
    }

    private static void assertConsultApplicationV4(String expectedResponse, ProcessedGetResponse<be.vlaanderen.mercurius.mohm.df103.v4.EMOHMDF103ConsultApplicationResponse> response) throws Exception {
        String expectedString = ConnectorIOUtils.getResourceAsString(expectedResponse);
        be.vlaanderen.mercurius.mohm.df103.v4.EMOHMDF103ConsultApplicationResponse expected = ConnectorXmlUtils.toObject(expectedString, be.vlaanderen.mercurius.mohm.df103.v4.EMOHMDF103ConsultApplicationResponse.class);
        for (int i = response.getMsgResponses().size() - 1; i >= 0; i--) {
            be.vlaanderen.mercurius.mohm.df103.v4.EMOHMDF103ConsultApplicationResponse businessResponse = response.getMsgResponses().get(i).getBusinessResponse();
            if (matchesMetadata(expected.getMessageMetadata(), businessResponse.getMessageMetadata())) {
                XmlAsserter.assertSimilar(expectedString, ConnectorXmlUtils.toString(businessResponse));
                return;
            }
        }
        failNoMessageResponse();
    }

    private static void assertConsultSupportAndRepair(String expectedResponse, ProcessedGetResponse<EMOHMDF104ConsultSupportAndRepairResponse> response) throws Exception {
        String expectedString = ConnectorIOUtils.getResourceAsString(expectedResponse);
        EMOHMDF104ConsultSupportAndRepairResponse expected = ConnectorXmlUtils.toObject(expectedString, EMOHMDF104ConsultSupportAndRepairResponse.class);
        for (int i = response.getMsgResponses().size() - 1; i >= 0; i--) {
            EMOHMDF104ConsultSupportAndRepairResponse businessResponse = response.getMsgResponses().get(i).getBusinessResponse();
            if (matchesMetadata(expected.getMessageMetadata(), businessResponse.getMessageMetadata())) {
                XmlAsserter.assertSimilar(expectedString, ConnectorXmlUtils.toString(businessResponse));
                return;
            }
        }
        failNoMessageResponse();
    }

    private static void assertConsultSupportAndRepairV4(String expectedResponse, ProcessedGetResponse<be.vlaanderen.mercurius.mohm.df104.v4.EMOHMDF104ConsultSupportAndRepairResponse> response) throws Exception {
        String expectedString = ConnectorIOUtils.getResourceAsString(expectedResponse);
        be.vlaanderen.mercurius.mohm.df104.v4.EMOHMDF104ConsultSupportAndRepairResponse expected = ConnectorXmlUtils.toObject(expectedString, be.vlaanderen.mercurius.mohm.df104.v4.EMOHMDF104ConsultSupportAndRepairResponse.class);
        for (int i = response.getMsgResponses().size() - 1; i >= 0; i--) {
            be.vlaanderen.mercurius.mohm.df104.v4.EMOHMDF104ConsultSupportAndRepairResponse businessResponse = response.getMsgResponses().get(i).getBusinessResponse();
            if (matchesMetadata(expected.getMessageMetadata(), businessResponse.getMessageMetadata())) {
                XmlAsserter.assertSimilar(expectedString, ConnectorXmlUtils.toString(businessResponse));
                return;
            }
        }
        failNoMessageResponse();
    }

    private static void assertReportDelivery(String expectedResponse, ProcessedGetResponse<EMOHMDF105ReportDeliveryResponse> response) throws Exception {
        String expectedString = ConnectorIOUtils.getResourceAsString(expectedResponse);
        EMOHMDF105ReportDeliveryResponse expected = ConnectorXmlUtils.toObject(expectedString, EMOHMDF105ReportDeliveryResponse.class);
        for (int i = response.getMsgResponses().size() - 1; i >= 0; i--) {
            EMOHMDF105ReportDeliveryResponse businessResponse = response.getMsgResponses().get(i).getBusinessResponse();
            if (matchesMetadata(expected.getMessageMetadata(), businessResponse.getMessageMetadata())) {
                XmlAsserter.assertSimilar(expectedString, ConnectorXmlUtils.toString(businessResponse));
                return;
            }
        }
        failNoMessageResponse();
    }

    private static void assertPushDecision(String expectedResponse, ProcessedGetResponse<EMOHMDF106PushDecisionRequest> response) throws Exception {
        String expectedString = ConnectorIOUtils.getResourceAsString(expectedResponse);
        EMOHMDF106PushDecisionRequest expected = ConnectorXmlUtils.toObject(expectedString, EMOHMDF106PushDecisionRequest.class);
        for (int i = response.getMsgResponses().size() - 1; i >= 0; i--) {
            EMOHMDF106PushDecisionRequest businessResponse = response.getMsgResponses().get(i).getBusinessResponse();
            if (matchesMetadata(expected.getMessageMetadata(), businessResponse.getMessageMetadata())) {
                XmlAsserter.assertSimilar(expectedString, ConnectorXmlUtils.toString(businessResponse));
                return;
            }
        }
        failNoMessageResponse();

    }

    private static void assertPushDecisionV4(String expectedResponse, ProcessedGetResponse<be.vlaanderen.mercurius.mohm.df106.v4.EMOHMDF106PushDecisionRequest> response) throws Exception {
        String expectedString = ConnectorIOUtils.getResourceAsString(expectedResponse);
        be.vlaanderen.mercurius.mohm.df106.v4.EMOHMDF106PushDecisionRequest expected = ConnectorXmlUtils.toObject(expectedString, be.vlaanderen.mercurius.mohm.df106.v4.EMOHMDF106PushDecisionRequest.class);
        for (int i = response.getMsgResponses().size() - 1; i >= 0; i--) {
            be.vlaanderen.mercurius.mohm.df106.v4.EMOHMDF106PushDecisionRequest businessResponse = response.getMsgResponses().get(i).getBusinessResponse();
            if (matchesMetadata(expected.getMessageMetadata(), businessResponse.getMessageMetadata())) {
                XmlAsserter.assertSimilar(expectedString, ConnectorXmlUtils.toString(businessResponse));
                return;
            }
        }
        failNoMessageResponse();
    }

    private static void assertPushApplicationView(String expectedResponse, ProcessedGetResponse<EMOHMDF107PushApplicationViewRequest> response) throws Exception {
        String expectedString = ConnectorIOUtils.getResourceAsString(expectedResponse);
        EMOHMDF107PushApplicationViewRequest expected = ConnectorXmlUtils.toObject(expectedString, EMOHMDF107PushApplicationViewRequest.class);
        for (int i = response.getMsgResponses().size() - 1; i >= 0; i--) {
            EMOHMDF107PushApplicationViewRequest businessResponse = response.getMsgResponses().get(i).getBusinessResponse();
            if (matchesMetadata(expected.getMessageMetadata(), businessResponse.getMessageMetadata())) {
                XmlAsserter.assertSimilar(expectedString, ConnectorXmlUtils.toString(businessResponse));
                return;
            }
        }
        failNoMessageResponse();

    }

    private static void assertPushApplicationViewV4(String expectedResponse, ProcessedGetResponse<be.vlaanderen.mercurius.mohm.df107.v4.EMOHMDF107PushApplicationViewRequest> response) throws Exception {
        String expectedString = ConnectorIOUtils.getResourceAsString(expectedResponse);
        be.vlaanderen.mercurius.mohm.df107.v4.EMOHMDF107PushApplicationViewRequest
                expected = ConnectorXmlUtils.toObject(expectedString, be.vlaanderen.mercurius.mohm.df107.v4.EMOHMDF107PushApplicationViewRequest.class);
        for (int i = response.getMsgResponses().size() - 1; i >= 0; i--) {
            be.vlaanderen.mercurius.mohm.df107.v4.EMOHMDF107PushApplicationViewRequest businessResponse = response.getMsgResponses().get(i).getBusinessResponse();
            if (matchesMetadata(expected.getMessageMetadata(), businessResponse.getMessageMetadata())) {
                XmlAsserter.assertSimilar(expectedString, ConnectorXmlUtils.toString(businessResponse));
                return;
            }
        }
        failNoMessageResponse();
    }

    private static void assertCancelApplication(String expectedResponse, ProcessedGetResponse<EMOHMDF111CancelApplicationResponse> response) throws Exception {
        String expectedString = ConnectorIOUtils.getResourceAsString(expectedResponse);
        EMOHMDF111CancelApplicationResponse expected = ConnectorXmlUtils.toObject(expectedString, EMOHMDF111CancelApplicationResponse.class);
        for (int i = response.getMsgResponses().size() - 1; i >= 0; i--) {
            EMOHMDF111CancelApplicationResponse businessResponse = response.getMsgResponses().get(i).getBusinessResponse();
            if (matchesMetadata(expected.getMessageMetadata(), businessResponse.getMessageMetadata())) {
                XmlAsserter.assertSimilar(expectedString, ConnectorXmlUtils.toString(businessResponse));
                return;
            }
        }
        failNoMessageResponse();
    }

    private static void assertConsultSupportAndRepairList(String expectedResponse, ProcessedGetResponse<EMOHMDF112ConsultSupportAndRepairListResponse> response) throws Exception {
        String expectedString = ConnectorIOUtils.getResourceAsString(expectedResponse);
        EMOHMDF112ConsultSupportAndRepairListResponse expected = ConnectorXmlUtils.toObject(expectedString, EMOHMDF112ConsultSupportAndRepairListResponse.class);
        for (int i = response.getMsgResponses().size() - 1; i >= 0; i--) {
            EMOHMDF112ConsultSupportAndRepairListResponse businessResponse = response.getMsgResponses().get(i).getBusinessResponse();
            if (matchesMetadata(expected.getMessageMetadata(), businessResponse.getMessageMetadata())) {
                XmlAsserter.assertSimilar(expectedString, ConnectorXmlUtils.toString(businessResponse));
                return;
            }
        }
        failNoMessageResponse();

    }

    private static void assertConsultSupportAndRepairListV2(String expectedResponse, ProcessedGetResponse<be.vlaanderen.mercurius.mohm.df112.v2.EMOHMDF112ConsultSupportAndRepairListResponse> response) throws Exception {
        String expectedString = ConnectorIOUtils.getResourceAsString(expectedResponse);
        be.vlaanderen.mercurius.mohm.df112.v2.EMOHMDF112ConsultSupportAndRepairListResponse
                expected = ConnectorXmlUtils.toObject(expectedString, be.vlaanderen.mercurius.mohm.df112.v2.EMOHMDF112ConsultSupportAndRepairListResponse.class);
        for (int i = response.getMsgResponses().size() - 1; i >= 0; i--) {
            be.vlaanderen.mercurius.mohm.df112.v2.EMOHMDF112ConsultSupportAndRepairListResponse businessResponse = response.getMsgResponses().get(i).getBusinessResponse();
            if (matchesMetadata(expected.getMessageMetadata(), businessResponse.getMessageMetadata())) {
                XmlAsserter.assertSimilar(expectedString, ConnectorXmlUtils.toString(businessResponse));
                return;
            }
        }
        failNoMessageResponse();
    }

    private static void assertInvoiceList(String expectedResponse, ProcessedGetResponse<byte[]> response) throws Exception {
        byte[] expected = ConnectorIOUtils.getResourceAsByteArray(expectedResponse);
        for (ProcessedMsgResponse<byte[]> processedMsgResponse : response.getMsgResponses()) {

            assertEquals(new String(expected), new String(processedMsgResponse.getBusinessResponse()));
            assertEquals("SignatureVerificationResult should contain no error", 0, processedMsgResponse.getSignatureVerificationResult().getErrors().size());
            assertNotNull("Missing xades", processedMsgResponse.getMsgResponse().getXadesT());
            assertTrue("Signed data and businessResponse content do not match", Arrays.equals((byte[]) processedMsgResponse.getBusinessResponse(), processedMsgResponse.getSignedData()));
        }
    }

    private static void assertDetermineInsurability(String expectedResponse, ProcessedGetResponse<WZCMHDF001DetermineInsurabilityResponse> response) throws Exception {
        WZCMHDF001DetermineInsurabilityResponse expected = ConnectorXmlUtils.toObject(ConnectorIOUtils.getResourceAsString(expectedResponse), WZCMHDF001DetermineInsurabilityResponse.class);
        for (ProcessedMsgResponse<WZCMHDF001DetermineInsurabilityResponse> processedMsgResponse : response.getMsgResponses()) {
            WZCMHDF001DetermineInsurabilityResponse businessResponse = processedMsgResponse.getBusinessResponse();
            if (expected.getMessageMetadata().getCareProviderReference().equals(businessResponse.getMessageMetadata().getCareProviderReference())) {
                XmlAsserter.assertSimilar(expected, businessResponse);
                return;
            }
        }
        failNoMessageResponse();
    }

    private static boolean matchesMetadata(MessageMetadataType expected,
                                           MessageMetadataType actual) {
        return StringUtils.equals(expected.getSSIN(), actual.getSSIN()) &&
                StringUtils.equals(expected.getEnterpriseNumber(), actual.getEnterpriseNumber()) &&
                StringUtils.equals(expected.getCareProviderReference(), actual.getCareProviderReference());
    }

    private static boolean matchesMetadata(be.vlaanderen.mercurius.mohm.common.v7.MessageMetadataType expected,
                                           be.vlaanderen.mercurius.mohm.common.v7.MessageMetadataType actual) {
        return StringUtils.equals(expected.getSSIN(), actual.getSSIN()) &&
                StringUtils.equals(expected.getEnterpriseNumber(), actual.getEnterpriseNumber()) &&
                StringUtils.equals(expected.getCareProviderReference(), actual.getCareProviderReference());
    }

    private static void failNoMessageResponse() {
        fail("No message reponse");
    }

    private static void confirmMsgResponses(ProcessedGetResponse processedGetResponse) throws ConnectorException {
        ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(processedGetResponse);
        assertNotNull(confirmResponse);
    }

    private static void assertTackRemoved(List<ProcessedTAckResponse> tAckResponses) {
        Assert.assertEquals("Tack should be removed", 0, tAckResponses.size());
    }

    private static void confirmTacks(ProcessedGetResponse processedGetResponse) throws ConnectorException {
        ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllTAcks(processedGetResponse);
        assertNotNull(confirmResponse);
    }

    private static void confirmTack(ProcessedTAckResponse processedTAckResponse) throws ConnectorException {
        ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmTAck(processedTAckResponse);
        assertNotNull(confirmResponse);
    }

    private static void waitForTack() throws InterruptedException {
        TimeUnit.SECONDS.sleep(SECONDS_WAITING);
    }

    private static InputReference generateInputReference() throws TechnicalConnectorException {
        return new InputReference();
    }

    private static void validateXadesTOfTAckResponseWithManifest(ProcessedPostResponse processedPostResponse, ProcessedGetResponse<byte[]> response) throws ConnectorException {
        SignatureVerificationResult signatureVerificationResult = VsbNetSessionServiceFactory.getVsbNetInvoiceService().validateXadesTWithManifest(response.getTAckResponses().get(0).getTAckResponse(), processedPostResponse.getPost().getDetail(), response.getTAckResponses().get(0).getTAckResponse().getXadesT().getValue());
        assertTrue(signatureVerificationResult.getErrors().isEmpty());
    }
}
