/*
 * Copyright (c) Smals
 */
package be.ehealth.businessconnector.test.ehbox.v3.builders.impl;

import be.ehealth.businessconnector.ehbox.v3.builders.impl.RequestBuilderImpl;
import be.ehealth.businessconnector.test.ehbox.v3.EhboxTestDataBuilder;
import be.ehealth.businessconnector.test.ehbox.v3.EhboxTestUtilities;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

import be.ehealth.businessconnector.ehbox.v3.builders.RequestBuilder;
import be.ehealth.technicalconnector.session.Session;
import be.ehealth.technicalconnector.utils.DateUtils;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.DeleteMessageRequest;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.DeleteOoORequest;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.GetAllEhboxesMessagesListRequest;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.GetBoxInfoRequest;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.GetMessageAcknowledgmentsStatusRequest;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.GetMessagesListRequest;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.GetOoOListRequest;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.InsertOoORequest;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.MoveMessageRequest;
import be.fgov.ehealth.technicalconnector.tests.session.SessionInitializer;


/**
 * tests the implementation class {@link RequestBuilderImpl}.
 * 
 * @author EHP
 * 
 */
public class RequestBuilderImplTest {

    private RequestBuilder requestBuilder = new RequestBuilderImpl();

    private static final String INBOX = "INBOX";

    private static final String BININBOX = "BININBOX";

    @BeforeClass
    public static void init() throws Exception {
        SessionInitializer.init("/be.ehealth.businessconnector.ehboxv3.test.properties", false);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        Session.getInstance().unloadSession();
    }


    /**
     * Test method for
     * {@link be.ehealth.businessconnector.ehbox.v3.builders.impl.RequestBuilderImpl#createGetMessagesListRequest(java.lang.String, int, int, be.fgov.ehealth.ehbox.core.v3.BoxIdType)}
     * .
     */
    @Test
    public void testCreateGetMessagesListRequest() throws Exception {
        GetMessagesListRequest request = requestBuilder.createGetMessagesListRequest(INBOX, 2, 89, EhboxTestDataBuilder.getRizivBoxUser1());
        EhboxTestUtilities.compareXmlWithExpectedFile("/examples/getMessagesListRequest.xml", request);
    }


    /**
     * Test method for
     * {@link be.ehealth.businessconnector.ehbox.v3.builders.impl.RequestBuilderImpl#createDeleteMessageRequest(java.lang.String, be.fgov.ehealth.ehbox.core.v3.BoxIdType, java.lang.String[])}
     * .
     */
    @Test
    public void testCreateDeleteMessageRequest() throws Exception {
        DeleteMessageRequest request = requestBuilder.createDeleteMessageRequest(INBOX, EhboxTestDataBuilder.getRizivBoxUser1(), "id1", "id2");
        EhboxTestUtilities.compareXmlWithExpectedFile("/examples/deleteMessageRequest.xml", request);
    }

    /**
     * Test method for {@link be.ehealth.businessconnector.ehbox.v3.builders.impl.RequestBuilderImpl#createBoxInfoRequestForDefaultBox()}.
     */
    @Test
    public void testCreateBoxInfoRequestWithBoxInfo() throws Exception {
        GetBoxInfoRequest request = requestBuilder.createBoxInfoRequest(EhboxTestDataBuilder.getRizivBoxUser1());
        EhboxTestUtilities.compareXmlWithExpectedFile("/examples/boxInfoRequestWithBoxInfo.xml", request);
    }

    /**
     * Test method for
     * {@link be.ehealth.businessconnector.ehbox.v3.builders.impl.RequestBuilderImpl#createBoxInfoRequest(be.fgov.ehealth.ehbox.core.v3.BoxIdType)}
     * .
     */
    @Test
    public void testCreateBoxInfoRequest() throws Exception {
        GetBoxInfoRequest request = requestBuilder.createBoxInfoRequestForDefaultBox();
        EhboxTestUtilities.compareXmlWithExpectedFile("/examples/boxInfoRequestDefaultBox.xml", request);
    }

    /**
     * Test method for
     * {@link be.ehealth.businessconnector.ehbox.v3.builders.impl.RequestBuilderImpl#createAllEhboxesMessagesListRequest(java.lang.String)}.
     */
    @Test
    public void testCreateAllEhboxesMessagesListRequest() throws Exception {
        GetAllEhboxesMessagesListRequest request = requestBuilder.createAllEhboxesMessagesListRequest(INBOX, 2, 20);
        EhboxTestUtilities.compareXmlWithExpectedFile("/examples/getAllEhboxesMessagesListRequest.xml", request);
    }

    /**
     * Test method for
     * {@link be.ehealth.businessconnector.ehbox.v3.builders.impl.RequestBuilderImpl#createMoveMessageRequest(java.lang.String, java.lang.String, java.lang.String[])}
     * .
     */
    @Test
    public void testCreateMoveMessageRequest() throws Exception {
        MoveMessageRequest request = requestBuilder.createMoveMessageRequest(INBOX, BININBOX, EhboxTestDataBuilder.getRizivBoxUser1(), "id1", "id2");
        EhboxTestUtilities.compareXmlWithExpectedFile("/examples/moveMessageRequest.xml", request);
    }


    /**
     * Test method for
     * {@link be.ehealth.businessconnector.ehbox.v3.builders.impl.RequestBuilderImpl#createGetMessageAcknowledgmentsStatusRequest(java.lang.String)}
     * .
     */
    @Test
    public void testCreateGetMessageAcknowledgmentsStatusRequest() throws Exception {
        GetMessageAcknowledgmentsStatusRequest request = requestBuilder.createGetMessageAcknowledgmentsStatusRequest("id1", 2, 45, EhboxTestDataBuilder.getRizivBoxUser1());
        EhboxTestUtilities.compareXmlWithExpectedFile("/examples/getAcknowledgementStatusRequest.xml", request);
    }

    /**
     * Test method for
     * {@link be.ehealth.businessconnector.ehbox.v3.builders.impl.RequestBuilderImpl#createDeleteOoORequest(java.lang.String[])}.
     */
    @Test
    public void testCreateDeleteOoORequest() throws Exception {
        DeleteOoORequest request = requestBuilder.createDeleteOoORequest(EhboxTestDataBuilder.getRizivBoxUser1(), "ooId1", "id2");
        EhboxTestUtilities.compareXmlWithExpectedFile("/examples/deleteOoORequest.xml", request);
    }

    /**
     * Test method for {@link be.ehealth.businessconnector.ehbox.v3.builders.impl.RequestBuilderImpl#createGetOoOListRequest()}.
     */
    @Test
    public void testCreateGetOoOListRequest() throws Exception {
        GetOoOListRequest request = requestBuilder.createGetOoOListRequest(EhboxTestDataBuilder.getRizivBoxUser1());
        EhboxTestUtilities.compareXmlWithExpectedFile("/examples/getOoOListRequest.xml", request);
    }

    /**
     * Test method for
     * {@link be.ehealth.businessconnector.ehbox.v3.builders.impl.RequestBuilderImpl#createInsertOoORequest(org.joda.time.DateTime, org.joda.time.DateTime, be.fgov.ehealth.ehbox.core.v3.BoxIdType[])}
     * .
     */
    @Test
    public void testCreateInsertOoORequest() throws Exception {
        InsertOoORequest request = requestBuilder.createInsertOoORequest(EhboxTestDataBuilder.getRizivBoxUser1(), DateUtils.parseDate("2004-01-22+01:00"), DateUtils.parseDate("2004-02-22+01:00"), EhboxTestDataBuilder.getInssBoxIdUser3(), EhboxTestDataBuilder.getInssBoxIdUser2());
        EhboxTestUtilities.compareXmlWithExpectedFile("/examples/insertOoORequest.xml", request);
    }


}
