﻿/*
 * Copyright (c) eHealth
 */
using System;

using be.ehealth.technicalconnector.enumeration;
using be.ehealth.technicalconnector.idgenerator;
using ikvm.extensions;
using javax.xml.ws.soap;
using NUnit.Framework;
using be.fgov.ehealth.technicalconnector.tests.session;
using be.ehealth.technicalconnector.exception;
using be.ehealth.technicalconnector.session;
using java.io;
using java.util;
using be.cin.mycarenet.esb.common.v2;
using be.cin.nip.async.generic;
using be.ehealth.business.mycarenetdomaincommons.builders;
using be.ehealth.business.mycarenetdomaincommons.domain;
using be.ehealth.businessconnector.genericasync.builders;
using be.ehealth.businessconnector.genericasync.domain;
using be.ehealth.businessconnector.vsbnet.async.session;
using be.ehealth.technicalconnector.utils;
using be.ehealth.technicalconnector.config.util.domain;
using be.ehealth.technicalconnector.config.util;
using be.ehealth.businessconnector.genericasync.mappers;
using be.fgov.ehealth.businessconnector.tests.utils;
using be.fgov.ehealth.technicalconnector.tests.utils;
using be.vlaanderen.mercurius.mohm.schemas.v1;
using be.vlaanderen.mercurius.insurability.schemas.v1;
using be.cin.encrypted;
using java.util.concurrent;
using be.fgov.ehealth.technicalconnector.signature.domain;

namespace be.ehealth.businessconnector.vsbnet.session
{
	[TestFixture]
	public class VsbNetPostGenericAsyncIntegrationTest
	{
		private static String REQUEST_FOLDER = ".\\examples\\vsbnet\\async\\request\\";
		
		[SetUp]
		public static void setup() {
			SessionInitializer.init("be.ehealth.businessconnector.vsbnet.test.properties",true,SupportedLanguages.NET.getAbbreviation());
		}
		
		[Test]
		public void _010_createApplication_TC_APP1() {
			VsbNetGenericAsyncMethod.do_POST_CreateApplication(REQUEST_FOLDER + "EMOHMDF101CreateApplicationRequest_TC_APP1.xml");
		}

		[Test]
		public void _020_createApplication_TC_APP2() {
			VsbNetGenericAsyncMethod.do_POST_CreateApplication(REQUEST_FOLDER + "EMOHMDF101CreateApplicationRequest_TC_APP2.xml");
		}

		[Test]
		public void _030_createApplication_TC_APP3() {
			VsbNetGenericAsyncMethod.do_POST_CreateApplication(REQUEST_FOLDER + "EMOHMDF101CreateApplicationRequest_TC_APP3.xml");
		}

		[Test]
		public void _040_createApplication_TC_APP4() {
			VsbNetGenericAsyncMethod.do_POST_CreateApplication(REQUEST_FOLDER + "EMOHMDF101CreateApplicationRequest_TC_APP4.xml");
		}

		[Test]
		public void _050_createApplication_TC_APP5() {
			VsbNetGenericAsyncMethod.do_POST_CreateApplication(REQUEST_FOLDER + "EMOHMDF101CreateApplicationRequest_TC_APP5.xml");
		}

		[Test]
		public void _060_createApplication_TC_APP6() {
			VsbNetGenericAsyncMethod.do_POST_CreateApplication(REQUEST_FOLDER + "EMOHMDF101CreateApplicationRequest_TC_APP6.xml");
		}

		[Test]
		public void _070_consultApplication_TC_CAPP1() {
			VsbNetGenericAsyncMethod.do_POST_ConsultApplication(REQUEST_FOLDER + "EMOHMDF103ConsultApplicationRequest_TC_CAPP1.xml");
		}

		[Test]
		public void _080_consultApplication_TC_CAPP2() {
			VsbNetGenericAsyncMethod.do_POST_ConsultApplication(REQUEST_FOLDER + "EMOHMDF103ConsultApplicationRequest_TC_CAPP2.xml");
		}

		[Test]
		public void _120_reportDelivery_TC_DEL1() {
			VsbNetGenericAsyncMethod.do_POST_ReportDelivery(REQUEST_FOLDER + "EMOHMDF105ReportDeliveryRequest_TC_DEL1.xml");
		}

		[Test]
		public void _140_reportDelivery_TC_DEL2() {
			VsbNetGenericAsyncMethod.do_POST_ReportDelivery(REQUEST_FOLDER + "EMOHMDF105ReportDeliveryRequest_TC_DEL2.xml");
		}

		[Test]
		public void _170_reportDelivery_TC_DEL3() {
			VsbNetGenericAsyncMethod.do_POST_ReportDelivery(REQUEST_FOLDER + "EMOHMDF105ReportDeliveryRequest_TC_DEL3.xml");
		}

		[Test]
		public void _180_reportDelivery_TC_DEL4() {
			VsbNetGenericAsyncMethod.do_POST_ReportDelivery(REQUEST_FOLDER + "EMOHMDF105ReportDeliveryRequest_TC_DEL4.xml");
		}

		[Test]
		public void _200_consultSupportAndRepair_TC_CSUP1() {
			VsbNetGenericAsyncMethod.do_POST_ConsultSupportAndRepair(REQUEST_FOLDER + "EMOHMDF104ConsultSupportAndRepairRequest_TC_CSUP1.xml");
		}

		[Test]
		public void _210_consultSupportAndRepair_TC_CSUP2() {
			VsbNetGenericAsyncMethod.do_POST_ConsultSupportAndRepair(REQUEST_FOLDER + "EMOHMDF104ConsultSupportAndRepairRequest_TC_CSUP2.xml");
		}

		[Test]
		public void _211_consultSupportAndRepairList_1() {
			VsbNetGenericAsyncMethod.do_POST_ConsultSupportAndRepairList(REQUEST_FOLDER + "EMOHMDF112ConsultSupportAndRepairRequestList_1.xml");
		}
		[Test]
		public void _211_consultSupportAndRepairList_2() {
			VsbNetGenericAsyncMethod.do_POST_ConsultSupportAndRepairList(REQUEST_FOLDER + "EMOHMDF112ConsultSupportAndRepairRequestList_2.xml");
		}
		[Test]
		public void _211_consultSupportAndRepairList_3() {
			VsbNetGenericAsyncMethod.do_POST_ConsultSupportAndRepairList(REQUEST_FOLDER + "EMOHMDF112ConsultSupportAndRepairRequestList_3.xml");
		}
		[Test]
		public void _211_consultSupportAndRepairList_4() {
			VsbNetGenericAsyncMethod.do_POST_ConsultSupportAndRepairList(REQUEST_FOLDER + "EMOHMDF112ConsultSupportAndRepairRequestList_4.xml");
		}

		[Test]
		[Ignore]
		public void _220_createFictionalApplicationRequest_TC_FAPP1() {
			VsbNetGenericAsyncMethod.do_POST_CreateFictionalApplication(REQUEST_FOLDER + "EMOHMDF102CreateFictionalApplicationRequest_TC_FAPP1.xml");
		}
		
		[Test]
		[Ignore]
		public void _230_createFictionalApplicationRequest_TC_FAPP2() {
			VsbNetGenericAsyncMethod.do_POST_CreateFictionalApplication(REQUEST_FOLDER + "EMOHMDF102CreateFictionalApplicationRequest_TC_FAPP2.xml");
		}

		[Test]
		[Ignore]
		public void _240_createFictionalApplicationRequest_TC_FAPP3() {
			VsbNetGenericAsyncMethod.do_POST_CreateFictionalApplication(REQUEST_FOLDER + "EMOHMDF102CreateFictionalApplicationRequest_TC_FAPP3.xml");
		}

		[Test]
		[Ignore]
		public void _250_createFictionalApplicationRequest_TC_FAPP4() {
			VsbNetGenericAsyncMethod.do_POST_CreateFictionalApplication(REQUEST_FOLDER + "EMOHMDF102CreateFictionalApplicationRequest_TC_FAPP4.xml");
		}
		
		[Test]
		public void _270_postInvoiceList_TC01() {
			VsbNetGenericAsyncMethod.do_POST_RefusedInvoice(REQUEST_FOLDER + "920000_TC01.txt");
		}

		[Test]
		public void _280_postInvoiceList_TC02() {
			VsbNetGenericAsyncMethod.do_POST_AcceptedInvoice(REQUEST_FOLDER + "920000_TC02.txt");
		}

		[Test]
		public void _310_determineInsurability_TC01() {
			VsbNetGenericAsyncMethod.do_POST_DetermineInsurability(REQUEST_FOLDER + "WZCMHDF001DetermineInsurabilityRequest_TC_1.xml");
		}

		[Test]
		public void _330_determineInsurability_TC03() {
			VsbNetGenericAsyncMethod.do_POST_DetermineInsurability(REQUEST_FOLDER + "WZCMHDF001DetermineInsurabilityRequest_TC_3.xml");
		}

		[Test]
		public void _340_determineInsurability_TC04() {
			VsbNetGenericAsyncMethod.do_POST_DetermineInsurability(REQUEST_FOLDER + "WZCMHDF001DetermineInsurabilityRequest_TC_4.xml");
		}
	}
}
