using be.ehealth.business.mycarenetdomaincommons.domain;
using be.ehealth.businessconnector.mycarenet.memberdata.builders;
using be.ehealth.businessconnector.mycarenet.memberdata.builders.impl;
using be.ehealth.businessconnector.mycarenet.memberdatacommons.builders;
using be.ehealth.businessconnector.mycarenet.memberdatacommons.builders.impl;
using be.ehealth.businessconnector.mycarenet.memberdata.domain;
using be.ehealth.businessconnector.mycarenet.memberdata.session;
using be.ehealth.businessconnector.test.testcommons.utils;
using be.ehealth.technicalconnector.config;
using be.ehealth.technicalconnector.idgenerator;
using be.ehealth.technicalconnector.session;
using be.ehealth.technicalconnector.utils;
using be.fgov.ehealth.mycarenet.memberdata.protocol.v1;
using be.fgov.ehealth.technicalconnector.signature.domain;
using be.fgov.ehealth.technicalconnector.tests.session;
using be.fgov.ehealth.businessconnector.tests.utils;
using be.fgov.ehealth.technicalconnector.tests.utils;
using java.lang;
using java.util;
using NUnit.Framework;
using oasis.names.tc.saml._2_0.protocol;
using org.apache.commons.io;
using org.omg.CORBA_2_3.portable;

namespace be.ehealth.businessconnector.memberdata.session
{

	[TestFixture]
	public class MemberDataPhysicianIntegrationTest {

		private static string REQ_LOCATION = ".\\scenarios\\requests\\AttributeQuery-physician.xml";

		private static string FIRST_PART_RESP_LOCATION = ".\\scenarios\\response\\physician\\Response-physician-";

		private string response_location;

		[SetUp]
		public void init() {
			SessionInitializer.init(".\\be.ehealth.businessconnector.mycarenet.memberdata.test.properties", SupportedLanguages.NET.getAbbreviation());
		}

		static object[] testCase =
		{
			//OA600
			new string[]{"OA600", "67120143655"},
			new string[]{"OA600", "70021546287"},
			new string[]{"OA600", "23102820194"},
			new string[]{"OA600", "02091046548"},
			new string[]{"OA600", "82101921636"},
			new string[]{"OA600", "45011112215"},
			new string[]{"OA600", "27121516833"},
			new string[]{"OA600", "45112243029"},
			new string[]{"OA600", "42030833933"},
			new string[]{"OA600", "47100111242"},
			
			//OA 900
			new string[]{"OA900", "57012803538"},
			new string[]{"OA900", "82062220229"},
			new string[]{"OA900", "45072705334"},
			new string[]{"OA900", "60122945519"},
			new string[]{"OA900", "99091447286"},
			new string[]{"OA900", "59082410780"},
			new string[]{"OA900", "25111903990"},
			new string[]{"OA900", "39010315202"},
			new string[]{"OA900", "30010705878"},
			new string[]{"OA900", "29021203633"}
			
		};


		[Test, TestCaseSource("testCase")]
		public void consultationAttrQueryWithoutEncryption(string oa, string patientNiss) {
			response_location = FIRST_PART_RESP_LOCATION + oa + "-" + patientNiss + ".xml";
			consultationTest(REQ_LOCATION, response_location, patientNiss, false);
		}

		[Test, TestCaseSource("testCase")]
		public void consultationAttrQueryWithEncryption(string oa, string patientNiss) {
			response_location = FIRST_PART_RESP_LOCATION + oa + "-" + patientNiss + ".xml";
			consultationTest(REQ_LOCATION, response_location, patientNiss, true);
		}
		
		public void consultationTest(string attrQueryLocation, string responseLocation, string patientNiss, bool encrypted) {
			Map testFileParams = new HashMap();
			string id = IdGeneratorFactory.getIdGenerator("uuid").generateId();
			testFileParams.put("id", id);
			testFileParams.put("nihii", SessionUtil.getNihii11());
			testFileParams.put("niss", patientNiss);

			AttributeQuery attributeQuery = (AttributeQuery) FileTestUtils.toObject(testFileParams, attrQueryLocation, typeof(AttributeQuery));

			ConnectorXmlUtils.dump(attributeQuery);

			// input reference and AttributeQuery ID must match
			InputReference inputReference = new InputReference(id);
			
			RequestObjectBuilder testBuilder;
			if (encrypted == true) {
				testBuilder = new EncryptedRequestObjectBuilderImpl();
			} else {
				testBuilder = new NotEncryptedRequestObjectBuilderImpl();
			}
			
			MemberDataConsultationRequest memberDataRequest = testBuilder.buildConsultationRequest(true, inputReference, attributeQuery);

			MemberDataService service = MemberDataSessionServiceFactory.getMemberDataSyncService();
			MemberDataConsultationResponse memberDataResponse = service.consultMemberData(memberDataRequest);
			ResponseObjectBuilder responseBuilder = ResponseObjectBuilderFactory.getResponseObjectBuilder();
			MemberDataBuilderResponse response = responseBuilder.handleConsultationResponse(memberDataResponse);

			ConnectorXmlUtils.dump(response.getResponse());

			Assert.AreEqual("urn:oasis:names:tc:SAML:2.0:status:Success", response.getResponse().getStatus().getStatusCode().getValue(),"Status is not success");
			Map signVerifResult = response.getSignatureVerificationResult();
			Iterator it = signVerifResult.keySet().iterator();
			while (it.hasNext()) {
				string key = (string) it.next();
				Assert.IsTrue(((SignatureVerificationResult)signVerifResult.get(key)).isValid(),
				             "Errors found in the signature verification");
			}

			java.io.InputStream inpstr = ConnectorIOUtils.getResourceAsStream(responseLocation);
			string expectedresponse = ConnectorIOUtils.convertStreamToString(inpstr);
			IOUtils.closeQuietly(inpstr);

			be.fgov.ehealth.businessconnector.tests.utils.XmlAsserter.assertSimilar(expectedresponse, ConnectorXmlUtils.toString(response.getResponse()));
		}
	}
}