﻿/*
 * Copyright (c) eHealth
 */
using System;
using be.ehealth.technicalconnector.idgenerator;
using be.fgov.ehealth.commons.core.v2;
using ikvm.extensions;
using javax.xml.ws.soap;
using NUnit.Framework;
using java.io;
using java.util;
using java.lang;
using org.joda.time;
using org.slf4j;
using be.ehealth.technicalconnector.exception;
using be.ehealth.technicalconnector.session;
using be.ehealth.technicalconnector.utils;
using be.fgov.ehealth.samcivics.schemas.v2;
using be.fgov.ehealth.technicalconnector.tests.session;
using be.fgov.ehealth.businessconnector.tests.utils;
using be.fgov.ehealth.technicalconnector.tests.utils;

namespace be.ehealth.businessconnector.civicsv2.session
{
	/*
	 * CIVICS Service Integration Tests This test shows the use of the CIVICS Service through the use of the Business Connector.
	 * 
	 * All Tests require the following pre-requisites to be met: - An active and valid eHealth-platform session (initiated via the Session
	 * Management component), in these tests this is done in the AbstractServiceTest class
	 */
	[TestFixture]
	public class CivicsSessionServiceIntegrationTest
	{
		private static CivicsSessionService service;
		
		[SetUp]
		public static void init() {
			SessionInitializer.init(".\\be.ehealth.businessconnector.civicsv2.test.properties", SupportedLanguages.NET.getAbbreviation());
			service = CivicsSessionServiceFactory.getCivicsSession();
		}

		private T transformLocationToObject<T>(string location) {
			InputStream inputStream = ConnectorIOUtils.getResourceAsStream(location);
			return (T) ConnectorXmlUtils.toObject(inputStream, typeof(T));
		}
		
		
		[TearDown]
		public static void teardownSession()  {
			Session.getInstance().unloadSession();
		}

		[Test]
		[ExpectedExceptionAttribute ("javax.xml.ws.soap.SOAPFaultException")]
		public void findCNKTestXmlNoDataFound(){
			findCNKTest(".\\examples\\FindCNK-NoDataFound.xml");
		}

		[Test]
		public void findCNKTestXml(){
			FindCNKResponse response = findCNKTest(".\\examples\\FindCNK.xml");
			Assert.IsTrue(response.getProducts().size() >= 1, "No products found");
		}

		private FindCNKResponse findCNKTest(string location){
			FindCNKRequest request = transformLocationToObject<FindCNKRequest>(location);
			return service.findCNK(request);
		}

		[Test]
		[ExpectedExceptionAttribute ("javax.xml.ws.soap.SOAPFaultException")]
		public void findParagraphXmlNoDataFound(){
			findParagraphClassification(".\\examples\\FindParagraph-NoDataFound.xml");
		}

		[Test]
		public void findParagraphXml(){
			FindParagraphResponse response = findParagraphClassification(".\\examples\\FindParagraph.xml");
			Assert.IsTrue(response.getFindParagraphs().size() >= 1, "No paragraphs found");
		}

		private FindParagraphResponse findParagraphClassification(string location){
			FindParagraphRequest request = transformLocationToObject<FindParagraphRequest>(location);
			return service.findParagraph(request);
		}

		[Test]
		[ExpectedExceptionAttribute ("javax.xml.ws.soap.SOAPFaultException")]
		public void findParagraphTextXmlNoDataFound(){
			findParagraphText(".\\examples\\FindParagraphText-NoDataFound.xml");
		}

		[Test]
		public void findParagraphTextXml(){
			FindParagraphTextResponse response = findParagraphText(".\\examples\\FindParagraphText.xml");
			Assert.IsNotNull(response.getParagraph(), "No paragraph text found");
		}

		private FindParagraphTextResponse findParagraphText(string location){
			FindParagraphTextRequest request = transformLocationToObject<FindParagraphTextRequest>(location);
			return service.findParagraphText(request);
		}

		[Test]
		[ExpectedExceptionAttribute ("javax.xml.ws.soap.SOAPFaultException")]
		public void findPublicCNKXmlNoDataFound(){
			findPublicCNK(".\\examples\\FindPublicCNK-NoDataFound.xml");
		}

		[Test]
		public void findPublicCNKXml(){
			FindPublicCNKResponse response = findPublicCNK(".\\examples\\FindPublicCNK.xml");
			Assert.IsTrue(response.getAmpps().size() >= 1,"No ampps found");
		}

		private FindPublicCNKResponse findPublicCNK(string location){
			FindPublicCNKRequest request = transformLocationToObject<FindPublicCNKRequest>(location);
			return service.findPublicCNK(request);
		}

		[Test]
		[ExpectedExceptionAttribute ("javax.xml.ws.soap.SOAPFaultException")]
		public void findReimbursementConditionsXmlNoDataFound(){
			findReimbursementConditions(".\\examples\\FindReimboursementConditions-NoDataFound.xml");
		}

		[Test]
		public void findReimbursementConditionsXml(){
			FindReimbursementConditionsResponse response = findReimbursementConditions(".\\examples\\FindReimboursementConditions.xml");
			Assert.IsTrue(response.getParagraphAndTherapies().size() >= 1,"No paragraph and therapies found");
		}

		private FindReimbursementConditionsResponse findReimbursementConditions(string location){
			FindReimbursementConditionsRequest request = transformLocationToObject<FindReimbursementConditionsRequest>(location);
			return service.findReimbursementConditions(request);
		}

		[Test]
		[ExpectedExceptionAttribute ("javax.xml.ws.soap.SOAPFaultException")]
		public void getAddedDocumentsXmlNoDataFound(){
			getAddedDocuments(".\\examples\\GetAddedDocuments-NoDataFound.xml");
		}

		[Test]
		public void getAddedDocumentsXml(){
			GetAddedDocumentsResponse response = getAddedDocuments(".\\examples\\GetAddedDocuments.xml");
			Assert.IsTrue(response.getAddedDocuments().size() >= 1, "No added documents found");
		}

		private GetAddedDocumentsResponse getAddedDocuments(string location){
			GetAddedDocumentsRequest request = transformLocationToObject<GetAddedDocumentsRequest>(location);
			return service.getAddedDocuments(request);
		}

		[Test]
		[ExpectedExceptionAttribute ("javax.xml.ws.soap.SOAPFaultException")]
		public void getParagraphExclusionXmlNoDataFound(){
			getParagraphExclusion(".\\examples\\GetParagraphExclusion-NoDataFound.xml");
		}

		[Test]
		public void getParagraphExclusionXml(){
			GetParagraphExclusionsResponse response = getParagraphExclusion(".\\examples\\GetParagraphExclusion.xml");
			Assert.IsTrue(response.getExcludedParagraphs().size() >= 1, "No excluded paragraphs found");
		}

		private GetParagraphExclusionsResponse getParagraphExclusion(string location){
			GetParagraphExclusionsRequest request = transformLocationToObject<GetParagraphExclusionsRequest>(location);
			return service.getParagraphExclusions(request);
		}

		[Test]
		[ExpectedExceptionAttribute ("javax.xml.ws.soap.SOAPFaultException")]
		public void getParagraphIncludedSpecialitiesXmlNoDataFound(){
			getParagraphIncludedSpecialities(".\\examples\\GetParagraphIncludedSpecialties-NoDataFound.xml");
		}

		[Test]
		public void getParagraphIncludedSpecialitiesXml(){
			GetParagraphIncludedSpecialtiesResponse response = getParagraphIncludedSpecialities(".\\examples\\GetParagraphIncludedSpecialties.xml");
			Assert.IsTrue(response.getAtmAndChildrens().size() >= 1, "No atm and childrens found");
		}

		private GetParagraphIncludedSpecialtiesResponse getParagraphIncludedSpecialities(string location){
			GetParagraphIncludedSpecialtiesRequest request = transformLocationToObject<GetParagraphIncludedSpecialtiesRequest>(location);
			return CivicsSessionServiceFactory.getCivicsSession().getParagraphIncludedSpecialities(request);
		}

		[Test]
		[ExpectedExceptionAttribute ("javax.xml.ws.soap.SOAPFaultException")]
		public void getProfessionalAuthorizationsXmlNoDataFound(){
			getProfessionalAuthorizations(".\\examples\\GetProfessionalAuthorizations-NoDataFound.xml");
		}

		[Test]
		public void getProfessionalAuthorizationsXml(){
			GetProfessionalAuthorizationsResponse response = getProfessionalAuthorizations(".\\examples\\GetProfessionalAuthorizations.xml");
			Assert.IsTrue(response.getProfessionalAuthorizations().size() >= 1, "No professional authorizations found");
		}

		private GetProfessionalAuthorizationsResponse getProfessionalAuthorizations(string location){
			GetProfessionalAuthorizationsRequest request = transformLocationToObject<GetProfessionalAuthorizationsRequest>(location);
			return CivicsSessionServiceFactory.getCivicsSession().getProfessionalAuthorizations(request);
		}
	}
}
