package be.ehealth.businessconnector.test.vsbnet.async.session;

import org.junit.FixMethodOrder;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.MethodSorters;

import be.fgov.ehealth.technicalconnector.tests.junit.rule.SessionRule;


/**
 * @author EHP
 */
@FixMethodOrder(MethodSorters.NAME_ASCENDING)
public class VsbNet_eMOHDF106_V4_IntegrationTest {

    private static final String FILES_FOLDER = "/examples/vsbnet/async/eHMOHDF106_V4/";

    @Rule
    public SessionRule rule = SessionRule.withActiveSession().baseOn("/be.ehealth.businessconnector.vsbnet.test.properties").build();
    
    // Prerequisites :
    // 1 - Execute EMOHDF101(CreateApplication) 5_5a and 5_5b test and then 5_1a and 5_1b
    // 2 - Get the VSBReference returned in the CreateApplication 5_5b and adapt the xml files of the PushDecision 5_1
    // 2 - Get the VSBReference returned in CreateApplication 5_1b and adapt the xml files of the PushDecision 5_3
    // 3 - Ask a validation of the vsb reference of CreateApplication 5_5b
    
    @Test
    public void test_5_1_GET_getPushDecision() throws Exception {
        VsbNetGenericAsyncMethod.do_GET_PushDecisionV4(FILES_FOLDER + "vsb-mohm_DF106_5-1_TC_PDES1_testlink_eWZC-3036_request.xml", false);
    }

    @Test
    public void test_5_3_GET_getPushDecision() throws Exception {
        VsbNetGenericAsyncMethod.do_GET_PushDecisionV4(FILES_FOLDER + "vsb-mohm_DF106_5-3_TC_PDES3_testlink_eWZC-3038_request.xml", false);
    }
}
