/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.matchers.BodyMatcher;
import org.mockserver.matchers.StringToXmlDocumentParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XPathStringMatcher
extends BodyMatcher<String> {
    private static Logger logger = LoggerFactory.getLogger(XPathStringMatcher.class);
    private final String matcher;
    private final StringToXmlDocumentParser stringToXmlDocumentParser = new StringToXmlDocumentParser();
    private XPathExpression xpathExpression = null;

    public XPathStringMatcher(String matcher) {
        this.matcher = matcher;
        if (StringUtils.isNotEmpty((CharSequence)matcher)) {
            try {
                this.xpathExpression = XPathFactory.newInstance().newXPath().compile(matcher);
            }
            catch (XPathExpressionException e) {
                logger.trace("Error while creating xpath expression for [" + matcher + "] assuming matcher not xpath - " + e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public boolean matches(String matched) {
        boolean result = false;
        if (this.xpathExpression == null) {
            logger.warn("Attempting match against null XPath Expression for [" + matched + "]" + new RuntimeException("Attempting match against null XPath Expression for [" + matched + "]"));
        } else if (this.matcher.equals(matched)) {
            result = true;
        } else if (matched != null) {
            try {
                result = (Boolean)this.xpathExpression.evaluate(this.stringToXmlDocumentParser.buildDocument(matched, new StringToXmlDocumentParser.ErrorLogger(){

                    @Override
                    public void logError(String matched, Exception exception) {
                        logger.debug("SAXParseException while performing match between [" + XPathStringMatcher.this.matcher + "] and [" + matched + "]", (Throwable)exception);
                    }
                }), XPathConstants.BOOLEAN);
            }
            catch (Exception e) {
                logger.trace("Error while matching xpath [" + this.matcher + "] against string [" + matched + "] assuming no match - " + e.getMessage());
            }
        }
        if (!result) {
            logger.trace("Failed to match [{}] with [{}]", (Object)matched, (Object)this.matcher);
        }
        return this.reverseResultIfNot(result);
    }

    @Override
    public String[] fieldsExcludedFromEqualsAndHashCode() {
        return new String[]{"logger", "xpathExpression"};
    }
}

