/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.test.wsconsent.builders;

import java.util.List;

import be.ehealth.businessconnector.wsconsent.builders.HcPartyInfoBuilder;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

import be.ehealth.businessconnector.wsconsent.builders.impl.DelegatingHcPartyInfoBuilderImpl;
import be.ehealth.technicalconnector.session.Session;
import be.fgov.ehealth.standards.kmehr.schema.v1.HcpartyType;
import be.fgov.ehealth.technicalconnector.tests.session.SessionInitializer;
import be.fgov.ehealth.technicalconnector.tests.utils.TestPropertiesLoader;


/**
 * HcPartyInfoBuilderImplTest test class.
 * 
 * @author EHP
 * 
 * 
 * 
 */
public class DelegatingHcPartyInfoBuilderImplTest {

    @BeforeClass
    public static void init() throws Exception {
        // only integration tests need to run for all professionTypes
        Assume.assumeTrue("persphysician".equals(TestPropertiesLoader.getProperties("/be.ehealth.businessconnector.wsconsent.test.properties").getProperty("session.professionType")));
        SessionInitializer.init("/be.ehealth.businessconnector.wsconsent.test.properties", false);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        Session.getInstance().unloadSession();
    }

    private HcPartyInfoBuilder builder = new DelegatingHcPartyInfoBuilderImpl();

    @Test
    public void testCreateProfessionalParty() throws Exception {
        List<HcpartyType> actual = builder.getHcpPartiesForAuthor();

        Assert.assertNotNull("Null object", actual);
        Assert.assertTrue("Wrong expected Size ", actual.size() > 0);

    }


}
