/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.test.chapterIV.integration;

import be.ehealth.business.test.kmehrcommons.helper.ErrorTypeManagement;
import be.ehealth.businessconnector.chapterIV.builders.BuilderFactory;
import be.ehealth.businessconnector.chapterIV.builders.ConsultationBuilder;
import be.ehealth.businessconnector.chapterIV.domain.ChapterIVBuilderResponse;
import be.ehealth.businessconnector.chapterIV.domain.ChapterIVKmehrResponseWithTimeStampInfo;
import be.ehealth.businessconnector.chapterIV.domain.ChapterIVReferences;
import be.ehealth.businessconnector.chapterIV.session.ChapterIVService;
import be.ehealth.businessconnector.chapterIV.session.ChapterIVSessionServiceFactory;
import be.ehealth.businessconnector.test.chapterIV.testutil.TestUtils;
import be.fgov.ehealth.chap4.protocol.v1.ConsultChap4MedicalAdvisorAgreementResponse;
import be.fgov.ehealth.medicalagreement.core.v1.Kmehrresponse;
import be.fgov.ehealth.standards.kmehr.schema.v1.ErrorType;
import be.fgov.ehealth.standards.kmehr.schema.v1.FolderType;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Ignore;
import org.junit.Test;

import java.io.InputStream;
import java.util.List;
import java.util.UUID;

import static be.ehealth.technicalconnector.utils.ConnectorIOUtils.closeQuietly;
import static be.ehealth.technicalconnector.utils.ConnectorIOUtils.getResourceAsStream;


/**
 * Integration test for ChapterIV business connector
 *
 * @author EHP
 */
public class ChapterIVConsultationIntegrationTest extends AbstractChapterIVTestBase {

    @Test
    public void testOA100AsDoctor() throws Exception {
        Assume.assumeTrue(isDoctor());
        invoke("/examples/persphysician-chapter4-consultation-request-with-ssin.oa100.xml", "86081523513");
    }

    @Test
    @Ignore("this operation is not supported by backend at the moment")
    public void testConsultationValidRequestOA100NoNissNumberNotKnown() throws Exception {
        Assume.assumeTrue(isDoctor());
        invoke("/examples/persphysician-chapter4-consultation-request-without-ssin.xml", null);
    }


    @Test
    public void testOA500AsDoctor() throws Exception {
        Assume.assumeTrue(isDoctor());
        invoke("/examples/persphysician-chapter4-consultation-request-with-ssin.oa500.xml", "86081523513");
    }

    @Test
    public void testOA500AsOrgpharmacy() throws Exception {
        Assume.assumeTrue(isPharmacy());
        invoke("/examples/orgpharmacy-chapter4-consultation-request-with-ssin.xml", "76011402195");
    }

    @Test
    public void testOA100AsOrgpharmacy() throws Exception {
        Assume.assumeTrue(isPharmacy());
        invoke("/examples/orgpharmacy-chapter4-consultation-request-with-ssin.xml", "81032034303", "2686392", "2014-03-01");
    }


    private void invoke(String location, String patientInss) throws Exception {
        invoke(location, patientInss, null, null);
    }

    private void invoke(String location, String patientInss, String cnkValue, String cnkSV) throws Exception {
        InputStream is = null;
        try {
            is = getResourceAsStream(location);
            ChapterIVService service = ChapterIVSessionServiceFactory.getChapterIVService();

            FolderType folder = parseFolderType(is);
            TestUtils.updateAuthor(folder);
            TestUtils.updateTransactionDate(folder, new DateTime());
            TestUtils.updatePatient(folder, patientInss);
            TestUtils.updateCNK(folder, cnkSV, cnkValue);
            TestUtils.updateReference(folder, UUID.randomUUID().toString());


            ConsultationBuilder builder = BuilderFactory.getBuilderFactoryForSession().getConsultationBuilder();
            ChapterIVBuilderResponse builderResponse = builder.build(folder, true, new ChapterIVReferences(true), TestUtils.extractDate(folder));

            ConsultChap4MedicalAdvisorAgreementResponse response = service.consultChap4MedicalAdvisorAgreement(builderResponse.getConsultChap4MedicalAdvisorAgreementRequest());

            ChapterIVKmehrResponseWithTimeStampInfo retrievedKmehrResponse = getResponseBuilder().validateTimestampAndretrieveChapterIVKmehrResponseWithTimeStampInfo(response);

            Assert.assertNotNull(retrievedKmehrResponse);
            Kmehrresponse kmehrresponse = retrievedKmehrResponse.getKmehrresponse();
            Assert.assertNotNull(kmehrresponse);
            Assert.assertNotNull(kmehrresponse.getRequest());
            Assert.assertNotNull(kmehrresponse.getRequest().getKmehrmessage());
            Assert.assertNotNull(retrievedKmehrResponse.getTimeStampToken());
            Assert.assertNotNull(retrievedKmehrResponse.getKmehrResponseBytes());
            Assert.assertNotNull(retrievedKmehrResponse.getTimeStampBytes());
            List<ErrorType> errors = kmehrresponse.getAcknowledge().getErrors();
            Assert.assertTrue(ErrorTypeManagement.printErrors(errors), errors.isEmpty());

        } catch (Exception e) {
            process("consult", e);
        } finally {
            closeQuietly(is);
        }
    }


}
