/*
 * Copyright (c) eHealth
 */
using System;
using ikvm.extensions;
using NUnit.Framework;
using java.io;
using java.util;
using org.joda.time;
using be.ehealth.technicalconnector.utils;
using be.fgov.ehealth.mediprima.core.v1;
using be.fgov.ehealth.mediprima.protocol.v1;
using be.ehealth.technicalconnector.idgenerator;

namespace be.ehealth.businessconnector.mediprima.builder
{
    public class ConsultCarmedInterventionRequestBuilder {
        private ConsultCarmedInterventionRequest consultCarmedInterventionRequest;
        private BySsinType bySsinType ;
        private be.fgov.ehealth.mediprima.core.v1.PeriodType periodType ;
        
        public static ConsultCarmedInterventionRequestBuilder aRequest() {
            return new ConsultCarmedInterventionRequestBuilder();
        }

        public ConsultCarmedInterventionRequestBuilder() {
            consultCarmedInterventionRequest = new ConsultCarmedInterventionRequest();
            String requestId = IdGeneratorFactory.getIdGenerator(IdGeneratorFactory.XSID).generateId();
            consultCarmedInterventionRequest.setId(requestId);
            consultCarmedInterventionRequest.setIssueInstant(new org.joda.time.DateTime());
            ConsultCarmedDataType consultCarmedDataType = new ConsultCarmedDataType();
            bySsinType = new BySsinType();
            consultCarmedDataType.setBySsin(bySsinType);
            consultCarmedInterventionRequest.setSelectionCriteria(consultCarmedDataType);
        }

        public ConsultCarmedInterventionRequestBuilder withSsin(String ssin) {
            bySsinType.setSsin(ssin);
            return this;
        }

        public ConsultCarmedInterventionRequestBuilder withReferenceDate(org.joda.time.DateTime referenceDate) {
            bySsinType.setReferenceDate(referenceDate);
            return this;
        }

        public ConsultCarmedInterventionRequestBuilder withPeriod() {
            periodType = new be.fgov.ehealth.mediprima.core.v1.PeriodType();
            bySsinType.setPeriod(periodType);
            periodType.setStartDate(new org.joda.time.DateTime());
            periodType.setEndDate(new org.joda.time.DateTime());
            return this;
        }

        public ConsultCarmedInterventionRequestBuilder withStartPeriod(org.joda.time.DateTime startPeriod) {
            periodType = new be.fgov.ehealth.mediprima.core.v1.PeriodType();
            bySsinType.setPeriod(periodType);
            periodType.setStartDate(startPeriod);
            return this;
        }

        public ConsultCarmedInterventionRequestBuilder withEndPeriod(org.joda.time.DateTime endPeriod) {
            periodType.setEndDate(endPeriod);
            return this;
        }

        public ConsultCarmedInterventionRequest build() {
            return consultCarmedInterventionRequest;
        }
    }
}