﻿/*
 * Copyright (c) eHealth
 */
using System;
using NUnit.Framework;

using System;

using be.fgov.ehealth.errors.core.v1;
using be.fgov.ehealth.businessconnector.tests.utils;
using be.fgov.ehealth.technicalconnector.tests.utils;
using ikvm.extensions;
using NUnit.Framework;
using java.math;
using be.ehealth.technicalconnector.exception;
using be.fgov.ehealth.technicalconnector.tests.session;
using be.ehealth.technicalconnector.utils;
using be.fgov.ehealth.technicalconnector.tests.junit.rule;
using be.ehealth.businessconnector.genericasync.domain;
using be.cin.mycarenet._1_0.carenet.types;
using be.ehealth.businessconnector.medadmin.session;
using be.ehealth.businessconnector.medadmin.domain;
using NUnit.Framework;
using be.cin.nip.async.generic;
using java.util.concurrent;
using be.ehealth.business.mycarenetdomaincommons.domain;
    

namespace be.ehealth.businessconnector.mycarenet.medadmin.session
{
	[TestFixture]
	public class MedAdminPostAsyncIntegrationTest
	{        
        private static string REQUEST_FOLDER = ".\\examples\\medadmin\\async\\request\\";
            
        private static int SECONDS_WAITING = 120;
        
        [SetUp]
        public static void setup() {
           SessionInitializer.init(".\\be.ehealth.businessconnector.medadmin.test.properties",true,SupportedLanguages.NET.getAbbreviation());			
        }
		
        [Test]
        public void postSingleNurseContractualCareRequest_oa100() {
            postSingleNurseContractualCareRequest("SingleNurseContractualCareRequest.xml", "100");
        }
    
        [Test]
        public void postSingleNurseContractualCareRequest_oa300() {
            postSingleNurseContractualCareRequest("SingleNurseContractualCareRequest.xml", "300");
        }
    
        [Test]
        public void postSingleNurseContractualCareRequest_oa500() {
            postSingleNurseContractualCareRequest("SingleNurseContractualCareRequest.xml", "500");
        }
    
        [Test]
        public void postSingleNurseContractualCareRequest_oa600() {
            postSingleNurseContractualCareRequest("SingleNurseContractualCareRequest.xml", "600");
        }
    
        [Test]
        public void postSingleNurseContractualCareRequest_oa900() {
            postSingleNurseContractualCareRequest("SingleNurseContractualCareRequest.xml", "900");
        }
    
        [Test]
        public void postSinglePalliativeCareRequest_oa100() {
            postSinglePalliativeCareRequest("SinglePalliativeCareRequest.xml", "100");
        }
    
        [Test]
        public void postSinglePalliativeCareRequest_oa300() {
            postSinglePalliativeCareRequest("SinglePalliativeCareRequest.xml", "300");
        }
    
        [Test]
        public void postSinglePalliativeCareRequest_oa500() {
            postSinglePalliativeCareRequest("SinglePalliativeCareRequest.xml", "500");
        }
    
        [Test]
        public void postSinglePalliativeCareRequest_oa600() {
            postSinglePalliativeCareRequest("SinglePalliativeCareRequest.xml", "600");
        }
    
        [Test]
        public void postSinglePalliativeCareRequest_oa900() {
            postSinglePalliativeCareRequest("SinglePalliativeCareRequest.xml", "900");
        }
    
    
        [Test]
        public void postSingleSpecificTechnicalCareRequest_oa100() {
            postSingleSpecificTechnicalCareRequest("SingleSpecificTechnicalCareRequest.xml", "100");
        }
    
        [Test]
        public void postSingleSpecificTechnicalCareRequest_oa300() {
            postSingleSpecificTechnicalCareRequest("SingleSpecificTechnicalCareRequest.xml", "300");
        }
    
        [Test]
        public void postSingleSpecificTechnicalCareRequest_oa500() {
            postSingleSpecificTechnicalCareRequest("SingleSpecificTechnicalCareRequest.xml", "500");
        }
    
        [Test]
        public void postSingleSpecificTechnicalCareRequest_oa600() {
            postSingleSpecificTechnicalCareRequest("SingleSpecificTechnicalCareRequest.xml", "600");
        }
    
        [Test]
        public void postSingleSpecificTechnicalCareRequest_oa900() {
            postSingleSpecificTechnicalCareRequest("SingleSpecificTechnicalCareRequest.xml", "900");
        }
    
        [Test]
        public void postMedAdminRequestList_oa100() {
            postMedAdminRequestList("MedAdminRequestList.xml", "100");
        }
    
        [Test]
        public void postMedAdminRequestList_oa300() {
            postMedAdminRequestList("MedAdminRequestList.xml", "300");
        }
    
        [Test]
        public void postMedAdminRequestList_oa500() {
            postMedAdminRequestList("MedAdminRequestList.xml", "500");
        }
    
        [Test]
        public void postMedAdminRequestList_oa600() {
            postMedAdminRequestList("MedAdminRequestList.xml", "600");
        }
    
        [Test]
        public void postMedAdminRequestList_oa900() {
            postMedAdminRequestList("MedAdminRequestList.xml", "900");
        }
        
        private void postMedAdminRequestList(String requestFile, String oa) {
           ProcessedPostResponse processedPostResponse = MedadminSessionServiceFactory.getMedadminService()
                    .postMedAdminRequestList((MedAdminRequestList) ConnectorXmlUtils
                            .toObject(ConnectorIOUtils.getResourceAsByteArray(REQUEST_FOLDER + requestFile),
           	                                   typeof(MedAdminRequestList)), oa, generateInputReference());
           processTack(processedPostResponse.getPostResponse());
        }
    
        private void postSingleSpecificTechnicalCareRequest(String requestFile, String oa) {
           ProcessedPostResponse processedPostResponse = MedadminSessionServiceFactory.getMedadminService()
                    .postSingleSpecificTechnicalCareRequest((SingleSpecificTechnicalCareRequest) ConnectorXmlUtils
                            .toObject(ConnectorIOUtils.getResourceAsByteArray(REQUEST_FOLDER + requestFile),
           	                                                  typeof(SingleSpecificTechnicalCareRequest)), oa, generateInputReference());
           processTack(processedPostResponse.getPostResponse());
        }
    
        private void postSinglePalliativeCareRequest(String requestFile, String oa) {
           ProcessedPostResponse processedPostResponse = MedadminSessionServiceFactory.getMedadminService()
                    .postSinglePalliativeCareRequest((SinglePalliativeCareRequest) ConnectorXmlUtils
                            .toObject(ConnectorIOUtils.getResourceAsByteArray(REQUEST_FOLDER + requestFile),
           	                                           typeof(SinglePalliativeCareRequest)), oa, generateInputReference());
           processTack(processedPostResponse.getPostResponse());
        }
    
        private void postSingleNurseContractualCareRequest(String requestFile, String oa) {
           ProcessedPostResponse processedPostResponse = MedadminSessionServiceFactory.getMedadminService()
                    .postSingleNurseContractualCareRequest((SingleNurseContractualCareRequest) ConnectorXmlUtils
                            .toObject(ConnectorIOUtils.getResourceAsByteArray(REQUEST_FOLDER + requestFile),
           	                                                 typeof(SingleNurseContractualCareRequest)), oa, generateInputReference());
           processTack(processedPostResponse.getPostResponse());
        }
    
        private void processTack(PostResponse postResponse) {
            String reference = postResponse.getReturn().getReference();
            waitForTack();
            M4AXmlProcessedGetResponse response = MedadminSessionServiceFactory.getMedadminService()
                    .getM4AXml(GetRequest.newBuilder().withReference(reference).build());
            confirmTacks(response);
            response = MedadminSessionServiceFactory.getMedadminService()
                    .getM4AXml(GetRequest.newBuilder().withReference(reference).build());
            assertTackRemoved(response.getTAckResponses());
        }
        
        [Test]
        public void postM4AFlat() {
            ProcessedPostResponse processedPostResponse = MedadminSessionServiceFactory.getMedadminService()
                     .postM4AFlat(ConnectorIOUtils.getResourceAsByteArray(REQUEST_FOLDER + "EH-420000.txt"), "600", generateInputReference());
            String reference = processedPostResponse.getPostResponse().getReturn().getReference();
            waitForTack();
            ProcessedGetResponse response = MedadminSessionServiceFactory.getMedadminService()
                   .getM4AFlat(GetRequest.newBuilder().withReference(reference).build());
            confirmTacks(response);
            response = MedadminSessionServiceFactory.getMedadminService()
                     .getM4AFlat(GetRequest.newBuilder().withReference(reference).build());
            assertTackRemoved(response.getTAckResponses());
        }
    
        private void confirmTacks(ProcessedGetResponse processedGetResponse) {
            ConfirmResponse confirmResponse = MedadminSessionServiceFactory.getMedadminService().confirmAllTAcks(processedGetResponse);
            Assert.IsNotNull(confirmResponse);
        }
    
        public void assertTackRemoved(java.util.List tAckResponses) {
            Assert.AreEqual(0, tAckResponses.size(), "Tack should be removed");
        }
    
        public void waitForTack() {
            TimeUnit.SECONDS.sleep(SECONDS_WAITING);
        }
        
        private be.ehealth.business.mycarenetdomaincommons.domain.InputReference generateInputReference() {
            // create a reference with format yyyyMMddHHmmss
            return new be.ehealth.business.mycarenetdomaincommons.domain.InputReference();
            // or:
            // return new InputReference("your custom reference");        
        }
	}
}
