﻿/*
 * Copyright (c) eHealth
 */
using System;
using java.math;
using NUnit.Framework;

using be.fgov.ehealth.technicalconnector.tests.session;
using be.fgov.ehealth.businessconnector.tests.utils;
using be.fgov.ehealth.technicalconnector.tests.utils;
using be.ehealth.technicalconnector.session;
using be.ehealth.businessconnector.insurabilityv2.builders;
using be.ehealth.businessconnector.insurabilityv2.builders.impl;
using be.ehealth.businessconnector.insurabilityv2.domain;
using be.ehealth.businessconnector.insurabilityv2.session;
using be.ehealth.businessconnector.insurabilityv2.session.impl;
using be.fgov.ehealth.insurability.core.v2;
using be.fgov.ehealth.insurability.protocol.v2;
using org.unitils.reflectionassert;
using be.ehealth.technicalconnector.exception;



namespace be.ehealth.businessconnector.insurabilityv2.integration
{
	[TestFixture]
	public class InsurabilityIntegrationtest
	{
		[SetUp]
		public void init(){
			SessionInitializer.init(".\\be.ehealth.businessconnector.insurabilityv2.test.properties",SupportedLanguages.NET.getAbbreviation());
		}
		
		[TearDown]
		public void tearDown() {
			Session.getInstance().unloadSession();
		}
		
		[Test]
		public void testOA500(){
			generateTest("96022530604", null, null, "F", new org.joda.time.DateTime());
		}
		
		[Test]
		public void testOA100(){
			generateTest("82051234978", null, null, "F", new org.joda.time.DateTime());
		}
		
		private void generateTest(String ssin, String mutuality, String registNumber, String requestType, org.joda.time.DateTime requestDate){
			
			RequestObjectBuilder requestObjectBuilder = new RequestObjectBuilderImpl();
			GetInsurabilityForPharmacistRequest insurabilityRequest;
			
			InsurabilityReferences references = new InsurabilityReferences(true);
			InsurabilityForPharmacistRequest request = new InsurabilityForPharmacistRequest();
			CareReceiverIdType careReceiverId = new CareReceiverIdType();
			
			// Variables initialization
			Boolean isTest = false;
			
			careReceiverId.setSsin(ssin);
			careReceiverId.setMutuality(mutuality);
			careReceiverId.setRegNrWithMut(registNumber);
			
			request.setCareReceiver(careReceiverId);
			request.setDate(requestDate);
			request.setRequestType(requestType);
			
			insurabilityRequest = requestObjectBuilder.buildInsurabilityForPharmacistRequest(isTest, references, request);
			
			// Construction asserts
			ReflectionAssert.assertReflectionEquals(request, insurabilityRequest.getInsurabilityRequest(), ReflectionComparatorMode.LENIENT_ORDER);
			Assert.AreEqual(references.getRecordCommonInputId(), insurabilityRequest.getRecordCommonInput().getUserReference());
			Assert.AreEqual(isTest, insurabilityRequest.getCommonInput().getRequest().isIsTest());
			
			// Session & service
			InsurabilityService insurabilityService = InsurabilitySessionServiceFactory.getInsurabilityService();
			try {
				GetInsurabilityForPharmacistResponse insurabilityForPharmacist = insurabilityService.getInsurabilityForPharmacist(insurabilityRequest);
				Assert.AreEqual("200", insurabilityForPharmacist.getStatus().getCode());
				
			} catch (SoaErrorException e) {
				GetInsurabilityForPharmacistResponse response = (GetInsurabilityForPharmacistResponse) e.getResponseType();
				ReturnCodeType returnCode = response.getReturnInfo().getReturnCode();
				Console.WriteLine("Error Status received [" + e.getErrorCode() + "]: Major[" + returnCode.getMajor() + "] Minor [" + returnCode.getMinor() + "] Detail [" + returnCode.getDetail() + "]");
				throw e;
			}
		}
	}
}
