package be.ehealth.businessconnector.test.vsbnet.async.session;

import org.junit.FixMethodOrder;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.MethodSorters;

import be.fgov.ehealth.technicalconnector.tests.junit.rule.SessionRule;


/**
 * @author EHP
 */
@FixMethodOrder(MethodSorters.NAME_ASCENDING)
public class VsbNet_eMOHDF104_V4_IntegrationTest {

    private static final String FILES_FOLDER = "/examples/vsbnet/async/eHMOHDF104_V4/";

    @Rule
    public SessionRule rule = SessionRule.withActiveSession().baseOn("/be.ehealth.businessconnector.vsbnet.test.properties").build();

    // Prerequisites :
    // Execute every tests in EHMOHDF112 V2 tests
    
    @Test
    public void test_5_1a_POST_ConsultSupportAndRepairV4() throws Exception {
        VsbNetGenericAsyncMethod.do_POST_ConsultSupportAndRepairV4(FILES_FOLDER + "vsb-mohm_DF104_5-1_TC_CSUP1_testlink_eWZC-3063_request.xml");
    }

    @Test
    public void test_5_1b_GET_ConsultSupportAndRepairV4() throws Exception {
        VsbNetGenericAsyncMethod.do_GET_ConsultSupportAndRepairV4(FILES_FOLDER + "vsb-mohm_DF104_5-1_TC_CSUP1_testlink_eWZC-3063_response.xml", false);
    }

    @Test
    public void test_5_2a_POST_ConsultSupportAndRepairV4() throws Exception {
        VsbNetGenericAsyncMethod.do_POST_ConsultSupportAndRepairV4(FILES_FOLDER + "vsb-mohm_DF104_5-2_TC_CSUP2_testlink_eWZC-3064_request.xml");
    }

    @Test
    public void test_5_2b_GET_ConsultSupportAndRepairV4() throws Exception {
        VsbNetGenericAsyncMethod.do_GET_ConsultSupportAndRepairV4(FILES_FOLDER + "vsb-mohm_DF104_5-2_TC_CSUP2_testlink_eWZC-3064_response_.xml", false);
    }
}
