﻿﻿/*
 * Copyright (c) eHealth
 */
using System;
using be.cin.nip.async.generic;
using be.ehealth.business.mycarenetdomaincommons.builders;
using be.ehealth.business.mycarenetcommons.builders.util;
using be.ehealth.business.mycarenetdomaincommons.domain;
using be.ehealth.business.mycarenetcommons.mapper;
using be.ehealth.business.mycarenetdomaincommons.util;
using be.ehealth.businessconnector.genericasync.builders;
using be.ehealth.businessconnector.genericasync.mappers;
using be.ehealth.businessconnector.genericasync.session;
using be.ehealth.technicalconnector.config.util;
using be.ehealth.technicalconnector.handler.domain;
using be.ehealth.technicalconnector.idgenerator;
using be.ehealth.technicalconnector.session;
using be.ehealth.technicalconnector.utils;
using be.fgov.ehealth.mycarenet.commons.core.v2;
using be.fgov.ehealth.technicalconnector.signature.config.impl;
using be.fgov.ehealth.technicalconnector.tests.session;
using be.fgov.ehealth.businessconnector.tests.utils;
using be.fgov.ehealth.technicalconnector.tests.utils;
using java.net;
using NUnit.Framework;
using org.mapstruct.factory;

namespace be.ehealth.businessconnector.invoicing
{
	[TestFixture]
	public class ParametrizedExternalPostIntegrationTest
	{	
	    private static String PROJECT_NAME = "invoicing";
	    
	    [SetUp]
	    public static void init() {
	    	SessionInitializer.init(".\\be.ehealth.businessconnector.invoicing.test.properties",SupportedLanguages.NET.getAbbreviation());
	    	new ConfigurationModuleRegisterTransformers().init(null);
	    }
	
	    [TearDown]
	    public static void tearDown() {
	        Session.getInstance().unloadSession();
	    }
	    
	    [Test]
	    public void post_TFAC1SC09509E_OA100(){
	    	performPostRequestTest("TFAC1SC09.509E","100");
	    }
	    
	    [Test]
	    public void post_TFAC1SC11510E_OA100(){
	    	performPostRequestTest("TFAC1SC11.510E","100");
	    }
	    	    
	    [Test]
	    public void post_TFAC1SC12518E_OA100(){
	    	performPostRequestTest("TFAC1SC12.518E","100");
	    }
	   
	    [Test]
	    public void post_TFAC1SC13519E_OA100(){
	    	performPostRequestTest("TFAC1SC13.519E","100");
	    }
	    
	    [Test]
	    public void post_TFAC1SC15520E_OA100(){
	    	performPostRequestTest("TFAC1SC15.520E","100");
	    }
	    
	    /**
	     * @param encodingType
	     * @param addOaInHeader
	     * @throws TechnicalConnectorException
	     * @throws InvalidBlobContentConnectorException
	     * @throws GenAsyncBusinessConnectorException
	     * @throws InstantiationException
	     * @throws ConnectorException
	     * @throws URISyntaxException
	     * @throws SessionManagementException
	     */
	    private void performPostRequestTest(
	    	//Parameterized test not correctly implemented by SharpDevelopper (Unit test not displayed)
	    	/*[Values("TFAC1SC09.509E","TFAC1SC11.510E","TFAC1SC12.518E","TFAC1SC13.519E","TFAC1SC15.520E")]*/ String requestContentLocation,
	    	/*[Values("100")]*/ String mutuality
	    	) {
	        
	        byte[] contentBytes = ConnectorIOUtils.getBytes(ConnectorIOUtils.getResourceAsStream(".\\examples\\request\\"+ requestContentLocation));
	        BlobBuilder bbuilder = RequestBuilderFactory.getBlobBuilder(PROJECT_NAME);
	        
	        Blob blob = bbuilder.build(contentBytes);
	        blob.setMessageName("HCPFAC");
	        
	        String inputReference = IdGeneratorFactory.getIdGenerator().generateId();
	        CommonInputMapper mapper = (CommonInputMapper) Mappers.getMapper(typeof(CommonInputMapper));
	        be.cin.mycarenet.esb.common.v2.CommonInput ci = mapper.map(RequestBuilderFactory.getCommonBuilder("invoicing").createCommonInput(McnConfigUtil.retrievePackageInfo("genericasync." + "invoicing"), true, inputReference));
	        
	        be.cin.types.v1.Blob det = SendRequestMapper.mapBlobToCinBlob(blob);
	        BlobType blobForXades = SendRequestMapper.mapBlobToBlobType(blob);
	        byte[] xades = BlobUtil.generateXades(blobForXades, "invoicing").getValue();
	
	        Post post = BuilderFactory.getRequestObjectBuilder(PROJECT_NAME).buildPostRequest(ci, det, xades);
	
	        GenAsyncService service = GenAsyncSessionServiceFactory.getGenAsyncService(PROJECT_NAME);
	        WsAddressingHeader header = WsAddressingUtil.createHeader(mutuality, "urn:be:cin:nip:async:generic:post:msg");
	
	        PostResponse responsePost = service.postRequest(post, header);
	        ConnectorXmlUtils.dump(responsePost);
	
	        ResponseObjectBuilder responseBuilder = BuilderFactory.getResponseObjectBuilder();
	        responseBuilder.handlePostResponse(responsePost);
	    }
	}
}
