/*
 * Copyright (c) eHealth
 */
using System;
using NUnit.Framework;
using java.util;


using be.fgov.ehealth.technicalconnector.tests.session;
using be.fgov.ehealth.businessconnector.tests.utils;
using be.fgov.ehealth.technicalconnector.tests.utils;
using be.fgov.ehealth.hubservices.core.v1;
using be.fgov.ehealth.standards.kmehr.id.v1;
using be.fgov.ehealth.standards.kmehr.schema.v1;
using be.ehealth.technicalconnector.session;
using be.ehealth.businessconnector.hub.util;


namespace be.ehealth.businessconnector.hub.security
{
	/**
	 * Integration test for {@link HubRequestWithEncryption}
	 * 
	 * @author EHP
	 * 
	 */
	[TestFixture]
	public class HubRequestWithEncryptionIntegrationTest
	{
		
		[SetUp]
		public static void init() {
			SessionInitializer.init(".\\be.ehealth.businessconnector.intrahub.test.properties", SupportedLanguages.NET.getAbbreviation());
		}
		
		[TearDown]
		public static void tearDown() {
			Session.getInstance().unloadSession();
		}
		
		/**
		 * @throws Exception
		 */
		[Test]
		public void testHubRequest() {
			RequestType req = RequestTypeBuilder.init().addAuthorWithEncryptionInformation().build();		
			java.util.List partiesList = req.getAuthor().getHcparties();
			bool containsEncryption = false;
			for (int i = 0; i< partiesList.size() ; i++){
				be.fgov.ehealth.standards.kmehr.schema.v1.HcpartyType hcp = (be.fgov.ehealth.standards.kmehr.schema.v1.HcpartyType)partiesList.get(i);
				if (hcp.getFirstname()!= null){
					for (int j = 0; j < hcp.getIds().size() ; j++) {
						be.fgov.ehealth.standards.kmehr.id.v1.IDHCPARTY id = (be.fgov.ehealth.standards.kmehr.id.v1.IDHCPARTY)hcp.getIds().get(j);
						if (((be.fgov.ehealth.standards.kmehr.id.v1.IDHCPARTYschemes)id.getS()).compareTo(IDHCPARTYschemes.ID_ENCRYPTION_ACTOR)==0){
							containsEncryption=true;
						}
					}
				}
			}
			Assert.IsTrue(containsEncryption);

		}
	}
}
