﻿/*
 * Copyright (c) eHealth
 */
using System;
using NUnit.Framework;
using org.joda.time;
using be.ehealth.businessconnector.ehbox.api.domain;
using be.ehealth.technicalconnector.utils;

namespace be.ehealth.businessconnector.ehbox.v3.util
{
    public class MessageBuilder
    {
        private Addressee destination;

        private string mimeType;

        private string title;

        private string content;

        private bool encrypted;

        private bool important;

        private bool receiveAck;

        private bool publicationAck;

        private bool readAck;

        public static MessageBuilder create(Addressee addressee, string content) {
            MessageBuilder builder = new MessageBuilder(addressee, content);
            builder.mimeType = "text/plain";
            builder.title = "title " + DateUtils.printDate(new org.joda.time.DateTime());
            builder.encrypted = false;
            builder.important = false;
            builder.receiveAck = false;
            builder.publicationAck = false;
            builder.readAck = false;
            return builder;
        }

        public MessageBuilder withMimeType(string mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public MessageBuilder withTitle(string title) {
            this.title = title;
            return this;
        }

        public MessageBuilder withEncrypted(bool encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public MessageBuilder withImportant(bool important) {
            this.important = important;
            return this;
        }

        public MessageBuilder withReceiveAck(bool receiveAck) {
            this.receiveAck = receiveAck;
            return this;
        }

        public MessageBuilder withPublicationAck(bool publicationAck) {
            this.publicationAck = publicationAck;
            return this;
        }

        public MessageBuilder withReadAck(bool readAck) {
            this.readAck = readAck;
            return this;
        }

        private MessageBuilder(Addressee destination, string content) {
            this.destination = destination;
            this.content = content;
        }

        public Addressee getDestination() {
            return destination;
        }

        public string getMimeType() {
            return mimeType;
        }

        public string getTitle() {
            return title;
        }

        public string getContent() {
            return content;
        }

        public bool isEncrypted() {
            return encrypted;
        }

        public bool isImportant() {
            return important;
        }

        public bool isReceiveAck() {
            return receiveAck;
        }

        public bool isPublicationAck() {
            return publicationAck;
        }

        public bool isReadAck() {
            return readAck;
        }
    }
}
