﻿/*
 * Copyright (c) eHealth
 */
using System;
using System.Text;
using ikvm.extensions;
using NUnit.Framework;
using java.io;
using be.ehealth.businessconnector.chapterIV.builders;
using be.ehealth.businessconnector.chapterIV.exception;
using be.ehealth.businessconnector.chapterIV.session;
using be.ehealth.technicalconnector.exception;
using be.fgov.ehealth.technicalconnector.tests.session;
using be.ehealth.technicalconnector.utils;
using be.fgov.ehealth.chap4.core.v1;
using be.fgov.ehealth.errors.core.v1;
using be.fgov.ehealth.errors.soa.v1;
using be.fgov.ehealth.standards.kmehr.schema.v1;
using be.ehealth.technicalconnector.session;
using be.fgov.ehealth.businessconnector.tests.utils;
using be.fgov.ehealth.technicalconnector.tests.utils;

namespace be.ehealth.businessconnector.chapterIV.integration
{
	[TestFixture]
	public class AbstractChapterIV
	{
		private static ResponseBuilder responseBuilder;

		[SetUp]
			public static void setup() {
			SessionInitializer.init("be.ehealth.businessconnector.chapterIV.test.properties",true,SupportedLanguages.NET.getAbbreviation());
			responseBuilder = BuilderFactory.getBuilderFactoryForSession().getResponseBuilder();
		}


		protected void process(String service, ChapterIVBusinessConnectorException e) {
			StringBuilder sb = new StringBuilder();
			appendAndLog(sb, e.getMessage());

			SOAErrorType soaError = e.getSOAError();
			if (soaError != null) {
				String errorCode = soaError.getCode();
				appendAndLog(sb, "ChapterIVIntegrationTest.test" + service + "Request: error : " + errorCode);
				appendAndLog(sb, "contact :" + soaError.getContact());
				appendAndLog(sb, "environment : " + soaError.getEnvironment());
				appendAndLog(sb, "id :" + soaError.getId());
				appendAndLog(sb, "Origin " + soaError.getOrigin());
				appendAndLog(sb, "isRetrye : " + soaError.isRetry());
				for (int i =0; i<soaError.getMessages().size(); i++) {
					LocalisedStringType localisedString = (LocalisedStringType) soaError.getMessages().get(i);
					appendAndLog(sb, "message : lang=" + localisedString.getLang() + " and value = " + localisedString.getValue());
				}
			}
			Assert.Fail(sb.toString());
		}


		protected void process(String service, SoaErrorException e) {
			StringBuilder sb = new StringBuilder();
			String errorCode = e.getErrorCode();
			appendAndLog(sb, "ChapterIVIntegrationTest.test" + service + "Request: error : " + errorCode);
			FaultType fault = responseBuilder.retrieveReturnInfo(e.getResponseType());
			String errorMessage = "";
			if (fault.getMessage() != null) {
				errorMessage = fault.getMessage().getValue();
			}
			appendAndLog(sb, "errorMessage :" + errorMessage);
			for (int i=0; i<fault.getDetails().size();i++) {
				DetailType detail = (DetailType)fault.getDetails().get(i);
				appendAndLog(sb, "detail : " + detail.getDetailCode() + " " + detail.getDetailSource() + " " + detail.getLocation() + " " + (detail.getMessage() == null ? "no messages" : detail.getMessage().getValue()));
			}
			Assert.Fail(sb.toString());
		}

		protected void process(String service, Exception e) {
			throw e;
		}


		protected FolderType parseFolderType(InputStream xmlResourceInputStream) {
			MarshallerHelper folderTypeMarshaller = new MarshallerHelper(typeof(FolderType), typeof(FolderType));
			return (FolderType) folderTypeMarshaller.toObject(xmlResourceInputStream);
		}


		protected void appendAndLog(StringBuilder sb, String message) {
			sb.Append(message).Append("\n");
		}


		public static ResponseBuilder getResponseBuilder() {
			return responseBuilder;
		}


		protected static bool isDoctor() {
			java.util.List result = SAMLTokenUtils.getAttributeValue(Session.getInstance().getSession().getSAMLToken().getAssertion(), "doctor");
			return !result.isEmpty();
		}

		protected static bool isPharmacy() {
			java.util.List result = SAMLTokenUtils.getAttributeValue(Session.getInstance().getSession().getSAMLToken().getAssertion(), "pharmacy");
			return !result.isEmpty();
		}
	}
}
