﻿/*
 * Copyright (c) eHealth
 */
using System;
using be.ehealth.businessconnector.mycarenet.agreementasync.session;
using NUnit.Framework;
using be.fgov.ehealth.businessconnector.tests.utils;
using be.fgov.ehealth.technicalconnector.tests.utils;
using ikvm.extensions;
using be.fgov.ehealth.technicalconnector.tests.session;
using be.ehealth.technicalconnector.utils;
using be.ehealth.technicalconnector.enumeration;
using be.ehealth.businessconnector.genericasync.domain;
using be.cin.mycarenet._1_0.carenet.types;
using be.cin.encrypted;
using be.cin.nip.async.generic;

namespace be.ehealth.businessconnector.mycarenet.agreementasync.session
{
	
	[TestFixture]
	public class AgreementGetAsyncIntegrationTest
	{
		
		[SetUp]
		public static void setup() {
			SessionInitializer.init(".\\be.ehealth.businessconnector.mycarenet.agreementasync.test.properties",true,SupportedLanguages.NET.getAbbreviation());
		}
		
		[Test]
		public void getEAgreementResponse() {
			ProcessedGetResponse response = (ProcessedGetResponse) AgreementSessionServiceFactory.getAgrementService().getEAgreementResponse(GetRequest.newBuilder().withDefaults().build());
			
			Assert.IsTrue(response.getMsgResponses().size() > 0);
			ProcessedMsgResponse processedMsgResponse = (ProcessedMsgResponse)response.getMsgResponses().get(0);
			Assert.AreEqual(0, processedMsgResponse.getSignatureVerificationResult().getErrors().size(), "SignatureVerificationResult should contain no error");
			MsgResponse msgResponse = (MsgResponse) processedMsgResponse.getMsgResponse();
			Assert.IsNotNull(processedMsgResponse.getMsgResponse().getXadesT(), "Missing xades");
			be.fgov.ehealth.businessconnector.tests.utils.XmlAsserter.assertSimilar(ConnectorXmlUtils.toObject(processedMsgResponse.getSignedData(), typeof(EncryptedKnownContent)), processedMsgResponse.getRawDecryptedBlob());
			byte[] businessContent = (byte[]) ((ProcessedMsgResponse) response.getMsgResponses().get(0)).getBusinessResponse();
			String stringContent = ConnectorIOUtils.toString(businessContent, Charset.UTF_8);
			be.fgov.ehealth.businessconnector.tests.utils.XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString(".\\examples\\mycarenet\\eagreementasync\\expected\\eAgreementResponse.xml"), stringContent);
			
			AgreementSessionServiceFactory.getAgrementService().confirmAllMessages(response);
		}
	}
}
