﻿/*
 * Copyright (c) eHealth
 */
using System;
using ikvm.extensions;
using NUnit.Framework;
using java.io;
using java.util;
using org.joda.time;
using be.ehealth.technicalconnector.config;
using be.ehealth.technicalconnector.exception;
using be.ehealth.technicalconnector.session;
using be.ehealth.technicalconnector.utils;
using be.fgov.ehealth.mediprima.core.v2;
using be.fgov.ehealth.mediprima.protocol.v2;
using be.fgov.ehealth.businessconnector.tests.utils;
using be.fgov.ehealth.technicalconnector.tests.utils;
using be.fgov.ehealth.technicalconnector.tests.session;
using be.ehealth.technicalconnector.idgenerator;
using be.ehealth.businessconnector.mediprimav2.builder;

namespace be.ehealth.businessconnector.mediprimav2.session
{

/**
 * Integration tests for consultation mediprima. The scenarios numbering match those of the MediPrima specification.
 * /!\ The configuration must have this Mediprima Consult specific saml attribute property:
 *        sessionmanager.samlattributedesignator.8=urn:be:fgov:certified-namespace:ehealth,urn:be:fgov:ehealth:1.0:pharmacy:nihii-number:recognisedpharmacy:nihii11
 *
 *
 * @author EHP
 */
public class MediprimaConsultationOrgpharmacyIntegrationTest {
		
		 
        [TestFixture]
        public class WithSoaErrorIntegrationTest {

            static object[] testCase =
        {
            new Object[]{"scenario01", "Invalid ssin", ConsultCarmedInterventionRequestBuilder.aRequest().withSsin("85000132773").withPeriod().build()},
            new Object[]{"scenario02", "call pharmacist on period", ConsultCarmedInterventionRequestBuilder.aRequest().withSsin("70410100375").withPeriod().build()},
            new Object[]{"scenario03", "Date requested is in the future (not allowed)", ConsultCarmedInterventionRequestBuilder.aRequest().withSsin("70410100375").withReferenceDate(new org.joda.time.DateTime().plusDays(10)).build()},
            new Object[]{"scenario04", "Date requested is too much in the past (not allowed)", ConsultCarmedInterventionRequestBuilder.aRequest().withSsin("70410100375").withReferenceDate(new org.joda.time.DateTime().minusMonths(3)).build()}
        };


            [SetUp]
            public static  void setupsession() {
                SessionInitializer.init(".\\be.ehealth.businessconnector.mediprima.v2.orgpharmacy.test.properties", SupportedLanguages.NET.getAbbreviation());
            }

            [TearDown]
            public static void teardownSession()  {
                Session.getInstance().unloadSession();
            }

            [Test, TestCaseSource("testCase")]
            public void testScenario(String scenarioId, String scenarioName, ConsultCarmedInterventionRequest request) {
               try {
                   MediprimaSessionServiceFactory.getConsultationMediprimaSession().consultCarmedIntervention(request);
                   Assert.Fail("should have thrown SoaErrorException");
               } catch (SoaErrorException e) {
                   ConsultCarmedInterventionResponse response = (ConsultCarmedInterventionResponse) e.getResponseTypeV2();
                   String expected = expectedResponse(request.getSelectionCriteria().getBySsin().getReferenceDate(), request.getId(), scenarioId);
                   MarshallerHelper helper = new MarshallerHelper(typeof(ConsultCarmedInterventionResponse), typeof(ConsultCarmedInterventionResponse));
                   be.fgov.ehealth.businessconnector.tests.utils.XmlAsserter.assertSimilar(expected, helper.toString((ConsultCarmedInterventionResponse) response));
               }
            }
        }


        /**
         * Integration tests for consultation mediprima.
         *
         * @author EHP
         *
         */
        [TestFixture]
        public class WithoutSoaErrorIntegrationTest {

            static object[] testCase =
        {
            new Object[]{"scenario05", "Unknown ssin", ConsultCarmedInterventionRequestBuilder.aRequest().withSsin("70410100375").withReferenceDate(new org.joda.time.DateTime()).build()},
            new Object[]{"scenario06", "Known ssin but dates nok", ConsultCarmedInterventionRequestBuilder.aRequest().withSsin("60061861748").withReferenceDate(new org.joda.time.DateTime()).build()},
            new Object[]{"scenario07", "No corresponding coverage", ConsultCarmedInterventionRequestBuilder.aRequest().withSsin("68050555876").withReferenceDate(new org.joda.time.DateTime()).build()},
            new Object[]{"scenario08", "Decision without required rights - coverage exists but nok", ConsultCarmedInterventionRequestBuilder.aRequest().withSsin("95090238957").withReferenceDate(new org.joda.time.DateTime()).build()},
            new Object[]{"scenario09", "Coverage ok, but unauthorized provider", ConsultCarmedInterventionRequestBuilder.aRequest().withSsin("88081964510").withReferenceDate(new org.joda.time.DateTime()).build()},
            new Object[]{"scenario10", "Card with rights ok but suspended", ConsultCarmedInterventionRequestBuilder.aRequest().withSsin("93122961468").withReferenceDate(new org.joda.time.DateTime()).build()},
            new Object[]{"scenario11", "Full SPP support, extra list", ConsultCarmedInterventionRequestBuilder.aRequest().withSsin("94000087334").withReferenceDate(new org.joda.time.DateTime()).build()},
            new Object[]{"scenario12", "Full SPP support, supplements via convention", ConsultCarmedInterventionRequestBuilder.aRequest().withSsin("90101351882").withReferenceDate(new org.joda.time.DateTime()).build()},
            new Object[]{"scenario13", "Partial SPP support, supplements = all", ConsultCarmedInterventionRequestBuilder.aRequest().withSsin("74032853407").withReferenceDate(new org.joda.time.DateTime()).build()},
            new Object[]{"scenario14", "Partial SPP support, supplements = nothing", ConsultCarmedInterventionRequestBuilder.aRequest().withSsin("68031061549").withReferenceDate(new org.joda.time.DateTime()).build()}
        };



            [SetUp]
            public static  void setupsession() {
                SessionInitializer.init(".\\be.ehealth.businessconnector.mediprima.v2.orgpharmacy.test.properties", SupportedLanguages.NET.getAbbreviation());
            }

            [TearDown]
            public static void teardownSession()  {
                Session.getInstance().unloadSession();
            }

            [Test, TestCaseSource("testCase")]
            public void testScenario(String scenarioId, String scenarioName, ConsultCarmedInterventionRequest request) {
                   ConsultCarmedInterventionResponse response = MediprimaSessionServiceFactory.getConsultationMediprimaSession().consultCarmedIntervention(request);

            String expected = expectedResponse(request.getSelectionCriteria().getBySsin().getReferenceDate(), request.getId(), scenarioId);
            MarshallerHelper helper = new MarshallerHelper(typeof(ConsultCarmedInterventionResponse), typeof(ConsultCarmedInterventionResponse));
            be.fgov.ehealth.businessconnector.tests.utils.XmlAsserter.assertSimilar(expected, helper.toString((ConsultCarmedInterventionResponse) response));
            }
        }

        private static string expectedResponse(org.joda.time.DateTime consultationDate, String requestId, String scenarioId) {
            Map templateContext = new HashMap();
            templateContext.put("requestId", requestId);
            templateContext.put("consultationDate", DateUtils.printDate(consultationDate));
            templateContext.put("startDate", DateUtils.printDate(new org.joda.time.DateTime()));
            templateContext.put("endDate", DateUtils.printDate(new org.joda.time.DateTime()));
            return TemplateEngineUtils.generate(templateContext, ".\\examples\\mediprimav2\\consultation\\expected\\orgpharmacy\\" + scenarioId + "Response.xml");
        }
    }
}