﻿/*
 * Copyright (c) eHealth
 */
using System;
using ikvm.extensions;
using NUnit.Framework;
using java.io;
using java.util;
using org.joda.time;
using org.joda.time.format;
using be.fgov.ehealth.businessconnector.tests.utils;
using be.fgov.ehealth.technicalconnector.tests.utils;
using be.ehealth.technicalconnector.config;
using be.ehealth.technicalconnector.exception;
using be.ehealth.technicalconnector.session;
using be.ehealth.technicalconnector.utils;
using be.fgov.ehealth.standards.kmehr.mycarenet.schema.v1;
using be.fgov.ehealth.technicalconnector.tests.session;
using be.ehealth.business.common.domain;
using be.ehealth.technicalconnector.adapter;
using be.cin.encrypted;
using be.fgov.ehealth.messageservices.mycarenet.core.v1;
using be.ehealth.businessconnector.mycarenet.attestv2.domain;
using be.ehealth.businessconnector.mycarenet.attestv2.session;
using be.fgov.ehealth.mycarenet.attest.protocol.v2;
using be.ehealth.businessconnector.attestv2.helper;

namespace be.ehealth.businessconnector.attestv2.session
{
	/**
	 * eAttest Integration Test. The scenarios numbering matches one specified by mycarenet.
	 *
	 * @author EHP
	 */
	[TestFixture]
	public class CancelAttestPhysicianIntegrationTest
	{
		    
        private AttestIntegrationTestHelper helper = new AttestIntegrationTestHelper();
    
        [SetUp]
        public static  void setupsession() {
            SessionInitializer.init(".\\be.ehealth.businessconnector.attestv2.physician.test.properties", SupportedLanguages.NET.getAbbreviation());
        }
        
        [TearDown]
        public static void teardownSession()  {
            Session.getInstance().unloadSession();
        }
        
        [Test]
        public void cancelAttestationOA100MED5a() {

            InputReference inputReference = new InputReference();
            String scenarioName = "MED5a";
    
            CancelAttestBuilderRequest attestBuilderRequest = helper.buildRequest(new InputReference(),scenarioName, "71010639352", "MED","100-1-190226-9851229-88");
            CancelAttestationResponse response = AttestSessionServiceFactory.getAttestService().cancelAttestation(attestBuilderRequest.getCancelAttestationRequest());
    
            assertCancelResult(inputReference, scenarioName, "100", "MED", response, attestBuilderRequest);
        }
    
        [Test]
        public void cancelAttestationOA500MED5a()  {
    
            InputReference inputReference = new InputReference();
            String scenarioName = "MED5a";
    
            CancelAttestBuilderRequest attestBuilderRequest = helper.buildRequest(new InputReference(),scenarioName, "62110906574", "MED","500-1-190110-4567890-16");
            CancelAttestationResponse response = AttestSessionServiceFactory.getAttestService().cancelAttestation(attestBuilderRequest.getCancelAttestationRequest());
    
            assertCancelResult(inputReference, scenarioName, "500", "MED", response, attestBuilderRequest);
        }
    
        [Test]
        public void cancelAttestationOA100MED5b()  {
            InputReference inputReference = new InputReference();
            String scenarioName = "MED5b";
    
            CancelAttestBuilderRequest attestBuilderRequest = helper.buildRequest(new InputReference(),scenarioName, "71010639352", "MED","100-1-190226-9851229-88");
            CancelAttestationResponse response = AttestSessionServiceFactory.getAttestService().cancelAttestation(attestBuilderRequest.getCancelAttestationRequest());
    
            assertCancelResult(inputReference, scenarioName, "100", "MED", response, attestBuilderRequest);
        }
    
        [Test]
        public void cancelAttestationOA500MED5b()  {
            InputReference inputReference = new InputReference();
            String scenarioName = "MED5b";
    
            CancelAttestBuilderRequest attestBuilderRequest = helper.buildRequest(new InputReference(),scenarioName, "62110906574", "MED","500-1-190110-4567890-16");
            CancelAttestationResponse response = AttestSessionServiceFactory.getAttestService().cancelAttestation(attestBuilderRequest.getCancelAttestationRequest());
    
            assertCancelResult(inputReference, scenarioName, "500", "MED", response, attestBuilderRequest);
        }
    
        [Test]
        public void cancelAttestationOA100MED5c()  {
            InputReference inputReference = new InputReference();
            String scenarioName = "MED5c";
    
            CancelAttestBuilderRequest attestBuilderRequest = helper.buildRequest(new InputReference(),scenarioName, "71010639352","MED","100-1-190226-9851229-88");
            CancelAttestationResponse response = AttestSessionServiceFactory.getAttestService().cancelAttestation(attestBuilderRequest.getCancelAttestationRequest());
    
            assertCancelResult(inputReference, scenarioName, "100", "MED", response, attestBuilderRequest);
        }
    
        [Test]
        public void cancelAttestationOA500MED5c()  {
            InputReference inputReference = new InputReference();
            String scenarioName = "MED5c";
    
            CancelAttestBuilderRequest attestBuilderRequest = helper.buildRequest(new InputReference(),scenarioName, "62110906574", "MED","500-1-190110-4567890-16");
            CancelAttestationResponse response = AttestSessionServiceFactory.getAttestService().cancelAttestation(attestBuilderRequest.getCancelAttestationRequest());
    
            assertCancelResult(inputReference, scenarioName, "500", "MED", response, attestBuilderRequest);
        }
    
    
        [Test]
        public void cancelAttestationOA100MED6()  {
            InputReference inputReference = new InputReference();
            String scenarioName = "MED6";
            String ssin = "71010639352";
            SendAttestBuilderRequest sendBuilderRequest = helper.buildRequest(inputReference,"MED4", ssin, "MED");
            SendAttestationResponse sendResponse = AttestSessionServiceFactory.getAttestService()
                    .sendAttestation(sendBuilderRequest.getSendAttestationRequest());
            String invoiceNumber = helper.getInvoiceNumber(sendResponse, sendBuilderRequest);
            CancelAttestBuilderRequest cancelBuilderRequest = helper.buildRequest(new InputReference(),scenarioName, ssin, "MED",invoiceNumber);
            CancelAttestationResponse response = AttestSessionServiceFactory.getAttestService().cancelAttestation(cancelBuilderRequest.getCancelAttestationRequest());
    
            assertCancelResult(inputReference, scenarioName, "100", "MED", response, cancelBuilderRequest);
        }
    
        [Test]
        public void cancelAttestationOA500MED6()  {
            InputReference inputReference = new InputReference();
            String scenarioName = "MED6";
            String ssin = "62110906574";
            SendAttestBuilderRequest sendBuilderRequest = helper.buildRequest(inputReference,"MED4", ssin, "MED");
            SendAttestationResponse sendResponse = AttestSessionServiceFactory.getAttestService()
                            .sendAttestation(sendBuilderRequest.getSendAttestationRequest());
            String invoiceNumber = helper.getInvoiceNumber(sendResponse, sendBuilderRequest);
            CancelAttestBuilderRequest cancelBuilderRequest = helper.buildRequest(new InputReference(),scenarioName, ssin, "MED",invoiceNumber);
            CancelAttestationResponse response = AttestSessionServiceFactory.getAttestService().cancelAttestation(cancelBuilderRequest.getCancelAttestationRequest());

            assertCancelResult(inputReference, scenarioName, "500", "MED", response, cancelBuilderRequest);
        }
    
        private void assertCancelResult(InputReference inputReference, String scenarioName, String oa, String profession, CancelAttestationResponse response, CancelAttestBuilderRequest cancelAttestBuilderRequest) {
	    	SignedBuilderResponse builderResponse = helper.getBuildCancelAttestResponse(response, cancelAttestBuilderRequest.getCancelAttestationRequest());
	        Assert.AreEqual(0, builderResponse.getSignatureVerificationResult().getErrors().size(), "SignatureVerificationResult should contain no error");
	        // check signedData is same as content of the business blob in the WS reponse
	        Assert.AreEqual(response.getReturn().getDetail().getValue(), builderResponse.getSignedData());
	        // check xadesT is same as the one from the WS reponse
	        Assert.AreEqual(response.getReturn().getXadesT().getValue(), builderResponse.getXadesT());      
	        String expectedResponse = helper.buildExpectedCancelAttestResponse(builderResponse, inputReference.getInputReference(),scenarioName, oa, profession);
	        be.fgov.ehealth.businessconnector.tests.utils.XmlAsserter.assertSimilar(expectedResponse, ConnectorXmlUtils.toString(builderResponse.getSendTransactionResponse()));
        }
	}
}
