/*
 * Copyright (c) eHealth
 */
package be.ehealth.technicalconnector.exception;

import static org.junit.Assert.assertEquals;

import java.text.MessageFormat;

import org.junit.Test;


/**
 * Test class for {@link SessionManagementException}
 * 
 * @author EHP
 * 
 * 
 * 
 */
public class SessionManagementExceptionTest {

    /**
     * Test method for
     * {@link be.ehealth.technicalconnector.exception.SessionManagementException#SessionManagementException(be.ehealth.technicalconnector.exception.SessionManagementExceptionValues, java.lang.Object[])}
     * .
     */
    @Test
    public void testSessionManagementExceptionSessionManagementExceptionValuesObjectArray() {
        SessionManagementExceptionValues errorValue = SessionManagementExceptionValues.ERROR_NOSESSION;
        SessionManagementException error = new SessionManagementException(errorValue);
        assertEquals(error.getErrorCode(), SessionManagementExceptionValues.ERROR_NOSESSION.getErrorCode());
        assertEquals(error.getMessage(), SessionManagementExceptionValues.ERROR_NOSESSION.getMessage());
    }

    /**
     * Test method for
     * {@link be.ehealth.technicalconnector.exception.SessionManagementException#SessionManagementException(be.ehealth.technicalconnector.exception.SessionManagementExceptionValues, java.lang.Throwable, java.lang.Object[])}
     * .
     */
    @Test
    public void testSessionManagementExceptionSessionManagementExceptionValuesParams() {
        SessionManagementExceptionValues errorValue = SessionManagementExceptionValues.ERROR_GENERAL;
        SessionManagementException error = new SessionManagementException(errorValue, "test");
        assertEquals(error.getErrorCode(), SessionManagementExceptionValues.ERROR_GENERAL.getErrorCode());
        assertEquals(error.getMessage(), MessageFormat.format(SessionManagementExceptionValues.ERROR_GENERAL.getMessage(), "test"));
    }

    /**
     * Test method for
     * {@link be.ehealth.technicalconnector.exception.SessionManagementException#SessionManagementException(be.ehealth.technicalconnector.exception.SessionManagementExceptionValues, java.lang.Throwable, java.lang.Object[])}
     * .
     */
    @Test
    public void testSessionManagementExceptionSessionManagementExceptionValuesThrowable() {
        SessionManagementExceptionValues errorValue = SessionManagementExceptionValues.ERROR_GENERAL;
        SessionManagementException error = new SessionManagementException(errorValue, new Throwable(), "test");
        assertEquals(error.getErrorCode(), SessionManagementExceptionValues.ERROR_GENERAL.getErrorCode());
        assertEquals(error.getMessage(), MessageFormat.format(SessionManagementExceptionValues.ERROR_GENERAL.getMessage(), "test"));
    }

}
