/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.test.genericasync.builders.impl;

import be.ehealth.businessconnector.genericasync.builders.impl.ResponseObjectBuilderImpl;
import org.junit.Test;

import be.cin.nip.async.generic.GetResponse;
import be.ehealth.businessconnector.genericasync.builders.ResponseObjectBuilder;
import be.ehealth.businessconnector.genericasync.exception.GenAsyncBusinessConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.ehealth.technicalconnector.utils.MarshallerHelper;


/**
 * tests the class {@link ResponseObjectBuilderImpl}.
 * 
 * @author EHP
 * 
 */
public class ResponseObjectBuilderImplTest {

    private ResponseObjectBuilder builder = new ResponseObjectBuilderImpl();


    /**
     * Test method for
     * {@link be.ehealth.businessconnector.genericasync.builders.impl.ResponseObjectBuilderImpl#handleGetResponse(be.cin.nip.async.generic.GetResponse)}
     * .
     */
    @Test
    public void testHandleGetResponseNoXades() throws GenAsyncBusinessConnectorException, TechnicalConnectorException {
        MarshallerHelper<GetResponse, GetResponse> helper = new MarshallerHelper<GetResponse, GetResponse>(GetResponse.class, GetResponse.class);
        builder.handleGetResponse(helper.toObject(ConnectorIOUtils.getBytes(ConnectorIOUtils.getResourceAsStream("/examples/GetResponseWithoutXades.xml"))));
    }


}
