/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.chapterIV.validators.impl;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import javax.xml.XMLConstants;
import javax.xml.validation.SchemaFactory;

import org.junit.Test;
import org.xml.sax.SAXException;

import be.ehealth.technicalconnector.validator.ValidatorHelper;


/**
 * some basic unit tests for {@link ValidatorHelper};
 * 
 * @author EHP
 * 
 */
public class AbstractValidatorImplTest {

    /**
     * Test method for {@link be.ehealth.technicalconnector.validator.impl.ValidatorHelper#createValidatorForSchemaFiles(java.util.List)}.
     * 
     * @throws SAXException
     */
    @Test
    public void testCreateValidatorForSomeSchemaFilesWithoutAgreementXsd() throws SAXException {
        List<String> someSchemaFiles = new ArrayList<String>();
        someSchemaFiles.add("/XSD/external/xmldsig-core-schema.xsd");
        someSchemaFiles.add("/XSD/external/saml_assertion.xsd");
        someSchemaFiles.add("/XSD/external/saml_protocol.xsd");
        someSchemaFiles.add("/XSD/external/xml.xsd");
        someSchemaFiles.add("/XSD/common/ehealth-commons-schema-core-1_4.xsd");
        someSchemaFiles.add("/XSD/common/ehealth-commons-schema-protocol-1_4.xsd");
        someSchemaFiles.add("/XSD/chapterIV_v1/commonTypes-v1.xsd");
        someSchemaFiles.add("/XSD/chapterIV_v1/commonInfo-v2-Basic.xsd");
        someSchemaFiles.add("/XSD/chapterIV_v1/commonInfo-v2-Ref.xsd");
        someSchemaFiles.add("/XSD/chapterIV_v1/commonInfo-v2.xsd");
        someSchemaFiles.add("/XSD/chapterIV_v1/chap4services-core-1_0.xsd");
        someSchemaFiles.add("/XSD/chapterIV_v1/chap4services-protocol-1_0.xsd");
        someSchemaFiles.add("/XSD/chapterIV_v1/chap4services-sealedcontent-1_0.xsd");
        someSchemaFiles.add("/XSD/chapterIV_v1/IO-BE-AskUnaddressed.xsd");
        someSchemaFiles.add("/XSD/chapterIV_v1/IO-BE-ConsultUnaddressed.xsd");
        someSchemaFiles.add("/XSD/chapterIV_v1/IO-IM-AskAddressed.xsd");
        someSchemaFiles.add("/XSD/chapterIV_v1/IO-IM-ConsultAddressed.xsd");
        someSchemaFiles.add("/XSD/chapterIV_v1/MCN_ask_encrypted_response.xsd");
        someSchemaFiles.add("/XSD/chapterIV_v1/MCN_consult_encrypted_response.xsd");
        // someSchemaFiles.add("/XSD/chapterIV_v1/MCN-ChapIV-AskMedicalAdvisorAgreement-v1.xsd");
        // someSchemaFiles.add("/XSD/chapterIV_v1/MCN-ChapIV-ConsultMedicalAdvisorAgreement-v1.xsd");

        // SealedRequestValidatorImpl validatorImpl = new SealedRequestValidatorImpl();
        // for (String schemaFile : someSchemaFiles) {
        // Validator validatorForSchemaFiles = validatorImpl.createValidatorForSchemaFiles(someSchemaFiles);
        // }
        // Assert.assertNotNull(validatorForSchemaFiles);
    }


    @Test
    public void testUrlSchemaLoader() throws Exception {
        String fileLocation = "/niccin-mycarenet-chapteriv/XSD/MCN_consult_encrypted_response.xsd";
        SchemaFactory schemaFactory = SchemaFactory.newInstance(XMLConstants.W3C_XML_SCHEMA_NS_URI);
        URL fileurl = ValidatorHelper.class.getResource(fileLocation);
        schemaFactory.newSchema(fileurl);
    }


}
