/*
 * Copyright (c) eHealth
 */
package be.ehealth.business.kmehrcommons.helper;

import java.util.List;

import org.junit.Assert;

import be.fgov.ehealth.standards.kmehr.cd.v1.CDERROR;
import be.fgov.ehealth.standards.kmehr.schema.v1.ErrorType;


/**
 * utility class to help log and check errors in a kmehr response.
 * 
 * @author EH058
 * 
 * @since
 * 
 */
public final class ErrorTypeManagement {

    /**
     * 
     */
    private ErrorTypeManagement() {
        super();
    }

    /**
     * check if the errors list contains one or more codes.
     * 
     * @param errors
     * @param codes
     */
    public static void doErrorsContainSpecificCode(List<ErrorType> errors, String... codes) {
        boolean found, failed = false;
        StringBuffer sb = new StringBuffer();
        for (String code : codes) {
            found = false;
            for (int i = 0; i < errors.size(); i++) {
                ErrorType error = errors.get(i);
                if (code.equals(error.getCds().get(0).getValue())) {
                    sb.append("code " + code + " found in error list \n");
                    errors.remove(error);
                    found = true;
                    i--;
                }
            }
            if (!found) {
                sb.append("code " + code + " expected but not found in errors list \n");
                failed = true;
            }
        }
        for (ErrorType error : errors) {
            sb.append("code " + error.getCds().get(0).getValue() + " found in errors list but not expected (" + error.getDescription().getValue() + ") \n");
            failed = true;
        }
        if (failed) {
            Assert.fail(sb.toString());
        }

    }

    public static String printErrorType(ErrorType error) {
        StringBuffer sb = new StringBuffer("errors codes = ");
        for (CDERROR cd : error.getCds()) {
            sb.append(cd.getValue() + " ");
        }
        sb.append("Description : " + error.getDescription().getValue() + " ");
        sb.append("url : " + error.getUrl());
        return sb.toString();
    }

    public static String printError(ErrorType error) {
        StringBuffer sb = new StringBuffer("errors codes = ");
        for (CDERROR cd : error.getCds()) {
            sb.append(cd.getValue() + " ");
        }
        sb.append("Description : " + error.getDescription().getValue() + " ");
        sb.append("url : " + error.getUrl());
        return sb.toString();
    }

    public static String printErrors(List<ErrorType> errors) {
        StringBuffer sb = new StringBuffer();
        for (ErrorType error : errors) {
            sb.append(printError(error));
        }
        return sb.toString();
    }

}
