/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.mycarenet.memberdata.session;

import be.ehealth.business.mycarenetdomaincommons.domain.InputReference;
import be.ehealth.businessconnector.mycarenet.memberdata.builders.BuilderStrategy;
import be.ehealth.businessconnector.mycarenet.memberdatacommons.builders.RequestObjectBuilderFactory;
import be.ehealth.businessconnector.mycarenet.memberdatacommons.exception.MemberDataBusinessConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.utils.SessionUtil;
import be.fgov.ehealth.mycarenet.memberdata.protocol.v1.MemberDataConsultationRequest;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.SessionRule;
import oasis.names.tc.saml._2_0.protocol.AttributeQuery;

import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import java.util.Arrays;
import java.util.Collection;

/**
 * MemberData Sync Integration Test for Physician.
 *
 * @author EHP
 */
@RunWith(Parameterized.class)
public class MemberDataPhysicianIntegrationTest extends AbstractBaseIntegrationTest {

    private static final String REQ_LOCATION = "/scenarios/requests/AttributeQuery-physician.xml";

    private static final String FIRST_PART_RESP_LOCATION = "/scenarios/response/physician/Response-physician-";

    private String response_location;

    @ClassRule
    public static SessionRule rule = SessionRule.withActiveSession().forEnvironment("acc").forProfession("persphysician").forUser("hannes").build();

    @Parameterized.Parameters(name = "{0} : {1}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"OA600", "67120143655"},
                {"OA600", "70021546287"},
                {"OA600", "23102820194"},
                {"OA600", "02091046548"},
                {"OA600", "82101921636"},
                {"OA600", "45011112215"},
                {"OA600", "27121516833"},
                {"OA600", "45112243029"},
                {"OA600", "42030833933"},
                {"OA600", "47100111242"},
                {"OA900", "57012803538"},
                {"OA900", "82062220229"},
                {"OA900", "45072705334"},
                {"OA900", "60122945519"},
                {"OA900", "99091447286"},
                {"OA900", "59082410780"},
                {"OA900", "25111903990"},
                {"OA900", "39010315202"},
                {"OA900", "30010705878"},
                {"OA900", "29021203633"},
                {"OA100","73052005540"}
        });
    }

    public MemberDataPhysicianIntegrationTest(String oa, String patient_niss) throws TechnicalConnectorException {

        super(SessionUtil.getNihii11(), patient_niss);
        response_location = FIRST_PART_RESP_LOCATION + oa + "-" + patient_niss + ".xml";

    }

    @Test
    public void consultationAttrQueryWithoutEncryption() throws Exception {
        consultationTest(REQ_LOCATION, response_location,
                new BuilderStrategy() {
                    @Override
                    public MemberDataConsultationRequest build(boolean isTest, InputReference inputReference, AttributeQuery attributeQuery) throws MemberDataBusinessConnectorException, TechnicalConnectorException {
                        return RequestObjectBuilderFactory.getNotEncryptedRequestObjectBuilder().buildConsultationRequest(true, inputReference, attributeQuery);
                    }
                });
    }

    @Test
    public void consultationAttrQueryWithEncryption() throws Exception {
        consultationTest(REQ_LOCATION, response_location,
                new BuilderStrategy() {
                    @Override
                    public MemberDataConsultationRequest build(boolean isTest, InputReference inputReference, AttributeQuery attributeQuery) throws MemberDataBusinessConnectorException, TechnicalConnectorException {
                        return RequestObjectBuilderFactory.getEncryptedRequestObjectBuilder().buildConsultationRequest(true, inputReference, attributeQuery);
                    }
                });
    }
}
