package be.ehealth.businessconnector.mycarenet.agreement.session;

import be.ehealth.business.common.domain.Patient;
import be.ehealth.business.mycarenetdomaincommons.domain.InputReference;
import be.ehealth.businessconnector.mycarenet.agreement.builders.ResponseObjectBuilder;
import be.ehealth.businessconnector.mycarenet.agreement.builders.ResponseObjectBuilderFactory;
import be.ehealth.businessconnector.mycarenet.agreement.domain.AskAgreementBuilderRequest;
import be.ehealth.businessconnector.mycarenet.agreement.domain.ConsultAgreementBuilderRequest;
import be.ehealth.businessconnector.mycarenet.agreement.domain.SignedEncryptedBuilderResponse;
import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.ConfigValidator;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.ehealth.technicalconnector.utils.ConnectorXmlUtils;
import be.ehealth.technicalconnector.utils.SessionUtil;
import be.fgov.ehealth.mycarenet.agreement.protocol.v1.AskAgreementResponse;
import be.fgov.ehealth.mycarenet.agreement.protocol.v1.ConsultAgreementResponse;
import org.joda.time.DateTime;
import org.junit.Assert;

import static be.ehealth.businessconnector.mycarenet.agreement.builders.RequestObjectBuilderFactory.getEncryptedRequestObjectBuilder;
import static be.ehealth.technicalconnector.enumeration.Charset.UTF_8;

public abstract class AbstractBaseIntegrationTest {

    private final String patientNiss;

    private final String professionalNihii;

    protected AbstractBaseIntegrationTest() throws TechnicalConnectorException {
        this.professionalNihii = SessionUtil.getNihii11();
        this.patientNiss = "72070539942";
    }

    protected void askAgreementTest(String bundleLocation) throws Exception {
        AgreementService service = AgreementSessionServiceFactory.getAgreementService();
        ResponseObjectBuilder responseBuilder = ResponseObjectBuilderFactory.getResponseObjectBuilder();

        String id = "01-KIN-EMEHS";
        byte[] bundle = ConnectorIOUtils.getResourceAsString(bundleLocation).getBytes(UTF_8.getName());
        ConnectorXmlUtils.dump(bundle);

        Patient patientInfo = new Patient();
        patientInfo.setInss(patientNiss);

        // input reference and AttributeQuery ID must match
        InputReference inputReference = new InputReference(id);
        AskAgreementBuilderRequest requestBuilder = getEncryptedRequestObjectBuilder().buildAskAgreementRequest(true, inputReference, patientInfo, new DateTime(), bundle);

        AskAgreementResponse response = service.askAgreement(requestBuilder.getRequest());
        assertResponse(responseBuilder.handleAskAgreementResponse(response, requestBuilder));
    }


    protected void consultAgreementTest(String bundleLocation) throws Exception {
        AgreementService service = AgreementSessionServiceFactory.getAgreementService();
        ResponseObjectBuilder responseBuilder = ResponseObjectBuilderFactory.getResponseObjectBuilder();

        String id = "01-KIN-EMEHS";
        byte[] bundle = ConnectorIOUtils.getResourceAsString(bundleLocation).getBytes(UTF_8.getName());
        ConnectorXmlUtils.dump(bundle);

        Patient patientInfo = new Patient();
        patientInfo.setInss(patientNiss);

        // input reference and AttributeQuery ID must match
        InputReference inputReference = new InputReference(id);
        ConsultAgreementBuilderRequest requestBuilder = getEncryptedRequestObjectBuilder().buildConsultAgreementRequest(true, inputReference, patientInfo, new DateTime(), bundle);

        ConsultAgreementResponse response = service.consultAgreement(requestBuilder.getRequest());
        assertResponse(responseBuilder.handleConsultAgreementResponse(response, requestBuilder));
    }


    private void assertResponse(SignedEncryptedBuilderResponse response) throws TechnicalConnectorException {
        Assert.assertTrue("Errors found in the signature verification", response.getSignatureVerificationResult().isValid());
        Assert.assertNotNull(response.getXades());
        Assert.assertNotNull(response.getSignedData());
        Assert.assertNotNull(response.getRawDecryptedBlob());
   }
}
