package be.ehealth.businessconnector.mediprimav2.builder;

import java.util.GregorianCalendar;

import javax.xml.datatype.DatatypeConfigurationException;

import org.joda.time.DateTime;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.idgenerator.IdGeneratorFactory;
import be.fgov.ehealth.mediprima.core.v2.BySsinType;
import be.fgov.ehealth.mediprima.core.v2.ConsultCarmedDataType;
import be.fgov.ehealth.mediprima.core.v2.PeriodType;
import be.fgov.ehealth.mediprima.protocol.v2.ConsultCarmedInterventionRequest;

/**
 * @author EHP
 */

public class ConsultCarmedInterventionRequestBuilder {
    private ConsultCarmedInterventionRequest consultCarmedInterventionRequest;
    private BySsinType bySsinType ;
    private PeriodType periodType ;

    public static ConsultCarmedInterventionRequestBuilder aRequest() throws TechnicalConnectorException, DatatypeConfigurationException {
        return new ConsultCarmedInterventionRequestBuilder();
    }

    private ConsultCarmedInterventionRequestBuilder() throws TechnicalConnectorException, DatatypeConfigurationException {
        consultCarmedInterventionRequest = new ConsultCarmedInterventionRequest();
        String requestId = IdGeneratorFactory.getIdGenerator(IdGeneratorFactory.XSID).generateId();
        consultCarmedInterventionRequest.setId(requestId);

        GregorianCalendar c = new GregorianCalendar();
        c.setTime(new DateTime().toDate());

        consultCarmedInterventionRequest.setIssueInstant(new DateTime());
        ConsultCarmedDataType consultCarmedDataType = new ConsultCarmedDataType();
        bySsinType = new BySsinType();
        consultCarmedDataType.setBySsin(bySsinType);
        consultCarmedInterventionRequest.setSelectionCriteria(consultCarmedDataType);
    }

    public ConsultCarmedInterventionRequestBuilder withSsin(String ssin) {
        bySsinType.setSsin(ssin);
        return this;
    }

    public ConsultCarmedInterventionRequestBuilder withReferenceDate(DateTime referenceDate) {
        bySsinType.setReferenceDate(referenceDate);
        return this;
    }

    public ConsultCarmedInterventionRequestBuilder withPeriod() {
        periodType = new PeriodType();
        bySsinType.setPeriod(periodType);
        periodType.setStartDate(new DateTime());
        periodType.setEndDate(new DateTime());
        return this;
    }

    public ConsultCarmedInterventionRequestBuilder withStartPeriod(DateTime startPeriod) {
        periodType = new PeriodType();
        bySsinType.setPeriod(periodType);
        periodType.setStartDate(startPeriod);
        return this;
    }

    public ConsultCarmedInterventionRequestBuilder withEndPeriod(DateTime endPeriod) {
        periodType.setEndDate(endPeriod);
        return this;
    }

    public ConsultCarmedInterventionRequest build() {
        return consultCarmedInterventionRequest;
    }
}
