/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.insurability.build;

import java.math.BigDecimal;

import org.joda.time.DateTime;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.unitils.reflectionassert.ReflectionAssert;
import org.unitils.reflectionassert.ReflectionComparatorMode;

import be.ehealth.businessconnector.insurability.builders.RequestObjectBuilder;
import be.ehealth.businessconnector.insurability.builders.impl.RequestObjectBuilderImpl;
import be.ehealth.businessconnector.insurability.domain.InsurabilityReferences;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.session.Session;
import be.fgov.ehealth.insurability.core.v1.CareReceiverIdType;
import be.fgov.ehealth.insurability.core.v1.InsurabilityForPharmacistRequest;
import be.fgov.ehealth.insurability.protocol.v1.GetInsurabilityForPharmacistRequest;
import be.fgov.ehealth.technicalconnector.tests.session.SessionInitializer;

/**
 * Unit test for the builder.
 * 
 * @author EH054
 * 
 */
public class RequestObjetBuilderTest {

    @BeforeClass
    public static void init() throws Exception {
        SessionInitializer.init("/be.ehealth.businessconnector.insurability.test.properties", false);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        Session.getInstance().unloadSession();
    }

    @Test
    public void defaultTest() throws TechnicalConnectorException {
        generateTest("91121208397", "0319-UNMS", "3199134608317315635", "Consultation", "1", "2", "3");
    }

    public void generateTest(String ssin, String mutuality, String registNumber, String requestType, String commonNipReference, String commonReference, String recordId) throws TechnicalConnectorException {
        RequestObjectBuilder requestObjectBuilder = new RequestObjectBuilderImpl();
        GetInsurabilityForPharmacistRequest insurabilityRequest;

        InsurabilityReferences references = new InsurabilityReferences(commonNipReference);
        InsurabilityForPharmacistRequest request = new InsurabilityForPharmacistRequest();
        CareReceiverIdType careReceiverId = new CareReceiverIdType();

        references.setCommonReference(commonReference);
        references.setRecordCommonInputId(recordId);

        careReceiverId.setSsin(ssin);
        careReceiverId.setMutuality(mutuality);
        careReceiverId.setRegNrWithMut(registNumber);

        request.setCareReceiver(careReceiverId);
        request.setDate(new DateTime());
        request.setRequestType(requestType);

        insurabilityRequest = requestObjectBuilder.buildInsurabilityForPharmacistRequest(false, references, request);

        // Asserts
        ReflectionAssert.assertReflectionEquals(request, insurabilityRequest.getInsurabilityRequest(), ReflectionComparatorMode.LENIENT_ORDER);

        Assert.assertEquals(references.getRecordCommonInputId(), insurabilityRequest.getRecordCommonInput().getUserReference());
        Assert.assertEquals(references.getRecordCommonInputId(), insurabilityRequest.getRecordCommonInput().getUserReference());
        if (references.getCommonReference() != null) {
            Assert.assertEquals(new BigDecimal(references.getCommonReference()), insurabilityRequest.getRecordCommonInput().getReference());
        } else {
            Assert.assertNull(insurabilityRequest.getRecordCommonInput().getReference());
        }
        Assert.assertEquals(false, insurabilityRequest.getCommonInput().getRequest().isIsTest());
    }

}
